/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.project.Project;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandState;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.DelegateCommandListener;
import com.maddyhome.idea.vim.helper.DigraphSequence;
import com.maddyhome.idea.vim.helper.EditorData;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.RunnableHelper;
import com.maddyhome.idea.vim.key.ArgumentNode;
import com.maddyhome.idea.vim.key.BranchNode;
import com.maddyhome.idea.vim.key.CommandNode;
import com.maddyhome.idea.vim.key.KeyParser;
import com.maddyhome.idea.vim.key.Node;
import com.maddyhome.idea.vim.option.Options;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.KeyStroke;

public class KeyHandler {
    private int count;
    private List<KeyStroke> keys;
    private int mode;
    private Stack<Command> currentCmd = new Stack();
    private int currentArg;
    private TypedActionHandler origHandler;
    private DigraphSequence digraph = null;
    private char lastChar;
    private boolean lastWasBS;
    private static KeyHandler instance;
    private static final int STATE_NEW_COMMAND = 1;
    private static final int STATE_COMMAND = 2;
    private static final int STATE_READY = 3;
    private static final int STATE_ERROR = 4;
    private static final int STATE_BAD_COMMAND = 5;
    private static Logger logger;

    public static KeyHandler getInstance() {
        if (instance == null) {
            instance = new KeyHandler();
        }
        return instance;
    }

    private KeyHandler() {
        this.reset(null);
    }

    public void setOriginalHandler(TypedActionHandler origHandler) {
        this.origHandler = origHandler;
    }

    public TypedActionHandler getOriginalHandler() {
        return this.origHandler;
    }

    public void handleKey(Editor editor, KeyStroke key, DataPackage context) {
        logger.debug("handleKey " + key);
        CommandState editorState = CommandState.getInstance(editor);
        boolean isRecording = editorState.isRecording();
        boolean shouldRecord = true;
        block14: for (int loop = 0; loop < 2; ++loop) {
            Command cmd;
            char chKey;
            char c = chKey = key.getKeyChar() == '\uffff' ? (char)'\u0000' : key.getKeyChar();
            if ((editorState.getMode() == 1 || this.mode == 2) && (key.getKeyCode() == 27 || key.getKeyCode() == 67 && (key.getModifiers() & 2) != 0 || key.getKeyCode() == 91 && (key.getModifiers() & 2) != 0)) {
                if (this.mode != 2 && this.count == 0 && this.currentArg == 0 && this.currentCmd.size() == 0 && CommandGroups.getInstance().getRegister().getCurrentRegister() == '\"') {
                    if (key.getKeyCode() == 27) {
                        KeyHandler.executeAction("VimEditorEscape", context);
                    }
                    VimPlugin.indicateError();
                }
                this.reset(editor);
                break;
            }
            if (!(editorState.getMode() != 1 && editorState.getMode() != 5 || this.mode != 1 || this.currentArg == 2 || this.currentArg == 4 || !Character.isDigit(chKey) || this.count == 0 && chKey == '0')) {
                this.count = this.count * 10 + (chKey - 48);
                logger.debug("count now " + this.count);
                break;
            }
            if ((editorState.getMode() == 1 || editorState.getMode() == 5) && this.mode == 1 && this.currentArg != 2 && this.currentArg != 4 && key.getKeyCode() == 127 && this.count != 0) {
                this.count /= 10;
                logger.debug("count now " + this.count);
                break;
            }
            if (this.currentArg == 2) {
                logger.debug("currentArg is Character");
                if (chKey == '\u0000') {
                    switch (key.getKeyCode()) {
                        case 9: {
                            chKey = '\t';
                            break;
                        }
                        case 10: {
                            chKey = '\n';
                        }
                    }
                }
                if (chKey != '\u0000') {
                    Argument arg = new Argument(chKey);
                    Command cmd2 = this.currentCmd.peek();
                    cmd2.setArgument(arg);
                    this.mode = 3;
                    break;
                }
                this.mode = 5;
                break;
            }
            this.keys.add(key);
            if (logger.isDebugEnabled()) {
                logger.debug("keys now " + this.keys);
            }
            Node node = editorState.getCurrentNode().getChild(key);
            if (this.digraph == null && !(node instanceof CommandNode) && DigraphSequence.isDigraphStart(key)) {
                this.digraph = new DigraphSequence();
            }
            if (this.digraph != null) {
                DigraphSequence.DigraphResult res = this.digraph.processKey(key, editor, context);
                switch (res.getResult()) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        this.digraph = null;
                        return;
                    }
                    case 2: {
                        if (this.currentArg == 4) {
                            this.currentArg = 2;
                        }
                        key = res.getStroke();
                        this.digraph = null;
                        continue block14;
                    }
                    default: {
                        logger.debug("digraph done");
                    }
                }
            }
            if (node instanceof BranchNode) {
                logger.debug("branch node");
                BranchNode bnode = (BranchNode)node;
                if ((bnode.getFlags() & 0x4000) == 0) {
                    this.mode = 2;
                }
                editorState.setCurrentNode(bnode);
                ArgumentNode arg = (ArgumentNode)((BranchNode)editorState.getCurrentNode()).getArgumentNode();
                if (arg == null) break;
                if (editorState.isRecording() && (arg.getFlags() & 0x8000000) != 0) {
                    this.handleKey(editor, KeyStroke.getKeyStroke(' '), context);
                }
                if (arg.getArgType() != 5) break;
                CommandGroups.getInstance().getProcess().startSearchCommand(editor, context, this.count, chKey);
                this.mode = 1;
                this.currentArg = 5;
                editorState.pushState(6, 0, 16);
                break;
            }
            if (node instanceof CommandNode) {
                logger.debug("command node");
                this.mode = 3;
                CommandNode cmdNode = (CommandNode)node;
                if (this.currentArg == 1) {
                    if (cmdNode.getCmdType() == 1) {
                        cmd = new Command(this.count, cmdNode.getActionId(), cmdNode.getAction(), cmdNode.getCmdType(), cmdNode.getFlags());
                        cmd.setKeys(this.keys);
                        this.currentCmd.push(cmd);
                        break;
                    }
                    if (cmdNode.getCmdType() == 7) {
                        this.currentCmd.clear();
                        cmd = new Command(1, cmdNode.getActionId(), cmdNode.getAction(), cmdNode.getCmdType(), cmdNode.getFlags());
                        cmd.setKeys(this.keys);
                        this.currentCmd.push(cmd);
                        break;
                    }
                    this.mode = 5;
                    break;
                }
                if (this.currentArg == 5 && (cmdNode.getFlags() & 0x20000000) != 0) {
                    String text = CommandGroups.getInstance().getProcess().endSearchCommand(editor, context);
                    Argument arg = new Argument(text);
                    Command cmd3 = this.currentCmd.peek();
                    cmd3.setArgument(arg);
                    CommandState.getInstance(editor).popState();
                    break;
                }
                cmd = new Command(this.count, cmdNode.getActionId(), cmdNode.getAction(), cmdNode.getCmdType(), cmdNode.getFlags());
                cmd.setKeys(this.keys);
                this.currentCmd.push(cmd);
                if (cmd.getAction() != null) break;
                logger.error("NULL action for keys '" + this.keys + "'");
                this.mode = 4;
                break;
            }
            if (node instanceof ArgumentNode) {
                logger.debug("argument node");
                ArgumentNode arg = (ArgumentNode)node;
                cmd = new Command(this.count, arg.getActionId(), arg.getAction(), arg.getCmdType(), arg.getFlags());
                cmd.setKeys(this.keys);
                this.currentCmd.push(cmd);
                switch (arg.getArgType()) {
                    case 4: {
                        this.digraph = new DigraphSequence();
                    }
                    case 1: 
                    case 2: {
                        this.mode = 1;
                        this.currentArg = arg.getArgType();
                        if ((arg.getFlags() & 0x1000000) == 0) break;
                        editorState.pushState(editorState.getMode(), editorState.getSubMode(), 4);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    default: {
                        this.mode = 4;
                    }
                }
                if (this.currentArg == 0) break;
                this.partialReset(editor);
                boolean saveRecording = isRecording;
                this.handleKey(editor, key, context);
                isRecording = saveRecording;
                shouldRecord = false;
                break;
            }
            logger.debug("checking for digraph");
            logger.debug("lastWasBS=" + this.lastWasBS);
            logger.debug("lastChar=" + this.lastChar);
            if (this.lastWasBS && this.lastChar != '\u0000' && Options.getInstance().isSet("digraph")) {
                char dig = CommandGroups.getInstance().getDigraph().getDigraph(this.lastChar, key.getKeyChar());
                logger.debug("dig=" + dig);
                key = KeyStroke.getKeyStroke(dig);
            }
            if (editorState.getMode() == 2 || editorState.getMode() == 3) {
                if (!CommandGroups.getInstance().getChange().processKey(editor, context, key)) {
                    shouldRecord = false;
                }
            } else if (editorState.getMappingMode() == 16) {
                if (!CommandGroups.getInstance().getProcess().processExKey(editor, context, key, true)) {
                    shouldRecord = false;
                }
            } else {
                this.mode = 5;
            }
            this.lastChar = key.getKeyChar();
            this.partialReset(editor);
            break;
        }
        if (this.mode == 3) {
            DelegateCommandListener.getInstance().setRunnable(null);
            Command cmd = this.currentCmd.pop();
            while (this.currentCmd.size() > 0) {
                Command top = this.currentCmd.pop();
                top.setArgument(new Argument(cmd));
                cmd = top;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("cmd=" + cmd);
            }
            Argument arg = cmd.getArgument();
            if (logger.isDebugEnabled()) {
                logger.debug("arg=" + arg);
            }
            if (arg != null && arg.getType() == 1) {
                Command mot = arg.getMotion();
                int cnt = cmd.getRawCount() == 0 && mot.getRawCount() == 0 ? 0 : cmd.getCount() * mot.getCount();
                cmd.setCount(0);
                mot.setCount(cnt);
            }
            if (editorState.getMappingMode() == 4) {
                editorState.popState();
            }
            editorState.setCommand(cmd);
            this.lastWasBS = (cmd.getFlags() & 0x800) != 0;
            logger.debug("lastWasBS=" + this.lastWasBS);
            Project project = EditorData.getProject(editor);
            if (cmd.isReadType() || EditorHelper.canEdit(project, editor)) {
                ActionRunner action = new ActionRunner(editor, context, cmd, key);
                if (cmd.isWriteType()) {
                    RunnableHelper.runWriteCommand(project, action, cmd.getActionId(), null);
                } else {
                    RunnableHelper.runReadCommand(project, action, cmd.getActionId(), null);
                }
            } else {
                logger.info("write command on read-only file");
                VimPlugin.indicateError();
                this.reset(editor);
            }
        } else if (this.mode == 5) {
            VimPlugin.indicateError();
            this.reset(editor);
        } else if (this.mode == 4) {
            VimPlugin.indicateError();
            this.fullReset(editor);
        } else if (isRecording && shouldRecord) {
            CommandGroups.getInstance().getRegister().addKeyStroke(key);
        }
    }

    public static void executeAction(String name, DataPackage context) {
        logger.debug("executing action " + name);
        ActionManager aMgr = ActionManager.getInstance();
        AnAction action = aMgr.getAction(name);
        if (action != null) {
            KeyHandler.executeAction(action, context);
        } else {
            logger.debug("Unknown action");
        }
    }

    public static void executeAction(AnAction action, DataPackage context) {
        if (logger.isDebugEnabled()) {
            logger.debug("executing action " + action);
        }
        action.actionPerformed(new AnActionEvent(null, context.getDataContext(), "", action.getTemplatePresentation(), ActionManager.getInstance(), 0));
    }

    private void partialReset(Editor editor) {
        this.count = 0;
        this.keys = new ArrayList<KeyStroke>();
        CommandState editorState = CommandState.getInstance(editor);
        editorState.setCurrentNode(KeyParser.getInstance().getKeyRoot(editorState.getMappingMode()));
        logger.debug("partialReset");
    }

    public void reset(Editor editor) {
        this.partialReset(editor);
        this.mode = 1;
        this.currentCmd.clear();
        this.currentArg = 0;
        this.digraph = null;
        logger.debug("reset");
    }

    public void fullReset(Editor editor) {
        CommandState.getInstance(editor).reset();
        this.reset(editor);
        this.lastChar = '\u0000';
        this.lastWasBS = false;
        CommandGroups.getInstance().getRegister().resetRegister();
        DelegateCommandListener.getInstance().setRunnable(null);
    }

    static {
        logger = Logger.getInstance((String)KeyHandler.class.getName());
    }

    static class ActionRunner
    implements Runnable {
        private Editor editor;
        private DataPackage context;
        private Command cmd;
        private KeyStroke key;

        public ActionRunner(Editor editor, DataPackage context, Command cmd, KeyStroke key) {
            this.editor = editor;
            this.context = context;
            this.cmd = cmd;
            this.key = key;
        }

        public void run() {
            CommandState editorState = CommandState.getInstance(this.editor);
            boolean wasRecording = editorState.isRecording();
            KeyHandler.executeAction(this.cmd.getAction(), this.context);
            if (editorState.getMode() == 2 || editorState.getMode() == 3) {
                CommandGroups.getInstance().getChange().processCommand(this.editor, this.context, this.cmd);
            }
            if (this.cmd.getType() != 8) {
                CommandGroups.getInstance().getRegister().resetRegister();
            }
            if (editorState.getSubMode() == 1 && (this.cmd.getFlags() & 0x4000000) == 0) {
                editorState.popState();
            }
            KeyHandler.getInstance().reset(this.editor);
            if (wasRecording && editorState.isRecording()) {
                CommandGroups.getInstance().getRegister().addKeyStroke(this.key);
            }
        }
    }
}

