/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimTypedActionHandler;
import com.maddyhome.idea.vim.command.CommandState;
import com.maddyhome.idea.vim.ex.CommandParser;
import com.maddyhome.idea.vim.group.ChangeGroup;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.group.FileGroup;
import com.maddyhome.idea.vim.group.MarkGroup;
import com.maddyhome.idea.vim.group.MotionGroup;
import com.maddyhome.idea.vim.group.SearchGroup;
import com.maddyhome.idea.vim.helper.ApiHelper;
import com.maddyhome.idea.vim.helper.DelegateCommandListener;
import com.maddyhome.idea.vim.helper.DocumentManager;
import com.maddyhome.idea.vim.helper.EditorData;
import com.maddyhome.idea.vim.key.RegisterActions;
import com.maddyhome.idea.vim.option.Options;
import com.maddyhome.idea.vim.undo.UndoManager;
import java.awt.Toolkit;
import java.util.ArrayList;
import org.jdom.Element;

public class VimPlugin
implements ApplicationComponent,
JDOMExternalizable {
    private static VimPlugin instance;
    private VimTypedActionHandler vimHandler;
    private RegisterActions actions;
    private boolean isBlockCursor = false;
    private boolean isSmoothScrolling = false;
    private boolean enabled = true;
    private static Logger logger;

    public VimPlugin() {
        logger.debug("VimPlugin ctr");
        instance = this;
    }

    public static VimPlugin getInstance() {
        return instance;
    }

    public String getComponentName() {
        return "VimPlugin";
    }

    public void initComponent() {
        logger.debug("initComponent");
        EditorActionManager manager = EditorActionManager.getInstance();
        TypedAction action = manager.getTypedAction();
        this.vimHandler = new VimTypedActionHandler(action.getHandler());
        action.setupHandler((TypedActionHandler)this.vimHandler);
        this.setupListeners();
        this.getActions();
        logger.debug("done");
    }

    private void setupListeners() {
        DocumentManager.getInstance().addDocumentListener((DocumentListener)new MarkGroup.MarkUpdater());
        DocumentManager.getInstance().addDocumentListener((DocumentListener)new UndoManager.DocumentChangeListener());
        if (ApiHelper.supportsColorSchemes()) {
            DocumentManager.getInstance().addDocumentListener((DocumentListener)new SearchGroup.DocumentSearchListener());
        }
        DocumentManager.getInstance().init();
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new EditorFactoryAdapter(){

            public void editorCreated(EditorFactoryEvent event) {
                VimPlugin.this.isBlockCursor = event.getEditor().getSettings().isBlockCursor();
                VimPlugin.this.isSmoothScrolling = event.getEditor().getSettings().isAnimatedScrolling();
                if (VimPlugin.isEnabled()) {
                    event.getEditor().getSettings().setBlockCursor(!CommandState.inInsertMode(event.getEditor()));
                    event.getEditor().getSettings().setAnimatedScrolling(false);
                }
                EditorData.initializeEditor(event.getEditor());
                DocumentManager.getInstance().addListeners(event.getEditor().getDocument());
            }

            public void editorReleased(EditorFactoryEvent event) {
                EditorData.uninitializeEditor(event.getEditor());
                event.getEditor().getSettings().setAnimatedScrolling(VimPlugin.this.isSmoothScrolling);
                DocumentManager.getInstance().removeListeners(event.getEditor().getDocument());
            }
        });
        ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){
            ArrayList<FileEditorManagerListener> listeners = new ArrayList();

            public void projectOpened(Project project) {
                FileEditorManagerAdapter l = new ChangeGroup.InsertCheck();
                this.listeners.add((FileEditorManagerListener)l);
                l = new MotionGroup.MotionEditorChange();
                this.listeners.add((FileEditorManagerListener)l);
                l = new FileGroup.SelectionCheck();
                this.listeners.add((FileEditorManagerListener)l);
                if (ApiHelper.supportsColorSchemes()) {
                    l = new SearchGroup.EditorSelectionCheck();
                    this.listeners.add((FileEditorManagerListener)l);
                }
                for (FileEditorManagerListener listener : this.listeners) {
                    FileEditorManager.getInstance((Project)project).addFileEditorManagerListener(listener);
                }
            }

            public void projectClosed(Project project) {
                for (FileEditorManagerListener listener : this.listeners) {
                    FileEditorManager.getInstance((Project)project).removeFileEditorManagerListener(listener);
                }
                this.listeners.clear();
            }
        });
        CommandProcessor.getInstance().addCommandListener((CommandListener)DelegateCommandListener.getInstance());
    }

    public void disposeComponent() {
        logger.debug("disposeComponent");
        VimPlugin.setEnabled(false);
        EditorActionManager manager = EditorActionManager.getInstance();
        TypedAction action = manager.getTypedAction();
        action.setupHandler(this.vimHandler.getOriginalTypedHandler());
        logger.debug("done");
    }

    public void readExternal(Element element) throws InvalidDataException {
        logger.debug("readExternal");
        Element state = element.getChild("state");
        if (state != null) {
            this.enabled = Boolean.valueOf(state.getAttributeValue("enabled"));
        }
        CommandGroups.getInstance().readData(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        logger.debug("writeExternal");
        Element elem = new Element("state");
        elem.setAttribute("enabled", Boolean.toString(this.enabled));
        element.addContent(elem);
        CommandGroups.getInstance().saveData(element);
    }

    public static boolean isEnabled() {
        return VimPlugin.getInstance().enabled;
    }

    public static void setEnabled(boolean set) {
        if (!set) {
            VimPlugin.getInstance().turnOffPlugin();
        }
        VimPlugin.getInstance().enabled = set;
        if (set) {
            VimPlugin.getInstance().turnOnPlugin();
        }
    }

    public static void indicateError() {
        if (!Options.getInstance().isSet("visualbell")) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public static void showMode(String msg) {
        VimPlugin.showMessage(msg);
    }

    public static void showMessage(String msg) {
        Project[] projs;
        ProjectManager pm = ProjectManager.getInstance();
        for (Project proj : projs = pm.getOpenProjects()) {
            StatusBar bar = WindowManager.getInstance().getStatusBar(proj);
            if (msg == null || msg.length() == 0) {
                bar.setInfo("");
                continue;
            }
            bar.setInfo("VIM - " + msg);
        }
    }

    public void turnOnPlugin() {
        KeyHandler.getInstance().fullReset(null);
        this.setCursors(true);
        this.setSmoothScrolling(false);
    }

    public void turnOffPlugin() {
        KeyHandler.getInstance().fullReset(null);
        this.setCursors(this.isBlockCursor);
        this.setSmoothScrolling(this.isSmoothScrolling);
    }

    private void setCursors(boolean isBlock) {
        Editor[] editors;
        for (Editor editor : editors = EditorFactory.getInstance().getAllEditors()) {
            editor.getSettings().setBlockCursor(isBlock);
        }
    }

    private void setSmoothScrolling(boolean isOn) {
        Editor[] editors;
        for (Editor editor : editors = EditorFactory.getInstance().getAllEditors()) {
            editor.getSettings().setAnimatedScrolling(isOn);
        }
    }

    private RegisterActions getActions() {
        if (this.actions == null) {
            this.actions = RegisterActions.getInstance();
            CommandParser.getInstance().registerHandlers();
        }
        return this.actions;
    }

    static {
        logger = Logger.getInstance((String)VimPlugin.class.getName());
    }

    public static class VimPluginToggleAction
    extends ToggleAction {
        public boolean isSelected(AnActionEvent event) {
            return VimPlugin.isEnabled();
        }

        public void setSelected(AnActionEvent event, boolean b) {
            VimPlugin.setEnabled(b);
        }
    }
}

