/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.helper.DataPackage;
import javax.swing.KeyStroke;

public class VimTypedActionHandler
implements TypedActionHandler {
    private TypedActionHandler origHandler;
    private KeyHandler handler;
    private static Logger logger = Logger.getInstance((String)VimTypedActionHandler.class.getName());

    public VimTypedActionHandler(TypedActionHandler origHandler) {
        this.origHandler = origHandler;
        this.handler = KeyHandler.getInstance();
        this.handler.setOriginalHandler(origHandler);
    }

    public TypedActionHandler getOriginalTypedHandler() {
        return this.origHandler;
    }

    public void execute(Editor editor, char charTyped, DataContext context) {
        if (!VimPlugin.isEnabled()) {
            this.origHandler.execute(editor, charTyped, context);
            return;
        }
        try {
            this.handler.handleKey(editor, KeyStroke.getKeyStroke(charTyped), new DataPackage(context));
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }
}

