/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.action.AbstractDelegateAction;
import com.maddyhome.idea.vim.helper.DataPackage;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

public class PassThruDelegateAction
extends AbstractDelegateAction {
    private KeyStroke stroke;
    private static Logger logger = Logger.getInstance((String)PassThruDelegateAction.class.getName());

    public PassThruDelegateAction(KeyStroke stroke) {
        this.stroke = stroke;
    }

    public void actionPerformed(AnActionEvent event) {
        Editor editor;
        if (logger.isDebugEnabled()) {
            logger.debug("actionPerformed key=" + this.stroke);
        }
        if ((editor = (Editor)event.getData(DataKeys.EDITOR)) == null || !VimPlugin.isEnabled()) {
            this.getOrigAction().actionPerformed(event);
        } else if (event.getInputEvent() instanceof KeyEvent) {
            KeyStroke key = KeyStroke.getKeyStrokeForEvent((KeyEvent)event.getInputEvent());
            if (logger.isDebugEnabled()) {
                logger.debug("event = KeyEvent: " + key);
            }
            KeyHandler.getInstance().handleKey(editor, key, new DataPackage(event));
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("event is a " + event.getInputEvent().getClass().getName());
            }
            KeyHandler.getInstance().handleKey(editor, this.stroke, new DataPackage(event));
        }
    }
}

