/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.action;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.action.AbstractDelegateEditorAction;
import com.maddyhome.idea.vim.helper.DataPackage;
import javax.swing.KeyStroke;

public class PassThruDelegateEditorAction
extends AbstractDelegateEditorAction {
    private static Logger logger = Logger.getInstance((String)PassThruDelegateEditorAction.class.getName());

    public PassThruDelegateEditorAction(KeyStroke stroke, EditorActionHandler origHandler) {
        super(new MyHandler(stroke, origHandler));
    }

    private static class MyHandler
    extends EditorActionHandler {
        private KeyStroke stroke;
        private EditorActionHandler origHandler;

        public MyHandler(KeyStroke stroke, EditorActionHandler handler) {
            this.stroke = stroke;
            this.origHandler = handler;
        }

        public void execute(Editor editor, DataContext dataContext) {
            if (logger.isDebugEnabled()) {
                logger.debug("actionPerformed key=" + this.stroke);
            }
            if (editor == null || !VimPlugin.isEnabled()) {
                this.origHandler.execute(editor, dataContext);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("event = KeyEvent: " + this.stroke);
                }
                KeyHandler.getInstance().handleKey(editor, this.stroke, new DataPackage(dataContext));
            }
        }
    }
}

