/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.action.AbstractDelegateAction;
import com.maddyhome.idea.vim.undo.UndoManager;

public class TxActionWrapper
extends AbstractDelegateAction {
    private static Logger logger = Logger.getInstance((String)TxActionWrapper.class.getName());

    public TxActionWrapper() {
    }

    public TxActionWrapper(AnAction origAction) {
        super(origAction);
    }

    public void actionPerformed(AnActionEvent event) {
        logger.debug("actionPerformed");
        Editor editor = (Editor)event.getData(DataKeys.EDITOR);
        if (editor == null || !VimPlugin.isEnabled()) {
            this.getOrigAction().actionPerformed(event);
        } else {
            boolean doTx = !UndoManager.getInstance().inCommand(editor);
            logger.debug("doTx = " + doTx);
            if (doTx) {
                UndoManager.getInstance().endCommand(editor);
                UndoManager.getInstance().beginCommand(editor);
            }
            this.getOrigAction().actionPerformed(event);
            if (doTx) {
                UndoManager.getInstance().endCommand(editor);
                UndoManager.getInstance().beginCommand(editor);
            }
        }
    }
}

