/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.action.change;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandState;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.handler.AbstractEditorActionHandler;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.undo.UndoManager;

public class RepeatChangeAction
extends EditorAction {
    public RepeatChangeAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends AbstractEditorActionHandler {
        private Handler() {
        }

        public boolean execute(Editor editor, DataPackage context, Command command) {
            CommandState state = CommandState.getInstance(editor);
            Command cmd = state.getLastChangeCommand();
            if (cmd != null) {
                if (command.getRawCount() > 0) {
                    Command mot;
                    cmd.setCount(command.getCount());
                    Argument arg = cmd.getArgument();
                    if (arg != null && (mot = arg.getMotion()) != null) {
                        mot.setCount(0);
                    }
                }
                Command save = state.getCommand();
                state.setCommand(cmd);
                state.pushState(4, 0, 1);
                char reg = CommandGroups.getInstance().getRegister().getCurrentRegister();
                CommandGroups.getInstance().getRegister().selectRegister(state.getLastChangeRegister());
                try {
                    KeyHandler.executeAction(cmd.getAction(), context);
                    UndoManager.getInstance().endCommand(editor);
                    UndoManager.getInstance().beginCommand(editor);
                }
                catch (Exception e) {
                    // empty catch block
                }
                state.popState();
                state.setCommand(save);
                state.saveLastChangeCommand(cmd);
                CommandGroups.getInstance().getRegister().selectRegister(reg);
                return true;
            }
            return false;
        }
    }
}

