/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.action.change.change;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.group.MotionGroup;
import com.maddyhome.idea.vim.handler.AbstractEditorActionHandler;
import com.maddyhome.idea.vim.helper.DataPackage;

public class FilterMotionAction
extends EditorAction {
    public FilterMotionAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends AbstractEditorActionHandler {
        private Handler() {
        }

        protected boolean execute(Editor editor, DataPackage context, Command cmd) {
            TextRange range = MotionGroup.getMotionRange(editor, context, cmd.getCount(), cmd.getRawCount(), cmd.getArgument(), false, false);
            if (range == null) {
                return false;
            }
            LogicalPosition current = editor.getCaretModel().getLogicalPosition();
            LogicalPosition start = editor.offsetToLogicalPosition(range.getStartOffset());
            LogicalPosition end = editor.offsetToLogicalPosition(range.getEndOffset());
            if (current.line != start.line) {
                MotionGroup.moveCaret(editor, context, range.getStartOffset());
            }
            int count = start.line < end.line ? end.line - start.line + 1 : 1;
            Command command = new Command(count, null, null, 0, 0);
            CommandGroups.getInstance().getProcess().startFilterCommand(editor, context, command);
            return true;
        }
    }
}

