/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.action.key;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.ui.ExEntryPanel;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

public class KeyAction
extends AnAction {
    private static Logger logger = Logger.getInstance((String)KeyAction.class.getName());

    public void actionPerformed(AnActionEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("actionPerformed=" + event);
        }
        if (!VimPlugin.isEnabled()) {
            return;
        }
        if (event.getInputEvent() instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)event.getInputEvent();
            Editor editor = (Editor)event.getData(DataKeys.EDITOR);
            if (editor != null) {
                KeyStroke key = KeyStroke.getKeyStrokeForEvent(ke);
                KeyHandler.getInstance().handleKey(editor, key, new DataPackage(event));
            } else if (ExEntryPanel.getInstance().isActive()) {
                KeyEvent e = new KeyEvent(ke.getComponent(), ke.getID(), ke.getWhen(), ke.getModifiers(), ke.getKeyCode(), ke.getKeyChar(), ke.getKeyLocation());
                ExEntryPanel.getInstance().processKey(e);
            }
        }
    }

    protected void setShortcutSet(ShortcutSet shortcutSet) {
        if (logger.isDebugEnabled()) {
            logger.debug("setShortcutSet=" + shortcutSet);
        }
        super.setShortcutSet(shortcutSet);
    }
}

