/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.command;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.handler.AbstractEditorActionHandler;
import java.util.List;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command {
    public static final int FLAG_MOT_LINEWISE = 2;
    public static final int FLAG_MOT_CHARACTERWISE = 4;
    public static final int FLAG_MOT_BLOCKWISE = 8;
    public static final int FLAG_MOT_INCLUSIVE = 16;
    public static final int FLAG_MOT_EXCLUSIVE = 32;
    public static final int FLAG_SAVE_JUMP = 64;
    public static final int FLAG_VISUAL_CHARACTERWISE = 128;
    public static final int FLAG_NO_REPEAT = 256;
    public static final int FLAG_CLEAR_STROKES = 512;
    public static final int FLAG_SAVE_STROKE = 1024;
    public static final int FLAG_IS_BACKSPACE = 2048;
    public static final int FLAG_IGNORE_SCROLL_JUMP = 4096;
    public static final int FLAG_IGNORE_SIDE_SCROLL_JUMP = 8192;
    public static final int FLAG_ALLOW_MID_COUNT = 16384;
    public static final int FLAG_SEARCH_FWD = 65536;
    public static final int FLAG_SEARCH_REV = 131072;
    public static final int FLAG_KEEP_VISUAL = 0x100000;
    public static final int FLAG_FORCE_VISUAL = 0x200000;
    public static final int FLAG_FORCE_LINEWISE = 0x400000;
    public static final int FLAG_DELEGATE = 0x800000;
    public static final int FLAG_OP_PEND = 0x1000000;
    public static final int FLAG_MULTIKEY_UNDO = 0x2000000;
    public static final int FLAG_EXPECT_MORE = 0x4000000;
    public static final int FLAG_NO_ARG_RECORDING = 0x8000000;
    public static final int FLAG_ALLOW_DIGRAPH = 0x10000000;
    public static final int FLAG_COMPLETE_EX = 0x20000000;
    public static final int FLAG_TEXT_BLOCK = 0x40000000;
    public static final int MOTION = 1;
    public static final int INSERT = 2;
    public static final int DELETE = 3;
    public static final int CHANGE = 4;
    public static final int COPY = 5;
    public static final int PASTE = 6;
    public static final int RESET = 7;
    public static final int SELECT_REGISTER = 8;
    public static final int OTHER_READONLY = 9;
    public static final int OTHER_WRITABLE = 10;
    public static final int OTHER_READ_WRITE = 11;
    private int count;
    private String actionId;
    private AnAction action;
    private int type;
    private int flags;
    private Argument argument;
    private List<KeyStroke> keys;

    public boolean isReadType() {
        boolean res = false;
        switch (this.type) {
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                res = true;
            }
        }
        return res;
    }

    public boolean isWriteType() {
        boolean res = false;
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                res = true;
            }
        }
        return res;
    }

    public Command(int count, String actionId, AnAction action, int type, int flags) {
        this(count, actionId, action, type, flags, null);
    }

    public Command(int count, String actionId, AnAction action, int type, int flags, Argument arg) {
        EditorAction eaction;
        EditorActionHandler handler;
        this.count = count;
        this.actionId = actionId;
        this.action = action;
        this.type = type;
        this.flags = flags;
        this.argument = arg;
        if (action instanceof EditorAction && (handler = (eaction = (EditorAction)action).getHandler()) instanceof AbstractEditorActionHandler) {
            ((AbstractEditorActionHandler)handler).process(this);
        }
    }

    public int getCount() {
        return this.count == 0 ? 1 : this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getRawCount() {
        return this.count;
    }

    public int getType() {
        return this.type;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public AnAction getAction() {
        return this.action;
    }

    public void setAction(AnAction action) {
        this.action = action;
    }

    public Argument getArgument() {
        return this.argument;
    }

    public void setArgument(Argument argument) {
        this.argument = argument;
    }

    public List<KeyStroke> getKeys() {
        return this.keys;
    }

    public void setKeys(List<KeyStroke> keys) {
        this.keys = keys;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("Command {");
        res.append("count=").append(this.count);
        res.append(",actionId=").append(this.actionId);
        res.append(",action=").append(this.action);
        res.append(",type=").append(this.type);
        res.append(",flags=").append(this.flags);
        res.append(",argument=").append(this.argument);
        res.append(",keys=").append(this.keys);
        res.append("}");
        return res.toString();
    }
}

