/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.command;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.EditorData;
import com.maddyhome.idea.vim.key.KeyParser;
import com.maddyhome.idea.vim.key.ParentNode;
import com.maddyhome.idea.vim.option.Options;
import java.util.Stack;

public class CommandState {
    public static final int MODE_COMMAND = 1;
    public static final int MODE_INSERT = 2;
    public static final int MODE_REPLACE = 3;
    public static final int MODE_REPEAT = 4;
    public static final int MODE_VISUAL = 5;
    public static final int MODE_EX_ENTRY = 6;
    public static final int SUBMODE_SINGLE_COMMAND = 1;
    public static final int SUBMODE_INSERT = 1;
    public static final int SUBMODE_REPLACE = 1;
    private Stack<State> modes = new Stack();
    private State defaultState = new State(1, 0, 1);
    private Command command;
    private int flags;
    private boolean isRecording = false;
    private ParentNode currentNode = KeyParser.getInstance().getKeyRoot(this.getMappingMode());
    private static Command lastChange = null;
    private static char lastRegister = (char)34;
    private static Logger logger = Logger.getInstance((String)CommandState.class.getName());

    public static CommandState getInstance(Editor editor) {
        if (editor == null) {
            return new CommandState();
        }
        CommandState res = EditorData.getCommandState(editor);
        if (res == null) {
            res = new CommandState();
            EditorData.setCommandState(editor, res);
        }
        return res;
    }

    public static boolean inInsertMode(Editor editor) {
        return CommandState.getInstance(editor).getMode() == 2 || CommandState.getInstance(editor).getMode() == 3;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command cmd) {
        this.command = cmd;
        this.setFlags(cmd.getFlags());
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public void pushState(int mode, int submode, int mapping) {
        logger.debug("pushState");
        this.modes.push(new State(mode, submode, mapping));
        this.updateStatus();
        if (logger.isDebugEnabled()) {
            logger.debug("state=" + this);
        }
    }

    public void popState() {
        logger.debug("popState");
        this.modes.pop();
        this.updateStatus();
        if (logger.isDebugEnabled()) {
            logger.debug("state=" + this);
        }
    }

    public int getMode() {
        if (logger.isDebugEnabled()) {
            logger.debug("getMode=" + this.currentState().getMode());
        }
        return this.currentState().getMode();
    }

    public int getSubMode() {
        return this.currentState().getSubmode();
    }

    public void setSubMode(int submode) {
        this.currentState().setSubmode(submode);
        this.updateStatus();
    }

    private void updateStatus() {
        StringBuffer msg = new StringBuffer();
        if (Options.getInstance().isSet("showmode")) {
            msg.append(this.getStatusString(this.modes.size() - 1));
        }
        if (this.isRecording()) {
            if (msg.length() > 0) {
                msg.append(" - ");
            }
            msg.append("recording");
        }
        VimPlugin.showMode(msg.toString());
    }

    private String getStatusString(int pos) {
        State state;
        if (pos >= 0 && pos < this.modes.size()) {
            state = (State)this.modes.get(pos);
        } else if (pos < 0) {
            state = this.defaultState;
        } else {
            return "";
        }
        StringBuffer msg = new StringBuffer();
        block0 : switch (state.getMode()) {
            case 1: {
                if (state.getSubmode() != 1) break;
                msg.append('(').append(this.getStatusString(pos - 1).toLowerCase()).append(')');
                break;
            }
            case 2: {
                msg.append("INSERT");
                break;
            }
            case 3: {
                msg.append("REPLACE");
                break;
            }
            case 5: {
                State tmp;
                if (pos > 0 && (tmp = (State)this.modes.get(pos - 1)).getMode() == 1 && tmp.getSubmode() == 1) {
                    msg.append(this.getStatusString(pos - 1));
                    msg.append(" - ");
                }
                switch (state.getSubmode()) {
                    case 2: {
                        msg.append("VISUAL LINE");
                        break block0;
                    }
                    case 8: {
                        msg.append("VISUAL BLOCK");
                        break block0;
                    }
                }
                msg.append("VISUAL");
            }
        }
        return msg.toString();
    }

    public void toggleInsertOverwrite() {
        int oldmode;
        int newmode = oldmode = this.getMode();
        if (oldmode == 2) {
            newmode = 3;
        } else if (oldmode == 3) {
            newmode = 2;
        }
        if (oldmode != newmode) {
            State state = this.currentState();
            this.popState();
            this.pushState(newmode, state.getSubmode(), state.getMapping());
        }
    }

    public void reset() {
        this.command = null;
        this.modes.clear();
        this.updateStatus();
    }

    public int getMappingMode() {
        if (logger.isDebugEnabled()) {
            logger.debug("getMappingMode=" + this.currentState().getMapping());
        }
        return this.currentState().getMapping();
    }

    public Command getLastChangeCommand() {
        return lastChange;
    }

    public char getLastChangeRegister() {
        return lastRegister;
    }

    public void saveLastChangeCommand(Command cmd) {
        lastChange = cmd;
        lastRegister = CommandGroups.getInstance().getRegister().getCurrentRegister();
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public void setRecording(boolean val) {
        this.isRecording = val;
        this.updateStatus();
    }

    public ParentNode getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(ParentNode currentNode) {
        this.currentNode = currentNode;
    }

    private State currentState() {
        if (this.modes.size() > 0) {
            return this.modes.peek();
        }
        return this.defaultState;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("CommandState");
        buf.append("{modes=").append(this.modes);
        buf.append(",defaultState=").append(this.defaultState);
        buf.append(",command=").append(this.command);
        buf.append(",lastChange=").append(lastChange);
        buf.append(",lastRegister=").append(lastRegister);
        buf.append(",isRecording=").append(this.isRecording);
        buf.append('}');
        return buf.toString();
    }

    private CommandState() {
        this.modes.push(new State(1, 0, 1));
    }

    private class State {
        private int mode;
        private int submode;
        private int mapping;

        public State(int mode, int submode, int mapping) {
            this.mode = mode;
            this.submode = submode;
            this.mapping = mapping;
        }

        public int getMode() {
            return this.mode;
        }

        public int getSubmode() {
            return this.submode;
        }

        public void setSubmode(int submode) {
            this.submode = submode;
        }

        public int getMapping() {
            return this.mapping;
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append("State[mode=");
            res.append(this.mode);
            res.append(", submode=");
            res.append(this.submode);
            res.append(", mapping=");
            res.append(this.mapping);
            res.append("]");
            return res.toString();
        }
    }
}

