/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.common;

public abstract class FileLocation {
    private int line;
    private int col;
    private String filename;

    protected FileLocation(int lline, int col, String filename) {
        this.line = lline;
        this.col = col;
        this.filename = filename;
    }

    public void clear() {
        this.line = -1;
        this.col = -1;
        this.filename = null;
    }

    public boolean isClear() {
        return this.line == -1 && this.col == -1;
    }

    public int getLogicalLine() {
        return this.line;
    }

    public void setLogicalLine(int lline) {
        this.line = lline;
    }

    public int getCol() {
        return this.col;
    }

    public String getFilename() {
        if (this.filename != null) {
            return this.filename;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FileLocation");
        sb.append("{col=").append(this.col);
        sb.append(", line=").append(this.line);
        sb.append(", filename='").append(this.filename).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

