/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.common;

import com.maddyhome.idea.vim.helper.StringHelper;
import java.util.Comparator;
import java.util.List;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Register {
    private char name;
    private int type;
    private String text;
    private List<KeyStroke> keys;

    public Register(char name, int type, String text) {
        this.name = name;
        this.type = type;
        this.text = text;
        this.keys = null;
    }

    public Register(char name, int type, List<KeyStroke> keys) {
        this.name = name;
        this.type = type;
        this.text = null;
        this.keys = keys;
    }

    public void rename(char name) {
        this.name = name;
    }

    public char getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getText() {
        if (this.text == null && this.keys != null) {
            return StringHelper.keysToString(this.keys);
        }
        return this.text;
    }

    public List<KeyStroke> getKeys() {
        if (this.keys == null && this.text != null) {
            return StringHelper.stringToKeys(this.text);
        }
        return this.keys;
    }

    public void addText(String text) {
        if (this.text != null) {
            this.text = this.text + text;
        } else if (this.keys != null) {
            this.addKeys(StringHelper.stringToKeys(text));
        } else {
            this.text = text;
        }
    }

    public void addKeys(List<KeyStroke> keys) {
        if (this.keys != null) {
            this.keys.addAll(keys);
        } else if (this.text != null) {
            this.text = this.text + StringHelper.keysToString(keys);
        } else {
            this.keys = keys;
        }
    }

    public boolean isText() {
        return this.text != null;
    }

    public boolean isKeys() {
        return this.keys != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeySorter<V>
    implements Comparator<V> {
        @Override
        public int compare(V o1, V o2) {
            Register a = (Register)o1;
            Register b = (Register)o2;
            if (a.name < b.name) {
                return -1;
            }
            if (a.name > b.name) {
                return 1;
            }
            return 0;
        }
    }
}

