/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.common;

public class TextRange {
    private int[] starts;
    private int[] ends;

    public TextRange(int start, int end) {
        this(new int[]{start}, new int[]{end});
    }

    public TextRange(int[] starts, int[] ends) {
        this.starts = starts;
        this.ends = ends;
    }

    public boolean isMultiple() {
        return this.starts != null && this.starts.length > 1;
    }

    public int getLength() {
        return this.getEndOffset() - this.getStartOffset();
    }

    public int getMaxLength() {
        int max = 0;
        for (int i = 0; i < this.size(); ++i) {
            max = Math.max(max, this.getEndOffsets()[i] - this.getStartOffsets()[i]);
        }
        return max;
    }

    public int getSelectionCount() {
        int res = 0;
        for (int i = 0; i < this.size(); ++i) {
            res += this.getEndOffsets()[i] - this.getStartOffsets()[i];
        }
        return res;
    }

    public int size() {
        return this.starts.length;
    }

    public int getStartOffset() {
        return this.starts[0];
    }

    public int getEndOffset() {
        return this.ends[this.ends.length - 1];
    }

    public int[] getStartOffsets() {
        return this.starts;
    }

    public int[] getEndOffsets() {
        return this.ends;
    }

    public TextRange normalize() {
        if (this.size() == 1 && this.getEndOffset() < this.getStartOffset()) {
            int t = this.starts[0];
            this.starts[0] = this.ends[0];
            this.ends[0] = t;
        }
        return this;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("TextRange");
        sb.append("{starts=").append(this.starts == null ? "null" : "");
        for (i = 0; this.starts != null && i < this.starts.length; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.starts[i]);
        }
        sb.append(", ends=").append(this.ends == null ? "null" : "");
        for (i = 0; this.ends != null && i < this.ends.length; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.ends[i]);
        }
        sb.append('}');
        return sb.toString();
    }
}

