/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex;

import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.command.CommandState;
import com.maddyhome.idea.vim.ex.CommandName;
import com.maddyhome.idea.vim.ex.CommandParser;
import com.maddyhome.idea.vim.ex.ExCommand;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.MissingArgumentException;
import com.maddyhome.idea.vim.ex.MissingRangeException;
import com.maddyhome.idea.vim.ex.NoRangeAllowedException;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.undo.UndoManager;

public abstract class CommandHandler {
    public static final int RANGE_REQUIRED = 1;
    public static final int RANGE_OPTIONAL = 2;
    public static final int RANGE_FORBIDDEN = 4;
    public static final int ARGUMENT_REQUIRED = 8;
    public static final int ARGUMENT_OPTIONAL = 16;
    public static final int ARGUMENT_FORBIDDEN = 32;
    public static final int RANGE_IS_COUNT = 64;
    public static final int KEEP_FOCUS = 128;
    public static final int DONT_REOPEN = 256;
    public static final int WRITABLE = 512;
    public static final int READ_ONLY = 1024;
    public static final int DONT_SAVE_LAST = 2048;
    protected CommandName[] names;
    protected int argFlags;
    protected int optFlags;

    public CommandHandler(CommandName[] names, int flags) {
        this(names, flags, 0);
    }

    public CommandHandler(CommandName[] names, int argFlags, int optFlags) {
        this.names = names;
        this.argFlags = argFlags;
        this.optFlags = optFlags;
        CommandParser.getInstance().addHandler(this);
    }

    public CommandHandler(String text, String optional, int argFlags) {
        this(text, optional, argFlags, 0);
    }

    public CommandHandler(String text, String optional, int argFlags, int optFlags) {
        this(new CommandName[]{new CommandName(text, optional)}, argFlags, optFlags);
    }

    public CommandHandler(int argFlags) {
        this(argFlags, 0);
    }

    public CommandHandler(int argFlags, int optFlags) {
        this.names = null;
        this.argFlags = argFlags;
        this.optFlags = optFlags;
    }

    public String getRequired() {
        if (this.names == null) {
            return null;
        }
        return this.names[0].getRequired();
    }

    public String getOptional() {
        if (this.names == null) {
            return null;
        }
        return this.names[0].getOptional();
    }

    public CommandName[] getNames() {
        return this.names;
    }

    public int getArgFlags() {
        return this.argFlags;
    }

    public int getOptFlags() {
        return this.optFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Editor editor, DataPackage context, ExCommand cmd, int count) throws ExException {
        if ((this.argFlags & 4) != 0 && cmd.getRanges().size() != 0) {
            MessageHelper.EMSG("e_norange");
            throw new NoRangeAllowedException();
        }
        if ((this.argFlags & 1) != 0 && cmd.getRanges().size() == 0) {
            MessageHelper.EMSG("e_rangereq");
            throw new MissingRangeException();
        }
        if ((this.argFlags & 8) != 0 && cmd.getArgument().length() == 0) {
            MessageHelper.EMSG("e_argreq");
            throw new MissingArgumentException();
        }
        if ((this.argFlags & 0x40) != 0) {
            cmd.getRanges().setDefaultLine(1);
        }
        CommandState.getInstance(editor).setFlags(this.optFlags);
        boolean res = true;
        if ((this.argFlags & 0x200) != 0) {
            try {
                UndoManager.getInstance().endCommand(editor);
                UndoManager.getInstance().beginCommand(editor);
                for (int i = 0; i < count && res; ++i) {
                    res = this.execute(editor, context, cmd);
                }
            }
            catch (ExException e) {
                res = false;
            }
            finally {
                if (res) {
                    UndoManager.getInstance().endCommand(editor);
                } else {
                    UndoManager.getInstance().abortCommand(editor);
                    VimPlugin.indicateError();
                }
                UndoManager.getInstance().beginCommand(editor);
            }
        } else {
            try {
                for (int i = 0; i < count; ++i) {
                    res = this.execute(editor, context, cmd);
                }
                if (!res) {
                    VimPlugin.indicateError();
                }
            }
            catch (ExException e) {
                VimPlugin.indicateError();
            }
        }
        return res;
    }

    public abstract boolean execute(Editor var1, DataPackage var2, ExCommand var3) throws ExException;
}

