/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.common.Register;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.CommandHandler;
import com.maddyhome.idea.vim.ex.CommandName;
import com.maddyhome.idea.vim.ex.CommandNode;
import com.maddyhome.idea.vim.ex.ExCommand;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.InvalidCommandException;
import com.maddyhome.idea.vim.ex.ParseResult;
import com.maddyhome.idea.vim.ex.Range;
import com.maddyhome.idea.vim.ex.Ranges;
import com.maddyhome.idea.vim.ex.handler.AsciiHandler;
import com.maddyhome.idea.vim.ex.handler.CmdFilterHandler;
import com.maddyhome.idea.vim.ex.handler.CopyTextHandler;
import com.maddyhome.idea.vim.ex.handler.DeleteLinesHandler;
import com.maddyhome.idea.vim.ex.handler.DigraphHandler;
import com.maddyhome.idea.vim.ex.handler.DumpLineHandler;
import com.maddyhome.idea.vim.ex.handler.EditFileHandler;
import com.maddyhome.idea.vim.ex.handler.ExitHandler;
import com.maddyhome.idea.vim.ex.handler.FindClassHandler;
import com.maddyhome.idea.vim.ex.handler.FindFileHandler;
import com.maddyhome.idea.vim.ex.handler.FindSymbolHandler;
import com.maddyhome.idea.vim.ex.handler.GotoCharacterHandler;
import com.maddyhome.idea.vim.ex.handler.GotoLineHandler;
import com.maddyhome.idea.vim.ex.handler.HelpHandler;
import com.maddyhome.idea.vim.ex.handler.HistoryHandler;
import com.maddyhome.idea.vim.ex.handler.JoinLinesHandler;
import com.maddyhome.idea.vim.ex.handler.JumpsHandler;
import com.maddyhome.idea.vim.ex.handler.MarkHandler;
import com.maddyhome.idea.vim.ex.handler.MarksHandler;
import com.maddyhome.idea.vim.ex.handler.MoveTextHandler;
import com.maddyhome.idea.vim.ex.handler.NextFileHandler;
import com.maddyhome.idea.vim.ex.handler.NoHLSearchHandler;
import com.maddyhome.idea.vim.ex.handler.OnlyHandler;
import com.maddyhome.idea.vim.ex.handler.PreviousFileHandler;
import com.maddyhome.idea.vim.ex.handler.PromptFindHandler;
import com.maddyhome.idea.vim.ex.handler.PromptReplaceHandler;
import com.maddyhome.idea.vim.ex.handler.PutLinesHandler;
import com.maddyhome.idea.vim.ex.handler.QuitHandler;
import com.maddyhome.idea.vim.ex.handler.RedoHandler;
import com.maddyhome.idea.vim.ex.handler.RegistersHandler;
import com.maddyhome.idea.vim.ex.handler.RepeatHandler;
import com.maddyhome.idea.vim.ex.handler.SelectFileHandler;
import com.maddyhome.idea.vim.ex.handler.SelectFirstFileHandler;
import com.maddyhome.idea.vim.ex.handler.SelectLastFileHandler;
import com.maddyhome.idea.vim.ex.handler.SetHandler;
import com.maddyhome.idea.vim.ex.handler.ShiftLeftHandler;
import com.maddyhome.idea.vim.ex.handler.ShiftRightHandler;
import com.maddyhome.idea.vim.ex.handler.SubstituteHandler;
import com.maddyhome.idea.vim.ex.handler.UndoHandler;
import com.maddyhome.idea.vim.ex.handler.WriteAllHandler;
import com.maddyhome.idea.vim.ex.handler.WriteHandler;
import com.maddyhome.idea.vim.ex.handler.WriteNextFileHandler;
import com.maddyhome.idea.vim.ex.handler.WritePreviousFileHandler;
import com.maddyhome.idea.vim.ex.handler.WriteQuitHandler;
import com.maddyhome.idea.vim.ex.handler.YankLinesHandler;
import com.maddyhome.idea.vim.ex.range.AbstractRange;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.ApiHelper;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.MessageHelper;

public class CommandParser {
    public static final int RES_EMPTY = 1;
    public static final int RES_ERROR = 1;
    public static final int RES_READONLY = 1;
    public static final int RES_MORE_PANEL = 2;
    public static final int RES_DONT_REOPEN = 4;
    private CommandNode root = new CommandNode();
    private boolean registered = false;
    private static CommandParser ourInstance;
    private static final int STATE_START = 1;
    private static final int STATE_COMMAND = 10;
    private static final int STATE_CMD_ARG = 11;
    private static final int STATE_RANGE = 20;
    private static final int STATE_RANGE_LINE = 21;
    private static final int STATE_RANGE_CURRENT = 22;
    private static final int STATE_RANGE_LAST = 23;
    private static final int STATE_RANGE_MARK = 24;
    private static final int STATE_RANGE_MARK_CHAR = 25;
    private static final int STATE_RANGE_ALL = 26;
    private static final int STATE_RANGE_PATTERN = 27;
    private static final int STATE_RANGE_SHORT_PATTERN = 28;
    private static final int STATE_RANGE_PATTERN_MAYBE_DONE = 29;
    private static final int STATE_RANGE_OFFSET = 30;
    private static final int STATE_RANGE_OFFSET_NUM = 31;
    private static final int STATE_RANGE_OFFSET_DONE = 32;
    private static final int STATE_RANGE_OFFSET_MAYBE_DONE = 33;
    private static final int STATE_RANGE_SEPARATOR = 40;
    private static final int STATE_RANGE_MAYBE_DONE = 50;
    private static final int STATE_RANGE_DONE = 51;
    private static final int STATE_ERROR = 99;
    private static Logger logger;

    public static synchronized CommandParser getInstance() {
        if (ourInstance == null) {
            ourInstance = new CommandParser();
        }
        return ourInstance;
    }

    private CommandParser() {
    }

    public void registerHandlers() {
        if (this.registered) {
            return;
        }
        new AsciiHandler();
        new CmdFilterHandler();
        new CopyTextHandler();
        new DeleteLinesHandler();
        new DigraphHandler();
        new DumpLineHandler();
        new EditFileHandler();
        new ExitHandler();
        new FindClassHandler();
        new FindFileHandler();
        new FindSymbolHandler();
        new GotoCharacterHandler();
        new HelpHandler();
        new HistoryHandler();
        new JoinLinesHandler();
        new JumpsHandler();
        new MarkHandler();
        new MarksHandler();
        new MoveTextHandler();
        new NextFileHandler();
        if (ApiHelper.supportsColorSchemes()) {
            new NoHLSearchHandler();
        }
        new OnlyHandler();
        new PreviousFileHandler();
        new PromptFindHandler();
        new PromptReplaceHandler();
        new PutLinesHandler();
        new QuitHandler();
        new RedoHandler();
        new RegistersHandler();
        new RepeatHandler();
        new SelectFileHandler();
        new SelectFirstFileHandler();
        new SelectLastFileHandler();
        new SetHandler();
        new ShiftLeftHandler();
        new ShiftRightHandler();
        new SubstituteHandler();
        new UndoHandler();
        new WriteAllHandler();
        new WriteHandler();
        new WriteNextFileHandler();
        new WritePreviousFileHandler();
        new WriteQuitHandler();
        new YankLinesHandler();
        this.registered = true;
    }

    public boolean processLastCommand(Editor editor, DataPackage context, int count) throws ExException {
        Register reg = CommandGroups.getInstance().getRegister().getRegister(':');
        if (reg == null) {
            return false;
        }
        this.processCommand(editor, context, reg.getText(), count);
        return true;
    }

    public int processCommand(Editor editor, DataPackage context, String cmd, int count) throws ExException {
        CommandHandler handler;
        int result = 0;
        if (cmd.length() == 0) {
            return result | 1;
        }
        CommandGroups.getInstance().getHistory().addEntry("cmd", cmd);
        ParseResult res = this.parse(cmd);
        String command = res.getCommand();
        if (command.length() == 0) {
            handler = new GotoLineHandler();
        } else {
            CommandNode node = this.root;
            for (int i = 0; i < command.length(); ++i) {
                if ((node = node.getChild(command.charAt(i))) != null) continue;
                MessageHelper.EMSG("notexcmd", command);
                throw new InvalidCommandException(cmd);
            }
            handler = node.getCommandHandler();
        }
        if (handler == null) {
            MessageHelper.EMSG("notexcmd", command);
            throw new InvalidCommandException(cmd);
        }
        if ((handler.getArgFlags() & 0x200) > 0 && !editor.getDocument().isWritable()) {
            VimPlugin.indicateError();
            return result | 1;
        }
        boolean ok = handler.process(editor, context, new ExCommand(res.getRanges(), command, res.getArgument()), count);
        if (ok && (handler.getArgFlags() & 0x800) == 0) {
            CommandGroups.getInstance().getRegister().storeTextInternal(editor, context, new TextRange(-1, -1), cmd, 4, ':', false, false);
        }
        if (ok && (handler.getArgFlags() & 0x80) != 0) {
            result |= 2;
        }
        if ((handler.getArgFlags() & 0x100) != 0) {
            result |= 4;
        }
        return result;
    }

    public ParseResult parse(String cmd) throws ExException {
        if (logger.isDebugEnabled()) {
            logger.debug("processing `" + cmd + "'");
        }
        int state = 1;
        Ranges ranges = new Ranges();
        StringBuffer command = new StringBuffer();
        StringBuffer argument = new StringBuffer();
        StringBuffer location = null;
        int offsetSign = 1;
        int offsetNumber = 0;
        int offsetTotal = 0;
        boolean move = false;
        char patternType = '\u0000';
        int backCount = 0;
        boolean inBrackets = false;
        String error = "";
        for (int i = 0; i <= cmd.length(); ++i) {
            char ch;
            boolean reprocess = true;
            char c = ch = i == cmd.length() ? (char)'\n' : (char)cmd.charAt(i);
            while (reprocess) {
                switch (state) {
                    case 1: {
                        if (Character.isLetter(ch) || "~<>@=#*&!".indexOf(ch) >= 0) {
                            state = 10;
                            break;
                        }
                        if (ch == ' ') {
                            state = 1;
                            reprocess = false;
                            break;
                        }
                        state = 20;
                        break;
                    }
                    case 10: {
                        if (Character.isLetter(ch) || command.length() == 0 && "~<>@=#*&!".indexOf(ch) >= 0 || command.length() > 0 && ch == command.charAt(command.length() - 1) && "<>".indexOf(ch) >= 0) {
                            command.append(ch);
                            reprocess = false;
                            if (Character.isLetter(ch) || "<>".indexOf(ch) >= 0) break;
                            state = 11;
                            break;
                        }
                        state = 11;
                        break;
                    }
                    case 11: {
                        argument.append(ch);
                        reprocess = false;
                        break;
                    }
                    case 20: {
                        location = new StringBuffer();
                        offsetTotal = 0;
                        offsetNumber = 0;
                        move = false;
                        if (ch >= '0' && ch <= '9') {
                            state = 21;
                            break;
                        }
                        if (ch == '.') {
                            state = 22;
                            break;
                        }
                        if (ch == '$') {
                            state = 23;
                            break;
                        }
                        if (ch == '%') {
                            state = 26;
                            break;
                        }
                        if (ch == '\'') {
                            state = 24;
                            break;
                        }
                        if (ch == '+' || ch == '-') {
                            location.append('0');
                            state = 30;
                            break;
                        }
                        if (ch == '\\') {
                            location.append(ch);
                            state = 28;
                            reprocess = false;
                            break;
                        }
                        if (ch == '/' || ch == '?') {
                            location.append(ch);
                            patternType = ch;
                            backCount = 0;
                            inBrackets = false;
                            state = 27;
                            reprocess = false;
                            break;
                        }
                        error = MessageHelper.getMsg("e_badrange", Character.toString(ch));
                        state = 99;
                        reprocess = false;
                        break;
                    }
                    case 28: {
                        if (ch == '/' || ch == '?' || ch == '&') {
                            location.append(ch);
                            state = 29;
                            reprocess = false;
                            break;
                        }
                        error = MessageHelper.getMsg("e_backslash");
                        state = 99;
                        reprocess = false;
                        break;
                    }
                    case 27: {
                        if (ch == '\n') {
                            location.append(patternType);
                            state = 50;
                            break;
                        }
                        location.append(ch);
                        if (ch == '[' && !inBrackets) {
                            inBrackets = true;
                        } else if (ch == ']' && inBrackets && location.charAt(location.length() - 2) != '[' && (location.length() < 3 || !location.substring(location.length() - 3).equals("[^]"))) {
                            inBrackets = false;
                        } else if (ch == '\\') {
                            ++backCount;
                        } else if (!(ch != patternType || inBrackets || location.charAt(location.length() - 2) == '\\' && backCount % 2 != 0)) {
                            state = 29;
                        }
                        if (ch != '\\') {
                            backCount = 0;
                        }
                        reprocess = false;
                        break;
                    }
                    case 29: {
                        if (ch == '/' || ch == '?') {
                            location.append('\u0000');
                            location.append(ch);
                            patternType = ch;
                            backCount = 0;
                            inBrackets = false;
                            state = 27;
                            reprocess = false;
                            break;
                        }
                        state = 50;
                        break;
                    }
                    case 21: {
                        if (ch >= '0' && ch <= '9') {
                            location.append(ch);
                            state = 50;
                            reprocess = false;
                            break;
                        }
                        state = 50;
                        break;
                    }
                    case 22: {
                        location.append(ch);
                        state = 50;
                        reprocess = false;
                        break;
                    }
                    case 23: {
                        location.append(ch);
                        state = 50;
                        reprocess = false;
                        break;
                    }
                    case 26: {
                        location.append(ch);
                        state = 50;
                        reprocess = false;
                        break;
                    }
                    case 24: {
                        location.append(ch);
                        state = 25;
                        reprocess = false;
                        break;
                    }
                    case 25: {
                        location.append(ch);
                        state = 50;
                        reprocess = false;
                        break;
                    }
                    case 51: {
                        Range[] range = AbstractRange.createRange(location.toString(), offsetTotal, move);
                        if (range == null) {
                            error = MessageHelper.getMsg("e_badrange", Character.toString(ch));
                            state = 99;
                            reprocess = false;
                            break;
                        }
                        ranges.addRange(range);
                        if (ch == ':' || ch == '\n') {
                            state = 10;
                            reprocess = false;
                            break;
                        }
                        if (Character.isLetter(ch) || "~<>@=#*&!".indexOf(ch) >= 0 || ch == ' ') {
                            state = 1;
                            break;
                        }
                        state = 20;
                        break;
                    }
                    case 50: {
                        if (ch == '+' || ch == '-') {
                            state = 30;
                            break;
                        }
                        if (ch == ',' || ch == ';') {
                            state = 40;
                            break;
                        }
                        if (ch >= '0' && ch <= '9') {
                            state = 21;
                            break;
                        }
                        state = 51;
                        break;
                    }
                    case 30: {
                        offsetNumber = 0;
                        if (ch == '+') {
                            offsetSign = 1;
                        } else if (ch == '-') {
                            offsetSign = -1;
                        }
                        state = 33;
                        reprocess = false;
                        break;
                    }
                    case 33: {
                        if (ch >= '0' && ch <= '9') {
                            state = 31;
                            break;
                        }
                        state = 32;
                        break;
                    }
                    case 32: {
                        if (offsetNumber == 0) {
                            offsetNumber = 1;
                        }
                        offsetTotal += offsetNumber * offsetSign;
                        if (ch == '+' || ch == '-') {
                            state = 30;
                            break;
                        }
                        state = 50;
                        break;
                    }
                    case 31: {
                        if (ch >= '0' && ch <= '9') {
                            offsetNumber = offsetNumber * 10 + (ch - 48);
                            state = 33;
                            reprocess = false;
                            break;
                        }
                        if (ch == '+' || ch == '-') {
                            state = 32;
                            break;
                        }
                        state = 33;
                        break;
                    }
                    case 40: {
                        if (ch == ',') {
                            move = false;
                        } else if (ch == ';') {
                            move = true;
                        }
                        state = 51;
                        reprocess = false;
                    }
                }
            }
            if (state != 99) continue;
            VimPlugin.showMessage(error);
            throw new InvalidCommandException(cmd);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ranges = " + ranges);
            logger.debug("command = " + command);
            logger.debug("argument = " + argument);
        }
        return new ParseResult(ranges, command.toString(), argument.toString().trim());
    }

    public void addHandler(CommandHandler handler) {
        CommandName[] names;
        for (CommandName name : names = handler.getNames()) {
            CommandNode node = this.root;
            String text = name.getRequired();
            for (int i = 0; i < text.length() - 1; ++i) {
                CommandNode cn = node.getChild(text.charAt(i));
                if (cn == null) {
                    cn = node.addChild(text.charAt(i), null);
                }
                node = cn;
            }
            CommandNode cn = node.getChild(text.charAt(text.length() - 1));
            if (cn == null) {
                cn = node.addChild(text.charAt(text.length() - 1), handler);
            } else {
                cn.setCommandHandler(handler);
            }
            node = cn;
            text = name.getOptional();
            for (int i = 0; i < text.length(); ++i) {
                cn = node.getChild(text.charAt(i));
                if (cn == null) {
                    cn = node.addChild(text.charAt(i), handler);
                } else if (cn.getCommandHandler() == null) {
                    cn.setCommandHandler(handler);
                }
                node = cn;
            }
        }
    }

    static {
        logger = Logger.getInstance((String)CommandParser.class.getName());
    }
}

