/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.LineRange;
import com.maddyhome.idea.vim.ex.Ranges;
import com.maddyhome.idea.vim.helper.DataPackage;

public class ExCommand {
    protected Ranges ranges;
    protected String command;
    protected String argument;
    private static Logger logger = Logger.getInstance((String)ExCommand.class.getName());

    public ExCommand(Ranges ranges, String command, String argument) {
        this.ranges = ranges;
        this.argument = argument;
        this.command = command;
    }

    public int getLine(Editor editor, DataPackage context) {
        return this.ranges.getLine(editor, context);
    }

    public int getCount(Editor editor, DataPackage context, int defaultCount, boolean checkCount) {
        int res;
        int count = -1;
        if (checkCount) {
            count = this.getCountArgument();
        }
        if ((res = this.ranges.getCount(editor, context, count)) == -1) {
            res = defaultCount;
        }
        return res;
    }

    public LineRange getLineRange(Editor editor, DataPackage context, boolean checkCount) {
        int count = -1;
        if (checkCount) {
            count = this.getCountArgument();
        }
        return this.ranges.getLineRange(editor, context, count);
    }

    public TextRange getTextRange(Editor editor, DataPackage context, boolean checkCount) {
        int count = -1;
        if (checkCount) {
            count = this.getCountArgument();
        }
        return this.ranges.getTextRange(editor, context, count);
    }

    protected int getCountArgument() {
        try {
            return Integer.parseInt(this.argument);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String getCommand() {
        return this.command;
    }

    public String getArgument() {
        return this.argument;
    }

    public void setArgument(String argument) {
        this.argument = argument;
    }

    public Ranges getRanges() {
        return this.ranges;
    }
}

