/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex;

import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.LineRange;
import com.maddyhome.idea.vim.ex.Range;
import com.maddyhome.idea.vim.ex.range.AbstractRange;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.group.MotionGroup;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorHelper;
import java.util.ArrayList;
import java.util.List;

public class Ranges {
    private int startLine = 0;
    private int endLine = 0;
    private int count = 0;
    private int defaultLine = -1;
    private boolean done = false;
    private List<Range> ranges = new ArrayList<Range>();

    public void addRange(Range[] range) {
        for (Range aRange : range) {
            this.ranges.add(aRange);
        }
    }

    public int size() {
        return this.ranges.size();
    }

    public void setDefaultLine(int line) {
        this.defaultLine = line;
    }

    public int getLine(Editor editor, DataPackage context) {
        this.processRange(editor, context);
        return this.endLine;
    }

    public int getFirstLine(Editor editor, DataPackage context) {
        this.processRange(editor, context);
        return this.startLine;
    }

    public int getCount(Editor editor, DataPackage context, int count) {
        if (count == -1) {
            return this.getLine(editor, context);
        }
        return count;
    }

    public LineRange getLineRange(Editor editor, DataPackage context, int count) {
        int start;
        int end;
        this.processRange(editor, context);
        if (count == -1) {
            end = this.endLine;
            start = this.startLine;
        } else {
            start = this.endLine;
            end = start + count - 1;
        }
        return new LineRange(start, end);
    }

    public TextRange getTextRange(Editor editor, DataPackage context, int count) {
        LineRange lr = this.getLineRange(editor, context, count);
        int start = EditorHelper.getLineStartOffset(editor, lr.getStartLine());
        int end = EditorHelper.getLineEndOffset(editor, lr.getEndLine(), true) + 1;
        return new TextRange(start, Math.min(end, EditorHelper.getFileSize(editor)));
    }

    public static TextRange getCurrentLineRange(Editor editor, DataPackage context) {
        Ranges ranges = new Ranges();
        return ranges.getTextRange(editor, context, -1);
    }

    public static TextRange getFileTextRange(Editor editor, DataPackage context) {
        Ranges ranges = new Ranges();
        ranges.addRange(AbstractRange.createRange("%", 0, false));
        return ranges.getTextRange(editor, context, -1);
    }

    private void processRange(Editor editor, DataPackage context) {
        if (this.done) {
            return;
        }
        this.endLine = this.startLine = this.defaultLine == -1 ? editor.getCaretModel().getLogicalPosition().line : this.defaultLine;
        boolean lastZero = false;
        for (Range range : this.ranges) {
            this.startLine = this.endLine;
            this.endLine = range.getLine(editor, context, lastZero);
            if (range.isMove()) {
                MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretToLine(editor, context, this.endLine));
            }
            lastZero = this.endLine < 0;
            ++this.count;
        }
        if (this.count == 1) {
            this.startLine = this.endLine;
        }
        this.done = true;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("Ranges[ranges=").append(this.ranges);
        res.append("]");
        return res.toString();
    }
}

