/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.handler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.CommandHandler;
import com.maddyhome.idea.vim.ex.ExCommand;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.Ranges;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.MessageHelper;
import java.io.IOException;

public class CmdFilterHandler
extends CommandHandler {
    private static Logger logger = Logger.getInstance((String)CmdFilterHandler.class.getName());

    public CmdFilterHandler() {
        super("!", "", 529);
    }

    public boolean execute(Editor editor, DataPackage context, ExCommand cmd) throws ExException {
        logger.info("execute");
        Ranges ranges = cmd.getRanges();
        if (ranges.size() == 0) {
            return false;
        }
        TextRange range = cmd.getTextRange(editor, context, false);
        String command = cmd.getArgument();
        if (command.indexOf(33) != -1) {
            String last = CommandGroups.getInstance().getProcess().getLastCommand();
            if (last == null || last.length() == 0) {
                MessageHelper.EMSG("e_noprev");
                return false;
            }
            command = command.replaceAll("!", last);
        }
        if (command == null || command.length() == 0) {
            return false;
        }
        try {
            return CommandGroups.getInstance().getProcess().executeFilter(editor, context, range, command);
        }
        catch (IOException e) {
            throw new ExException(e.getMessage());
        }
    }
}

