/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.handler;

import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.CommandHandler;
import com.maddyhome.idea.vim.ex.CommandName;
import com.maddyhome.idea.vim.ex.CommandParser;
import com.maddyhome.idea.vim.ex.ExCommand;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ParseResult;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorHelper;

public class CopyTextHandler
extends CommandHandler {
    public CopyTextHandler() {
        super(new CommandName[]{new CommandName("co", "py"), new CommandName("t", "")}, 522);
    }

    public boolean execute(Editor editor, DataPackage context, ExCommand cmd) throws ExException {
        TextRange range = cmd.getTextRange(editor, context, false);
        ParseResult pr = CommandParser.getInstance().parse(cmd.getArgument());
        int line = pr.getRanges().getFirstLine(editor, context);
        int offset = CommandGroups.getInstance().getMotion().moveCaretToLineStart(editor, line + 1);
        String text = EditorHelper.getText(editor, range.getStartOffset(), range.getEndOffset());
        CommandGroups.getInstance().getCopy().putText(editor, context, offset, text, 2, 1, true, false, 0);
        return true;
    }
}

