/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.handler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.ex.CommandHandler;
import com.maddyhome.idea.vim.ex.CommandName;
import com.maddyhome.idea.vim.ex.ExCommand;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.LineRange;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorHelper;

public class DumpLineHandler
extends CommandHandler {
    private static Logger logger = Logger.getInstance((String)DumpLineHandler.class.getName());

    public DumpLineHandler() {
        super(new CommandName[]{new CommandName("dump", "line")}, 2);
    }

    public boolean execute(Editor editor, DataPackage context, ExCommand cmd) throws ExException {
        LineRange range = cmd.getLineRange(editor, context, false);
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        for (int l = range.getStartLine(); l <= range.getEndLine(); ++l) {
            int start = editor.getDocument().getLineStartOffset(l);
            int end = editor.getDocument().getLineEndOffset(l);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Line " + l + ", start offset=" + start + ", end offset=" + end);
            for (int i = start; i <= end; ++i) {
                logger.debug("Offset " + i + ", char=" + chars.charAt(i) + ", lp=" + editor.offsetToLogicalPosition(i) + ", vp=" + editor.offsetToVisualPosition(i));
            }
        }
        return true;
    }
}

