/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.handler;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.help.HelpManager;
import com.maddyhome.idea.vim.ex.CommandHandler;
import com.maddyhome.idea.vim.ex.ExCommand;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.helper.DataPackage;

public class HelpHandler
extends CommandHandler {
    public HelpHandler() {
        super("h", "elp", 272);
    }

    public boolean execute(Editor editor, DataPackage context, ExCommand cmd) throws ExException {
        String key = cmd.getArgument();
        if (key.length() == 0) {
            key = "help.txt";
        } else if ("*".equals(key)) {
            key = "star";
        }
        HelpManager mgr = HelpManager.getInstance();
        mgr.invokeHelp("vim." + HelpHandler.encode(key));
        return true;
    }

    private static String encode(String key) {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < key.length(); ++i) {
            if ("%\"~<>=#&?/.".indexOf(key.charAt(i)) >= 0) {
                res.append('%').append(Integer.toHexString(key.charAt(i)).toUpperCase());
                continue;
            }
            res.append(key.charAt(i));
        }
        return res.toString();
    }
}

