/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.handler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.ex.CommandHandler;
import com.maddyhome.idea.vim.ex.ExCommand;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.group.HistoryGroup;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.ui.MorePanel;
import java.util.List;

public class HistoryHandler
extends CommandHandler {
    private static Logger logger = Logger.getInstance((String)HistoryHandler.class.getName());

    public HistoryHandler() {
        super("his", "tory", 148);
    }

    public boolean execute(Editor editor, DataPackage context, ExCommand cmd) throws ExException {
        String last;
        String first;
        String key;
        int spos;
        logger.debug("execute");
        String arg = cmd.getArgument().trim();
        if (arg.length() == 0) {
            arg = "cmd";
            logger.debug("default to cmd");
        }
        if ((spos = arg.indexOf(32)) >= 0) {
            key = arg.substring(0, spos).trim();
            arg = arg.substring(spos + 1);
        } else {
            key = arg;
            arg = "";
        }
        if (logger.isDebugEnabled()) {
            logger.debug("key='" + key + "'");
        }
        if (key.length() == 1 && ":/=@".indexOf(key.charAt(0)) >= 0) {
            switch (key.charAt(0)) {
                case ':': {
                    key = "cmd";
                    break;
                }
                case '/': {
                    key = "search";
                    break;
                }
                case '=': {
                    key = "expr";
                    break;
                }
                case '@': {
                    key = "input";
                }
            }
        } else if (Character.isLetter(key.charAt(0))) {
            if (!("cmd".startsWith(key) || "search".startsWith(key) || "expr".startsWith(key) || "input".startsWith(key) || "all".startsWith(key))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("invalid command " + key);
                }
                return false;
            }
        } else {
            arg = key + " " + arg;
            key = "cmd";
        }
        int cpos = arg.indexOf(44);
        if (cpos >= 0) {
            first = arg.substring(0, cpos).trim();
            last = arg.substring(cpos + 1).trim();
        } else {
            first = arg;
            last = "";
        }
        int f = 0;
        int l = 0;
        try {
            if (first.length() > 0) {
                f = Integer.parseInt(first);
            }
            if (last.length() > 0) {
                l = Integer.parseInt(last);
            }
        }
        catch (NumberFormatException e) {
            logger.debug("bad number");
            return false;
        }
        StringBuffer res = new StringBuffer();
        switch (key.charAt(0)) {
            case 'c': {
                res.append(this.processKey("cmd", f, l));
                break;
            }
            case 's': {
                res.append(this.processKey("search", f, l));
                break;
            }
            case 'e': {
                res.append(this.processKey("expr", f, l));
                break;
            }
            case 'i': {
                res.append(this.processKey("input", f, l));
                break;
            }
            case 'a': {
                res.append(this.processKey("cmd", f, l));
                res.append(this.processKey("search", f, l));
                res.append(this.processKey("expr", f, l));
                res.append(this.processKey("input", f, l));
            }
        }
        MorePanel panel = MorePanel.getInstance(editor);
        panel.setText(res.toString());
        return true;
    }

    private String processKey(String key, int start, int end) {
        if (logger.isDebugEnabled()) {
            logger.debug("process " + key + " " + start + "," + end);
        }
        StringBuffer res = new StringBuffer();
        res.append("      #  ").append(key).append(" ").append("history\n");
        String spaces = "       ";
        List<HistoryGroup.HistoryEntry> entries = CommandGroups.getInstance().getHistory().getEntries(key, start, end);
        for (HistoryGroup.HistoryEntry entry : entries) {
            String num = Integer.toString(entry.getNumber());
            res.append(spaces.substring(num.length())).append(num).append("  ").append(entry.getEntry()).append("\n");
        }
        return res.toString();
    }
}

