/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.handler;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import com.maddyhome.idea.vim.common.Mark;
import com.maddyhome.idea.vim.ex.CommandHandler;
import com.maddyhome.idea.vim.ex.CommandName;
import com.maddyhome.idea.vim.ex.ExCommand;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorData;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.StringHelper;
import com.maddyhome.idea.vim.ui.MorePanel;
import java.util.List;

public class MarksHandler
extends CommandHandler {
    public MarksHandler() {
        super(new CommandName[]{new CommandName("marks", "")}, 144);
    }

    public boolean execute(Editor editor, DataPackage context, ExCommand cmd) throws ExException {
        List<Mark> marks = CommandGroups.getInstance().getMark().getMarks(editor);
        String spaces = "     ";
        StringBuffer text = new StringBuffer();
        text.append("mark  line  col file/text\n");
        for (Mark mark : marks) {
            text.append(" ");
            text.append(mark.getKey());
            text.append("   ");
            String num = Integer.toString(mark.getLogicalLine() + 1);
            text.append(spaces.substring(0, 5 - num.length()));
            text.append(num);
            text.append("  ");
            num = Integer.toString(mark.getCol() + 1);
            text.append(spaces.substring(0, 3 - num.length()));
            text.append(num);
            text.append(" ");
            VirtualFile vf = EditorData.getVirtualFile(editor);
            if (vf != null && vf.getPath().equals(mark.getFilename())) {
                text.append(StringHelper.escape(EditorHelper.getLineText(editor, mark.getLogicalLine()).trim()));
            } else {
                text.append(mark.getFilename());
            }
            text.append("\n");
        }
        MorePanel panel = MorePanel.getInstance(editor);
        panel.setText(text.toString());
        return true;
    }
}

