/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.handler;

import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.CommandHandler;
import com.maddyhome.idea.vim.ex.CommandParser;
import com.maddyhome.idea.vim.ex.ExCommand;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.InvalidRangeException;
import com.maddyhome.idea.vim.ex.LineRange;
import com.maddyhome.idea.vim.ex.ParseResult;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.MessageHelper;

public class MoveTextHandler
extends CommandHandler {
    public MoveTextHandler() {
        super("m", "ove", 522);
    }

    public boolean execute(Editor editor, DataPackage context, ExCommand cmd) throws ExException {
        TextRange range = cmd.getTextRange(editor, context, false);
        LineRange lr = cmd.getLineRange(editor, context, false);
        int adj = lr.getEndLine() - lr.getStartLine() + 1;
        ParseResult pr = CommandParser.getInstance().parse(cmd.getArgument());
        int line = pr.getRanges().getFirstLine(editor, context);
        if (line >= lr.getEndLine()) {
            line -= adj;
        } else if (line >= lr.getStartLine()) {
            throw new InvalidRangeException(MessageHelper.getMsg("e_backrange"));
        }
        String text = EditorHelper.getText(editor, range.getStartOffset(), range.getEndOffset());
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        int offset = CommandGroups.getInstance().getMotion().moveCaretToLineStart(editor, line + 1);
        CommandGroups.getInstance().getCopy().putText(editor, context, offset, text, 2, 1, true, false, 0);
        return true;
    }
}

