/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.handler;

import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.ex.CommandHandler;
import com.maddyhome.idea.vim.ex.CommandName;
import com.maddyhome.idea.vim.ex.ExCommand;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.group.MotionGroup;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorHelper;

public class PutLinesHandler
extends CommandHandler {
    public PutLinesHandler() {
        super(new CommandName[]{new CommandName("pu", "t")}, 522);
    }

    public boolean execute(Editor editor, DataPackage context, ExCommand cmd) throws ExException {
        int line = cmd.getLine(editor, context);
        String arg = cmd.getArgument();
        boolean before = false;
        if (arg.length() > 0 && arg.charAt(0) == '!') {
            before = true;
            arg = arg.substring(1).trim();
        }
        if (arg.length() > 0) {
            if (!CommandGroups.getInstance().getRegister().selectRegister(arg.charAt(0))) {
                return false;
            }
        } else {
            CommandGroups.getInstance().getRegister().selectRegister('\"');
        }
        MotionGroup.moveCaret(editor, context, EditorHelper.getLineStartOffset(editor, line));
        if (before) {
            return CommandGroups.getInstance().getCopy().putTextBeforeCursor(editor, context, 1, true, false);
        }
        return CommandGroups.getInstance().getCopy().putTextAfterCursor(editor, context, 1, true, false);
    }
}

