/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.range;

import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.ex.Range;
import com.maddyhome.idea.vim.ex.range.LineNumberRange;
import com.maddyhome.idea.vim.ex.range.MarkRange;
import com.maddyhome.idea.vim.ex.range.SearchRange;
import com.maddyhome.idea.vim.helper.DataPackage;

public abstract class AbstractRange
implements Range {
    protected int offset;
    protected boolean move;

    public static Range[] createRange(String str, int offset, boolean move) {
        if (str.equals(".") || str.length() == 0) {
            return new Range[]{new LineNumberRange(offset, move)};
        }
        if (str.equals("%")) {
            return new Range[]{new LineNumberRange(0, 0, move), new LineNumberRange(-99999998, offset, move)};
        }
        if (str.equals("$")) {
            return new Range[]{new LineNumberRange(-99999998, offset, move)};
        }
        if (str.startsWith("'") && str.length() == 2) {
            return new Range[]{new MarkRange(str.charAt(1), offset, move)};
        }
        if (str.startsWith("/") || str.startsWith("\\/") || str.startsWith("\\&")) {
            return new Range[]{new SearchRange(str, offset, move)};
        }
        if (str.startsWith("?") || str.startsWith("\\?")) {
            return new Range[]{new SearchRange(str, offset, move)};
        }
        try {
            int line = Integer.parseInt(str) - 1;
            return new Range[]{new LineNumberRange(line, offset, move)};
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public AbstractRange(int offset, boolean move) {
        this.offset = offset;
        this.move = move;
    }

    protected int getOffset() {
        return this.offset;
    }

    public boolean isMove() {
        return this.move;
    }

    public int getLine(Editor editor, DataPackage context, boolean lastZero) {
        int line = this.getRangeLine(editor, context, lastZero);
        return line + this.offset;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AbstractRange");
        sb.append("{offset=").append(this.offset);
        sb.append(", move=").append(this.move);
        sb.append('}');
        return sb.toString();
    }

    protected abstract int getRangeLine(Editor var1, DataPackage var2, boolean var3);
}

