/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.range;

import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.ex.range.AbstractRange;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorHelper;

public class LineNumberRange
extends AbstractRange {
    public static final int CURRENT_LINE = -99999999;
    public static final int LAST_LINE = -99999998;
    private int line;

    public LineNumberRange(int offset, boolean move) {
        super(offset, move);
        this.line = -99999999;
    }

    public LineNumberRange(int line, int offset, boolean move) {
        super(offset, move);
        this.line = line;
    }

    protected int getRangeLine(Editor editor, DataPackage context, boolean lastZero) {
        if (this.line == -99999999) {
            this.line = editor.getCaretModel().getLogicalPosition().line;
        } else if (this.line == -99999998) {
            this.line = EditorHelper.getLineCount(editor) - 1;
        }
        return this.line;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("LineNumberRange[");
        res.append("line=").append(this.line);
        res.append(", ");
        res.append(super.toString());
        res.append("]");
        return res.toString();
    }
}

