/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ex.range;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.ex.range.AbstractRange;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SearchRange
extends AbstractRange {
    private List<String> patterns = new ArrayList<String>();
    private List<Integer> flags = new ArrayList<Integer>();
    private static Logger logger = Logger.getInstance((String)SearchRange.class.getName());

    public SearchRange(String pattern, int offset, boolean move) {
        super(offset, move);
        this.setPattern(pattern);
    }

    private void setPattern(String pattern) {
        if (logger.isDebugEnabled()) {
            logger.debug("pattern=" + pattern);
        }
        StringTokenizer tok = new StringTokenizer(pattern, "\u0000");
        while (tok.hasMoreTokens()) {
            String pat = tok.nextToken();
            if (pat.equals("\\/")) {
                this.patterns.add(CommandGroups.getInstance().getSearch().getLastSearch());
                this.flags.add(65536);
                continue;
            }
            if (pat.equals("\\?")) {
                this.patterns.add(CommandGroups.getInstance().getSearch().getLastSearch());
                this.flags.add(131072);
                continue;
            }
            if (pat.equals("\\&")) {
                this.patterns.add(CommandGroups.getInstance().getSearch().getLastPattern());
                this.flags.add(65536);
                continue;
            }
            if (pat.charAt(0) == '/') {
                this.flags.add(65536);
            } else {
                this.flags.add(131072);
            }
            pat = pat.substring(1);
            if (pat.charAt(pat.length() - 1) == pat.charAt(0)) {
                pat = pat.substring(0, pat.length() - 1);
            }
            this.patterns.add(pat);
        }
    }

    protected int getRangeLine(Editor editor, DataPackage context, boolean lastZero) {
        int line = EditorHelper.getCurrentLogicalLine(editor);
        int pos = -1;
        for (int i = 0; i < this.patterns.size(); ++i) {
            String pattern = this.patterns.get(i);
            int flag = this.flags.get(i);
            pos = (flag & 0x10000) != 0 && !lastZero ? CommandGroups.getInstance().getMotion().moveCaretToLineEnd(editor, line, true) : CommandGroups.getInstance().getMotion().moveCaretToLineStart(editor, line);
            pos = CommandGroups.getInstance().getSearch().search(editor, context, pattern, pos, 1, flag);
            if (pos == -1) break;
            line = editor.offsetToLogicalPosition((int)pos).line;
        }
        if (pos != -1) {
            return line;
        }
        return -1;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("SearchRange[");
        res.append("patterns=");
        res.append(this.patterns);
        res.append(", ");
        res.append(super.toString());
        res.append("]");
        return res.toString();
    }
}

