/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandState;
import com.maddyhome.idea.vim.common.Register;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.group.AbstractActionGroup;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.group.MotionGroup;
import com.maddyhome.idea.vim.helper.CharacterHelper;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorData;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.SearchHelper;
import com.maddyhome.idea.vim.helper.StringHelper;
import com.maddyhome.idea.vim.option.BoundListOption;
import com.maddyhome.idea.vim.option.Options;
import com.maddyhome.idea.vim.undo.UndoManager;
import java.util.ArrayList;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ChangeGroup
extends AbstractActionGroup {
    private ArrayList strokes = new ArrayList();
    private ArrayList lastStrokes;
    private int insertStart;
    private Command lastInsert;
    private boolean inInsert;
    private int repeatLines;
    private int repeatColumn;
    private boolean repeatAppend;
    private boolean lastLower = true;
    private static Logger logger = Logger.getInstance((String)ChangeGroup.class.getName());

    public ChangeGroup() {
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new EditorFactoryAdapter(){
            private EditorMouseAdapter listener = new EditorMouseAdapter(){

                public void mouseClicked(EditorMouseEvent event) {
                    Editor editor = event.getEditor();
                    if (!VimPlugin.isEnabled()) {
                        return;
                    }
                    if (CommandState.getInstance(editor).getMode() == 2 || CommandState.getInstance(editor).getMode() == 3) {
                        ChangeGroup.this.clearStrokes(editor);
                    }
                }
            };

            public void editorCreated(EditorFactoryEvent event) {
                Editor editor = event.getEditor();
                editor.addEditorMouseListener((EditorMouseListener)this.listener);
                EditorData.setChangeGroup(editor, true);
            }

            public void editorReleased(EditorFactoryEvent event) {
                Editor editor = event.getEditor();
                if (EditorData.getChangeGroup(editor)) {
                    editor.removeEditorMouseListener((EditorMouseListener)this.listener);
                    EditorData.setChangeGroup(editor, false);
                }
            }
        });
    }

    public void setInsertRepeat(int lines, int column, boolean append) {
        this.repeatLines = lines;
        this.repeatColumn = column;
        this.repeatAppend = append;
    }

    public void insertBeforeCursor(Editor editor, DataPackage context) {
        this.initInsert(editor, context, 2);
    }

    public void insertBeforeFirstNonBlank(Editor editor, DataPackage context) {
        MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretToLineStartSkipLeading(editor));
        this.initInsert(editor, context, 2);
    }

    public void insertLineStart(Editor editor, DataPackage context) {
        MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretToLineStart(editor));
        this.initInsert(editor, context, 2);
    }

    public void insertAfterCursor(Editor editor, DataPackage context) {
        MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretHorizontal(editor, 1, true));
        this.initInsert(editor, context, 2);
    }

    public void insertAfterLineEnd(Editor editor, DataPackage context) {
        MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretToLineEnd(editor, true));
        this.initInsert(editor, context, 2);
    }

    public void insertNewLineAbove(final Editor editor, final DataPackage context) {
        if (EditorHelper.getCurrentVisualLine(editor) == 0) {
            MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretToLineStart(editor));
            this.initInsert(editor, context, 2);
            if (!editor.isOneLineMode()) {
                CommandState state = CommandState.getInstance(editor);
                if (state.getMode() != 4) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            KeyHandler.getInstance().handleKey(editor, KeyStroke.getKeyStroke(10, 0), context);
                            MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretVertical(editor, -1));
                        }
                    });
                } else {
                    MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretVertical(editor, -1));
                }
            }
        } else {
            MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretVertical(editor, -1));
            this.insertNewLineBelow(editor, context);
        }
    }

    public void insertNewLineBelow(final Editor editor, final DataPackage context) {
        MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretToLineEnd(editor, true));
        this.initInsert(editor, context, 2);
        CommandState state = CommandState.getInstance(editor);
        if (state.getMode() != 4) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    KeyHandler.getInstance().handleKey(editor, KeyStroke.getKeyStroke(10, 0), context);
                }
            });
        }
    }

    public void insertAtPreviousInsert(Editor editor, DataPackage context) {
        int offset = CommandGroups.getInstance().getMotion().moveCaretToFileMarkLine(editor, context, '^');
        if (offset != -1) {
            MotionGroup.moveCaret(editor, context, offset);
        }
        this.insertBeforeCursor(editor, context);
    }

    public void insertPreviousInsert(Editor editor, DataPackage context, boolean exit) {
        this.repeatInsertText(editor, context, 1);
        if (exit) {
            this.processEscape(editor, context);
        }
    }

    public void insertHelp(Editor editor, DataPackage context) {
        this.processEscape(editor, context);
        KeyHandler.executeAction("HelpTopics", context);
    }

    public boolean insertRegister(Editor editor, DataPackage context, char key) {
        Register register = CommandGroups.getInstance().getRegister().getRegister(key);
        if (register != null) {
            String text = register.getText();
            for (int i = 0; i < text.length(); ++i) {
                this.processKey(editor, context, KeyStroke.getKeyStroke(text.charAt(i)));
            }
            return true;
        }
        return false;
    }

    public boolean insertCharacterAroundCursor(Editor editor, DataPackage context, int dir) {
        boolean res = false;
        VisualPosition vp = editor.getCaretModel().getVisualPosition();
        vp = new VisualPosition(vp.line + dir, vp.column);
        int len = EditorHelper.getLineLength(editor, EditorHelper.visualLineToLogicalLine(editor, vp.line));
        if (vp.column < len) {
            int offset = EditorHelper.visualPostionToOffset(editor, vp);
            char ch = EditorHelper.getDocumentChars(editor).charAt(offset);
            this.processKey(editor, context, KeyStroke.getKeyStroke(ch));
            res = true;
        }
        return res;
    }

    public boolean insertDeleteInsertedText(Editor editor, DataPackage context) {
        int deleteTo = this.insertStart;
        int offset = editor.getCaretModel().getOffset();
        if (offset == this.insertStart) {
            deleteTo = CommandGroups.getInstance().getMotion().moveCaretToLineStartSkipLeading(editor);
        }
        if (deleteTo != -1) {
            this.deleteRange(editor, context, new TextRange(deleteTo, offset), 32, false);
            return true;
        }
        return false;
    }

    public boolean insertDeletePreviousWord(Editor editor, DataPackage context) {
        int deleteTo = this.insertStart;
        int offset = editor.getCaretModel().getOffset();
        if (offset == this.insertStart) {
            deleteTo = CommandGroups.getInstance().getMotion().moveCaretToNextWord(editor, -1, false);
        }
        if (deleteTo != -1) {
            this.deleteRange(editor, context, new TextRange(deleteTo, offset), 32, false);
            return true;
        }
        return false;
    }

    private void initInsert(Editor editor, DataPackage context, int mode) {
        CommandState state = CommandState.getInstance(editor);
        this.insertStart = editor.getCaretModel().getOffset();
        CommandGroups.getInstance().getMark().setMark(editor, context, '[', this.insertStart);
        if (state.getMode() == 4) {
            if (mode == 3) {
                this.processInsert(editor, context);
            }
            if ((state.getCommand().getFlags() & 0x100) != 0) {
                this.repeatInsert(editor, context, 1, false);
            } else {
                this.repeatInsert(editor, context, state.getCommand().getCount(), false);
            }
            if (mode == 3) {
                this.processInsert(editor, context);
            }
        } else {
            this.lastInsert = state.getCommand();
            this.strokes.clear();
            this.inInsert = true;
            if (mode == 3) {
                this.processInsert(editor, context);
            }
            state.pushState(mode, 0, 8);
            ChangeGroup.resetCursor(editor, true);
        }
    }

    private void repeatInsert(Editor editor, DataPackage context, int count, boolean started) {
        int cpos;
        if (this.repeatLines > 0) {
            int vline = EditorHelper.getCurrentVisualLine(editor);
            int lline = EditorHelper.getCurrentLogicalLine(editor);
            cpos = editor.logicalPositionToOffset(new LogicalPosition(vline, this.repeatColumn));
            for (int i = 0; i < this.repeatLines; ++i) {
                String pad;
                if (this.repeatAppend && this.repeatColumn < 9999 && EditorHelper.getVisualLineLength(editor, vline + i) < this.repeatColumn && (pad = EditorHelper.pad(editor, lline + i, this.repeatColumn)).length() > 0) {
                    int off = editor.getDocument().getLineEndOffset(lline + i);
                    this.insertText(editor, context, off, pad);
                }
                if (this.repeatColumn >= 9999) {
                    editor.getCaretModel().moveToOffset(CommandGroups.getInstance().getMotion().moveCaretToLineEnd(editor, lline + i, true));
                    this.repeatInsertText(editor, context, started ? (i == 0 ? count : count + 1) : count);
                    continue;
                }
                if (EditorHelper.getVisualLineLength(editor, vline + i) < this.repeatColumn) continue;
                editor.getCaretModel().moveToVisualPosition(new VisualPosition(vline + i, this.repeatColumn));
                this.repeatInsertText(editor, context, started ? (i == 0 ? count : count + 1) : count);
            }
        } else {
            this.repeatInsertText(editor, context, count);
            cpos = CommandGroups.getInstance().getMotion().moveCaretHorizontal(editor, -1, false);
        }
        this.repeatLines = 0;
        this.repeatColumn = 0;
        this.repeatAppend = false;
        MotionGroup.moveCaret(editor, context, cpos);
    }

    private void repeatInsertText(Editor editor, DataPackage context, int count) {
        for (int i = 0; i < count; ++i) {
            for (Object lastStroke : this.lastStrokes) {
                if (lastStroke instanceof AnAction) {
                    KeyHandler.executeAction((AnAction)lastStroke, context);
                    this.strokes.add(lastStroke);
                    continue;
                }
                if (!(lastStroke instanceof Character)) continue;
                this.processKey(editor, context, KeyStroke.getKeyStroke(((Character)lastStroke).charValue()));
            }
        }
    }

    public void processEscape(Editor editor, DataPackage context) {
        logger.debug("processing escape");
        int cnt = this.lastInsert.getCount();
        if (CommandState.getInstance(editor).getMode() == 3) {
            KeyHandler.executeAction("VimInsertReplaceToggle", context);
        }
        if ((this.lastInsert.getFlags() & 0x100) != 0) {
            cnt = 1;
        }
        this.lastStrokes = new ArrayList(this.strokes);
        this.repeatInsert(editor, context, cnt - 1, true);
        CommandGroups.getInstance().getMark().setMark(editor, context, '^', editor.getCaretModel().getOffset());
        CommandGroups.getInstance().getMark().setMark(editor, context, ']', editor.getCaretModel().getOffset());
        CommandState.getInstance(editor).popState();
        if (!CommandState.inInsertMode(editor)) {
            ChangeGroup.resetCursor(editor, false);
        }
        UndoManager.getInstance().endCommand(editor);
        UndoManager.getInstance().beginCommand(editor);
    }

    public void processEnter(Editor editor, DataPackage context) {
        if (editor.isOneLineMode()) {
            return;
        }
        if (CommandState.getInstance(editor).getMode() == 3) {
            KeyHandler.executeAction("VimEditorToggleInsertState", context);
        }
        KeyHandler.executeAction("VimEditorEnter", context);
        if (CommandState.getInstance(editor).getMode() == 3) {
            KeyHandler.executeAction("VimEditorToggleInsertState", context);
        }
    }

    public void processInsert(Editor editor, DataPackage context) {
        KeyHandler.executeAction("VimEditorToggleInsertState", context);
        CommandState.getInstance(editor).toggleInsertOverwrite();
        this.inInsert = !this.inInsert;
    }

    public void processSingleCommand(Editor editor, DataPackage context) {
        CommandState.getInstance(editor).pushState(1, 1, 1);
        this.clearStrokes(editor);
    }

    public boolean processKey(final Editor editor, final DataPackage context, final KeyStroke key) {
        if (logger.isDebugEnabled()) {
            logger.debug("processKey(" + key + ")");
        }
        if (key.getKeyChar() != '\uffff') {
            this.strokes.add(Character.valueOf(key.getKeyChar()));
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                public void run() {
                    KeyHandler.getInstance().getOriginalHandler().execute(editor, key.getKeyChar(), context.getDataContext());
                }
            });
            return true;
        }
        return false;
    }

    public boolean processCommand(Editor editor, DataPackage context, Command cmd) {
        if ((cmd.getFlags() & 0x400) != 0) {
            this.strokes.add(cmd.getAction());
            return true;
        }
        if ((cmd.getFlags() & 0x200) != 0) {
            this.clearStrokes(editor);
            return false;
        }
        return false;
    }

    private void clearStrokes(Editor editor) {
        this.strokes.clear();
        this.insertStart = editor.getCaretModel().getOffset();
    }

    public boolean deleteCharacter(Editor editor, DataPackage context, int count) {
        int offset = CommandGroups.getInstance().getMotion().moveCaretHorizontal(editor, count, true);
        if (offset != -1) {
            boolean res = this.deleteText(editor, context, new TextRange(editor.getCaretModel().getOffset(), offset), 16);
            int pos = editor.getCaretModel().getOffset();
            int norm = EditorHelper.normalizeOffset(editor, EditorHelper.getCurrentLogicalLine(editor), pos, false);
            if (norm != pos) {
                MotionGroup.moveCaret(editor, context, norm);
            }
            return res;
        }
        return false;
    }

    public boolean deleteLine(Editor editor, DataPackage context, int count) {
        int start = CommandGroups.getInstance().getMotion().moveCaretToLineStart(editor);
        int offset = Math.min(CommandGroups.getInstance().getMotion().moveCaretToLineEndOffset(editor, count - 1, true) + 1, EditorHelper.getFileSize(editor, true));
        if (logger.isDebugEnabled()) {
            logger.debug("start=" + start);
            logger.debug("offset=" + offset);
        }
        if (offset != -1) {
            boolean res = this.deleteText(editor, context, new TextRange(start, offset), 2);
            if (res && editor.getCaretModel().getOffset() >= EditorHelper.getFileSize(editor) && editor.getCaretModel().getOffset() != 0) {
                MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretToLineStartSkipLeadingOffset(editor, -1));
            }
            return res;
        }
        return false;
    }

    public boolean deleteEndOfLine(Editor editor, DataPackage context, int count) {
        int offset = CommandGroups.getInstance().getMotion().moveCaretToLineEndOffset(editor, count - 1, true);
        if (offset != -1) {
            boolean res = this.deleteText(editor, context, new TextRange(editor.getCaretModel().getOffset(), offset), 16);
            int pos = CommandGroups.getInstance().getMotion().moveCaretHorizontal(editor, -1, false);
            if (pos != -1) {
                MotionGroup.moveCaret(editor, context, pos);
            }
            return res;
        }
        return false;
    }

    public boolean deleteJoinLines(Editor editor, DataPackage context, int count, boolean spaces) {
        int total;
        int lline;
        if (count < 2) {
            count = 2;
        }
        if ((lline = EditorHelper.getCurrentLogicalLine(editor)) + count > (total = EditorHelper.getLineCount(editor))) {
            return false;
        }
        return this.deleteJoinNLines(editor, context, lline, count, spaces);
    }

    public boolean deleteJoinRange(Editor editor, DataPackage context, TextRange range, boolean spaces) {
        int endLine = editor.offsetToLogicalPosition((int)range.getEndOffset()).line;
        int startLine = editor.offsetToLogicalPosition((int)range.getStartOffset()).line;
        int count = endLine - startLine + 1;
        if (count < 2) {
            count = 2;
        }
        return this.deleteJoinNLines(editor, context, startLine, count, spaces);
    }

    private boolean deleteJoinNLines(Editor editor, DataPackage context, int startLine, int count, boolean spaces) {
        MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretToLineEnd(editor, startLine, true));
        for (int i = 1; i < count; ++i) {
            int start = CommandGroups.getInstance().getMotion().moveCaretToLineEnd(editor, true);
            MotionGroup.moveCaret(editor, context, start);
            int offset = spaces ? CommandGroups.getInstance().getMotion().moveCaretToLineStartSkipLeadingOffset(editor, 1) : CommandGroups.getInstance().getMotion().moveCaretToLineStartOffset(editor, 1);
            this.deleteText(editor, context, new TextRange(editor.getCaretModel().getOffset(), offset), 0);
            if (!spaces) continue;
            this.insertText(editor, context, start, " ");
            MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretHorizontal(editor, -1, false));
        }
        return true;
    }

    public boolean deleteMotion(Editor editor, DataPackage context, int count, int rawCount, Argument argument, boolean isChange) {
        TextRange range = MotionGroup.getMotionRange(editor, context, count, rawCount, argument, true, false);
        if (range == null) {
            return EditorHelper.getFileSize(editor) == 0;
        }
        String text = ((Object)EditorHelper.getDocumentChars(editor).subSequence(range.getStartOffset(), range.getEndOffset())).toString();
        if (text.indexOf(10) >= 0 && range.getStartOffset() != 0 && EditorHelper.getDocumentChars(editor).charAt(range.getStartOffset() - 1) != '\n') {
            String id = ActionManager.getInstance().getId(argument.getMotion().getAction());
            if (logger.isDebugEnabled()) {
                logger.debug("action id=" + id);
            }
            if (id.equals("VimMotionWordRight") || id.equals("VimMotionBigWordRight") || id.equals("VimMotionCamelRight")) {
                range = new TextRange(range.getStartOffset(), range.getEndOffset() - 1);
            }
        }
        if (!isChange && (argument.getMotion().getFlags() & 2) == 0) {
            LogicalPosition start = editor.offsetToLogicalPosition(range.getStartOffset());
            LogicalPosition end = editor.offsetToLogicalPosition(range.getEndOffset());
            if (start.line != end.line && !SearchHelper.anyNonWhitespace(editor, range.getStartOffset(), -1) && !SearchHelper.anyNonWhitespace(editor, range.getEndOffset(), 1)) {
                int flags = argument.getMotion().getFlags();
                flags &= 0xFFFFFFDF;
                flags &= 0xFFFFFFEF;
                argument.getMotion().setFlags(flags |= 2);
            }
        }
        return this.deleteRange(editor, context, range, argument.getMotion().getFlags(), isChange);
    }

    public boolean deleteRange(Editor editor, DataPackage context, TextRange range, int type, boolean isChange) {
        if (range == null) {
            return false;
        }
        boolean res = this.deleteText(editor, context, range, type);
        if (res && editor.getCaretModel().getOffset() >= EditorHelper.getFileSize(editor) && editor.getCaretModel().getOffset() != 0 && !isChange) {
            MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretToLineStartSkipLeadingOffset(editor, -1));
        } else if (res && range.isMultiple()) {
            MotionGroup.moveCaret(editor, context, range.getStartOffset());
        } else if (res && !isChange) {
            VisualPosition vp = editor.getCaretModel().getVisualPosition();
            int col = EditorHelper.normalizeVisualColumn(editor, vp.line, vp.column, false);
            if (col != vp.column) {
                editor.getCaretModel().moveToVisualPosition(new VisualPosition(vp.line, col));
            }
        }
        return res;
    }

    public boolean changeReplace(Editor editor, DataPackage context) {
        this.initInsert(editor, context, 3);
        return true;
    }

    public boolean changeCharacter(Editor editor, DataPackage context, int count, char ch) {
        int col = EditorHelper.getCurrentLogicalColumn(editor);
        int len = EditorHelper.getLineLength(editor);
        int offset = editor.getCaretModel().getOffset();
        if (len - col < count) {
            return false;
        }
        int num = count;
        String space = null;
        if (ch == '\n') {
            num = 1;
            space = EditorHelper.getLeadingWhitespace(editor, editor.offsetToLogicalPosition((int)offset).line);
            if (logger.isDebugEnabled()) {
                logger.debug("space='" + space + "'");
            }
        }
        StringBuffer repl = new StringBuffer(count);
        for (int i = 0; i < num; ++i) {
            repl.append(ch);
        }
        this.replaceText(editor, context, offset, offset + count, repl.toString());
        if (ch == '\n') {
            this.insertText(editor, context, offset + 1, space);
            int slen = space.length();
            if (slen == 0) {
                ++slen;
            }
            editor.getCaretModel().moveToOffset(offset + slen);
        }
        return true;
    }

    public boolean changeCharacterRange(Editor editor, DataPackage context, TextRange range, char ch) {
        if (logger.isDebugEnabled()) {
            logger.debug("change range: " + range + " to " + ch);
        }
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int[] starts = range.getStartOffsets();
        int[] ends = range.getEndOffsets();
        for (int j = ends.length - 1; j >= 0; --j) {
            for (int i = starts[j]; i < ends[j]; ++i) {
                if (i >= chars.length() || '\n' == chars.charAt(i)) continue;
                this.replaceText(editor, context, i, i + 1, Character.toString(ch));
            }
        }
        return true;
    }

    public boolean changeCharacters(Editor editor, DataPackage context, int count) {
        int len = EditorHelper.getLineLength(editor);
        int col = EditorHelper.getCurrentLogicalColumn(editor);
        if (col + count >= len) {
            return this.changeEndOfLine(editor, context, 1);
        }
        boolean res = this.deleteCharacter(editor, context, count);
        if (res) {
            this.initInsert(editor, context, 2);
        }
        return res;
    }

    public boolean changeLine(Editor editor, DataPackage context, int count) {
        boolean res = this.deleteLine(editor, context, count);
        if (res) {
            this.insertNewLineAbove(editor, context);
        }
        return res;
    }

    public boolean changeEndOfLine(Editor editor, DataPackage context, int count) {
        boolean res = this.deleteEndOfLine(editor, context, count);
        if (res) {
            this.insertAfterLineEnd(editor, context);
        }
        return res;
    }

    public boolean changeMotion(Editor editor, DataPackage context, int count, int rawCount, Argument argument) {
        boolean res;
        String id = ActionManager.getInstance().getId(argument.getMotion().getAction());
        boolean kludge = false;
        boolean skipPunc = false;
        if (id.equals("VimMotionWordRight")) {
            if (EditorHelper.getFileSize(editor) > 0 && !Character.isWhitespace(EditorHelper.getDocumentChars(editor).charAt(editor.getCaretModel().getOffset()))) {
                kludge = true;
                argument.getMotion().setAction(ActionManager.getInstance().getAction("VimMotionWordEndRight"));
                argument.getMotion().setFlags(16);
            }
        } else if (id.equals("VimMotionBigWordRight")) {
            if (EditorHelper.getFileSize(editor) > 0 && !Character.isWhitespace(EditorHelper.getDocumentChars(editor).charAt(editor.getCaretModel().getOffset()))) {
                kludge = true;
                skipPunc = true;
                argument.getMotion().setAction(ActionManager.getInstance().getAction("VimMotionBigWordEndRight"));
                argument.getMotion().setFlags(16);
            }
        } else if (id.equals("VimMotionCamelRight") && EditorHelper.getFileSize(editor) > 0 && !Character.isWhitespace(EditorHelper.getDocumentChars(editor).charAt(editor.getCaretModel().getOffset()))) {
            kludge = true;
            argument.getMotion().setAction(ActionManager.getInstance().getAction("VimMotionCamelEndRight"));
            argument.getMotion().setFlags(16);
        }
        if (kludge) {
            int pos = editor.getCaretModel().getOffset();
            int size = EditorHelper.getFileSize(editor);
            int cnt = count * argument.getMotion().getCount();
            int pos1 = SearchHelper.findNextWordEnd(EditorHelper.getDocumentChars(editor), pos, size, cnt, skipPunc, false, false);
            int pos2 = SearchHelper.findNextWordEnd(EditorHelper.getDocumentChars(editor), pos1, size, -cnt, skipPunc, false, false);
            if (logger.isDebugEnabled()) {
                logger.debug("pos=" + pos);
                logger.debug("pos1=" + pos1);
                logger.debug("pos2=" + pos2);
                logger.debug("count=" + count);
                logger.debug("arg.count=" + argument.getMotion().getCount());
            }
            if (pos2 == pos) {
                if (count > 1) {
                    --count;
                    --rawCount;
                } else if (argument.getMotion().getCount() > 1) {
                    argument.getMotion().setCount(argument.getMotion().getCount() - 1);
                } else {
                    argument.getMotion().setFlags(32);
                }
            }
        }
        if (res = this.deleteMotion(editor, context, count, rawCount, argument, true)) {
            this.insertBeforeCursor(editor, context);
        }
        return res;
    }

    public boolean blockInsert(Editor editor, DataPackage context, TextRange range, boolean append) {
        LogicalPosition start = editor.offsetToLogicalPosition(range.getStartOffset());
        int lines = range.size();
        int line = start.line;
        int col = start.column;
        if (!range.isMultiple()) {
            col = 0;
        } else if (append) {
            col += range.getMaxLength();
            if (EditorData.getLastColumn(editor) == 9999) {
                col = 9999;
            }
        }
        int len = EditorHelper.getLineLength(editor, line);
        if (col < 9999 && len < col) {
            String pad = EditorHelper.pad(editor, line, col);
            int off = editor.getDocument().getLineEndOffset(line);
            this.insertText(editor, context, off, pad);
        }
        if (range.isMultiple() || !append) {
            editor.getCaretModel().moveToOffset(editor.logicalPositionToOffset(new LogicalPosition(line, col)));
        }
        if (range.isMultiple()) {
            this.setInsertRepeat(lines, col, append);
        }
        if (range.isMultiple() || !append) {
            this.insertBeforeCursor(editor, context);
        } else {
            this.insertAfterCursor(editor, context);
        }
        return true;
    }

    public boolean changeRange(Editor editor, DataPackage context, TextRange range, int type) {
        int col = 0;
        int lines = 0;
        if (type == 8) {
            lines = range.size();
            col = editor.offsetToLogicalPosition((int)range.getStartOffset()).column;
            if (EditorData.getLastColumn(editor) == 9999) {
                col = 9999;
            }
        }
        boolean after = range.getEndOffset() >= EditorHelper.getFileSize(editor);
        boolean res = this.deleteRange(editor, context, range, type, true);
        if (res) {
            if (type == 2) {
                if (after) {
                    this.insertNewLineBelow(editor, context);
                } else {
                    this.insertNewLineAbove(editor, context);
                }
            } else {
                if (type == 8) {
                    this.setInsertRepeat(lines, col, false);
                }
                this.insertBeforeCursor(editor, context);
            }
        }
        return res;
    }

    public boolean changeCaseToggleCharacter(Editor editor, DataPackage context, int count) {
        int offset = CommandGroups.getInstance().getMotion().moveCaretHorizontal(editor, count, true);
        if (offset == -1) {
            return false;
        }
        this.changeCase(editor, context, editor.getCaretModel().getOffset(), offset, '~');
        offset = EditorHelper.normalizeOffset(editor, offset, false);
        MotionGroup.moveCaret(editor, context, offset);
        return true;
    }

    public boolean changeCaseMotion(Editor editor, DataPackage context, int count, int rawCount, char type, Argument argument) {
        TextRange range = MotionGroup.getMotionRange(editor, context, count, rawCount, argument, true, false);
        return this.changeCaseRange(editor, context, range, type);
    }

    public boolean changeCaseRange(Editor editor, DataPackage context, TextRange range, char type) {
        if (range == null) {
            return false;
        }
        int[] starts = range.getStartOffsets();
        int[] ends = range.getEndOffsets();
        for (int i = ends.length - 1; i >= 0; --i) {
            this.changeCase(editor, context, starts[i], ends[i], type);
        }
        MotionGroup.moveCaret(editor, context, range.getStartOffset());
        return true;
    }

    private void changeCase(Editor editor, DataPackage context, int start, int end, char type) {
        if (start > end) {
            int t = end;
            end = start;
            start = t;
        }
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        for (int i = start; i < end && i < chars.length(); ++i) {
            char ch = CharacterHelper.changeCase(chars.charAt(i), type);
            if (ch == chars.charAt(i)) continue;
            this.replaceText(editor, context, i, i + 1, Character.toString(ch));
        }
    }

    public void autoIndentLines(Editor editor, DataPackage context, int lines) {
        KeyHandler.executeAction("OrigAutoIndentLines", context);
    }

    public void indentLines(Editor editor, DataPackage context, int lines, int dir) {
        Character key;
        Object stroke;
        int cnt = 1;
        if ((CommandState.getInstance(editor).getMode() == 2 || CommandState.getInstance(editor).getMode() == 3) && this.strokes.size() > 0 && (stroke = this.strokes.get(this.strokes.size() - 1)) instanceof Character && (key = (Character)stroke).charValue() == '0') {
            this.deleteCharacter(editor, context, -1);
            cnt = 99;
        }
        int start = editor.getCaretModel().getOffset();
        int end = CommandGroups.getInstance().getMotion().moveCaretToLineEndOffset(editor, lines - 1, false);
        this.indentRange(editor, context, new TextRange(start, end), cnt, dir);
    }

    public void indentMotion(Editor editor, DataPackage context, int count, int rawCount, Argument argument, int dir) {
        TextRange range = MotionGroup.getMotionRange(editor, context, count, rawCount, argument, false, false);
        this.indentRange(editor, context, range, 1, dir);
    }

    public void indentRange(Editor editor, DataPackage context, TextRange range, int count, int dir) {
        if (logger.isDebugEnabled()) {
            logger.debug("count=" + count);
        }
        if (range == null) {
            return;
        }
        Project proj = context.getProject();
        int tabSize = 8;
        int indentSize = 8;
        boolean useTabs = true;
        VirtualFile file = EditorData.getVirtualFile(editor);
        if (file != null) {
            FileType type = FileTypeManager.getInstance().getFileTypeByFile(file);
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)proj);
            tabSize = settings.getTabSize(type);
            indentSize = settings.getIndentSize(type);
            useTabs = settings.useTabCharacter(type);
        }
        int sline = editor.offsetToLogicalPosition((int)range.getStartOffset()).line;
        int eline = editor.offsetToLogicalPosition((int)range.getEndOffset()).line;
        int eoff = EditorHelper.getLineStartForOffset(editor, range.getEndOffset());
        if (eoff == range.getEndOffset()) {
            --eline;
        }
        if (range.isMultiple()) {
            int col = editor.offsetToLogicalPosition((int)range.getStartOffset()).column;
            int size = indentSize * count;
            if (dir == 1) {
                int i;
                int spcCnt;
                StringBuffer space = new StringBuffer();
                int tabCnt = 0;
                if (useTabs) {
                    tabCnt = size / tabSize;
                    spcCnt = size % tabSize;
                } else {
                    spcCnt = size;
                }
                for (i = 0; i < tabCnt; ++i) {
                    space.append('\t');
                }
                for (i = 0; i < spcCnt; ++i) {
                    space.append(' ');
                }
                for (int l = sline; l <= eline; ++l) {
                    int len = EditorHelper.getLineLength(editor, l);
                    if (len <= col) continue;
                    LogicalPosition spos = new LogicalPosition(l, col);
                    this.insertText(editor, context, editor.logicalPositionToOffset(spos), space.toString());
                }
            } else {
                CharSequence chars = EditorHelper.getDocumentChars(editor);
                for (int l = sline; l <= eline; ++l) {
                    int pos;
                    int len = EditorHelper.getLineLength(editor, l);
                    if (len <= col) continue;
                    LogicalPosition spos = new LogicalPosition(l, col);
                    LogicalPosition epos = new LogicalPosition(l, col + size - 1);
                    int wsoff = editor.logicalPositionToOffset(spos);
                    int weoff = editor.logicalPositionToOffset(epos);
                    for (pos = wsoff; pos <= weoff && CharacterHelper.charType(chars.charAt(pos), false) == 3; ++pos) {
                    }
                    if (pos <= wsoff) continue;
                    this.deleteText(editor, context, new TextRange(wsoff, pos), 0);
                }
            }
        } else {
            for (int l = sline; l <= eline; ++l) {
                int i;
                int spcCnt;
                int soff = EditorHelper.getLineStartOffset(editor, l);
                int woff = CommandGroups.getInstance().getMotion().moveCaretToLineStartSkipLeading(editor, l);
                int col = editor.offsetToVisualPosition((int)woff).column;
                int newCol = Math.max(0, col + dir * indentSize * count);
                if (dir != 1 && col <= 0) continue;
                StringBuffer space = new StringBuffer();
                int tabCnt = 0;
                if (useTabs) {
                    tabCnt = newCol / tabSize;
                    spcCnt = newCol % tabSize;
                } else {
                    spcCnt = newCol;
                }
                for (i = 0; i < tabCnt; ++i) {
                    space.append('\t');
                }
                for (i = 0; i < spcCnt; ++i) {
                    space.append(' ');
                }
                this.replaceText(editor, context, soff, woff, space.toString());
            }
        }
        if (CommandState.getInstance(editor).getMode() != 2 && CommandState.getInstance(editor).getMode() != 3) {
            if (!range.isMultiple()) {
                MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretToLineStartSkipLeading(editor, sline));
            } else {
                MotionGroup.moveCaret(editor, context, range.getStartOffset());
            }
        }
        EditorData.setLastColumn(editor, editor.getCaretModel().getVisualPosition().column);
    }

    public void insertText(Editor editor, DataPackage context, int start, String str) {
        editor.getDocument().insertString(start, (CharSequence)str);
        editor.getCaretModel().moveToOffset(start + str.length());
        CommandGroups.getInstance().getMark().setMark(editor, context, '.', start);
    }

    private boolean deleteText(Editor editor, DataPackage context, TextRange range, int type) {
        int start;
        if (range.size() == 1 && range.getStartOffset() > range.getEndOffset()) {
            start = Math.max(0, Math.min(range.getStartOffset(), EditorHelper.getFileSize(editor, true)));
            int end = Math.max(0, Math.min(range.getEndOffset(), EditorHelper.getFileSize(editor, true)));
            range = new TextRange(end, start);
        }
        if (type == 0 || CommandGroups.getInstance().getRegister().storeText(editor, context, range, type, true, false)) {
            for (int i = range.size() - 1; i >= 0; --i) {
                editor.getDocument().deleteString(range.getStartOffsets()[i], range.getEndOffsets()[i]);
            }
            if (type != 0) {
                start = range.getStartOffset();
                CommandGroups.getInstance().getMark().setMark(editor, context, '.', start);
                CommandGroups.getInstance().getMark().setMark(editor, context, '[', start);
                CommandGroups.getInstance().getMark().setMark(editor, context, ']', start);
            }
            return true;
        }
        return false;
    }

    private void replaceText(Editor editor, DataPackage context, int start, int end, String str) {
        editor.getDocument().replaceString(start, end, (CharSequence)str);
        CommandGroups.getInstance().getMark().setMark(editor, context, '[', start);
        CommandGroups.getInstance().getMark().setMark(editor, context, ']', start + str.length());
        CommandGroups.getInstance().getMark().setMark(editor, context, '.', start + str.length());
    }

    private static void resetCursor(Editor editor, boolean insert) {
        Document doc = editor.getDocument();
        VirtualFile vf = FileDocumentManager.getInstance().getFile(doc);
        if (vf != null) {
            ChangeGroup.resetCursor(vf, EditorData.getProject(editor), insert);
        } else {
            editor.getSettings().setBlockCursor(!insert);
        }
    }

    private static void resetCursor(VirtualFile virtualFile, Project proj, boolean insert) {
        logger.debug("resetCursor");
        Document doc = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (doc == null) {
            return;
        }
        Editor[] editors = EditorFactory.getInstance().getEditors(doc, proj);
        if (logger.isDebugEnabled()) {
            logger.debug("There are " + editors.length + " editors for virtual file " + virtualFile.getName());
        }
        for (Editor editor : editors) {
            editor.getSettings().setBlockCursor(!insert);
        }
    }

    public boolean changeNumber(Editor editor, DataPackage context, int count) {
        boolean octal;
        boolean hex;
        BoundListOption nf = (BoundListOption)Options.getInstance().getOption("nrformats");
        boolean alpha = nf.contains("alpha");
        TextRange range = SearchHelper.findNumberUnderCursor(editor, alpha, hex = nf.contains("hex"), octal = nf.contains("octal"));
        if (range == null) {
            logger.debug("no number on line");
            return false;
        }
        String text = EditorHelper.getText(editor, range);
        if (logger.isDebugEnabled()) {
            logger.debug("found range " + range);
            logger.debug("text=" + text);
        }
        String number = text;
        if (text.length() == 0) {
            return false;
        }
        char ch = text.charAt(0);
        if (hex && text.toLowerCase().startsWith("0x")) {
            for (int i = text.length() - 1; i >= 2; --i) {
                int index = "abcdefABCDEF".indexOf(text.charAt(i));
                if (index < 0) continue;
                this.lastLower = index < 6;
                break;
            }
            int num = (int)Long.parseLong(text.substring(2), 16);
            number = Integer.toHexString(num += count);
            number = StringHelper.pad(number, text.length() - 2, '0');
            if (!this.lastLower) {
                number = number.toUpperCase();
            }
            number = text.substring(0, 2) + number;
        } else if (octal && text.startsWith("0") && text.length() > 1) {
            int num = (int)Long.parseLong(text, 8);
            number = Integer.toOctalString(num += count);
            number = "0" + StringHelper.pad(number, text.length() - 1, '0');
        } else if (alpha && (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
            if ((ch = (char)(ch + count)) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                number = "" + ch;
            }
        } else if (ch == '-' || ch >= '0' && ch <= '9') {
            boolean pad = ch == '0';
            int len = text.length();
            if (ch == '-' && text.charAt(1) == '0') {
                pad = true;
                --len;
            }
            int num = Integer.parseInt(text);
            number = Integer.toString(num += count);
            if (!octal && pad) {
                boolean neg = false;
                if (number.charAt(0) == '-') {
                    neg = true;
                    number = number.substring(1);
                }
                number = StringHelper.pad(number, len, '0');
                if (neg) {
                    number = "-" + number;
                }
            }
        }
        if (!text.equals(number)) {
            this.replaceText(editor, context, range.getStartOffset(), range.getEndOffset(), number);
            editor.getCaretModel().moveToOffset(range.getStartOffset() + number.length() - 1);
        }
        return true;
    }

    public static class InsertCheck
    extends FileEditorManagerAdapter {
        public void fileOpened(FileEditorManager fileEditorManager, VirtualFile virtualFile) {
            if (!VimPlugin.isEnabled()) {
                return;
            }
            ChangeGroup.resetCursor(virtualFile, EditorData.getProject(fileEditorManager), false);
        }

        public void selectionChanged(FileEditorManagerEvent event) {
            VirtualFile virtualFile;
            if (!VimPlugin.isEnabled()) {
                return;
            }
            logger.debug("selected file changed");
            FileEditor fe = event.getOldEditor();
            if (fe instanceof TextEditor) {
                Editor editor = ((TextEditor)event.getOldEditor()).getEditor();
                CommandState.getInstance(editor).reset();
                KeyHandler.getInstance().fullReset(editor);
            }
            if ((virtualFile = event.getOldFile()) != null) {
                ChangeGroup.resetCursor(virtualFile, EditorData.getProject(event.getManager()), false);
            }
        }
    }
}

