/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.CommandState;
import com.maddyhome.idea.vim.common.Register;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.group.AbstractActionGroup;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.group.MotionGroup;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorHelper;
import java.util.StringTokenizer;

public class CopyGroup
extends AbstractActionGroup {
    private static Logger logger = Logger.getInstance((String)CopyGroup.class.getName());

    public boolean yankMotion(Editor editor, DataPackage context, int count, int rawCount, Argument argument) {
        TextRange range = MotionGroup.getMotionRange(editor, context, count, rawCount, argument, true, false);
        return this.yankRange(editor, context, range, argument.getMotion().getFlags(), true);
    }

    public boolean yankLine(Editor editor, DataPackage context, int count) {
        int start = CommandGroups.getInstance().getMotion().moveCaretToLineStart(editor);
        int offset = Math.min(CommandGroups.getInstance().getMotion().moveCaretToLineEndOffset(editor, count - 1, true) + 1, EditorHelper.getFileSize(editor));
        if (offset != -1) {
            return this.yankRange(editor, context, new TextRange(start, offset), 2, false);
        }
        return false;
    }

    public boolean yankRange(Editor editor, DataPackage context, TextRange range, int type, boolean moveCursor) {
        if (range != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("yanking range: " + range);
            }
            boolean res = CommandGroups.getInstance().getRegister().storeText(editor, context, range, type, false, true);
            if (moveCursor) {
                MotionGroup.moveCaret(editor, context, range.normalize().getStartOffset());
            }
            return res;
        }
        return false;
    }

    public boolean putTextBeforeCursor(Editor editor, DataPackage context, int count, boolean indent, boolean cursorAfter) {
        Register reg = CommandGroups.getInstance().getRegister().getLastRegister();
        if (reg != null) {
            if ((reg.getType() & 2) != 0 && editor.isOneLineMode()) {
                return false;
            }
            int pos = (reg.getType() & 2) != 0 ? CommandGroups.getInstance().getMotion().moveCaretToLineStart(editor) : editor.getCaretModel().getOffset();
            this.putText(editor, context, pos, reg.getText(), reg.getType(), count, indent, cursorAfter, 0);
            return true;
        }
        return false;
    }

    public boolean putTextAfterCursor(Editor editor, DataPackage context, int count, boolean indent, boolean cursorAfter) {
        Register reg = CommandGroups.getInstance().getRegister().getLastRegister();
        if (reg != null) {
            int pos;
            if ((reg.getType() & 2) != 0 && editor.isOneLineMode()) {
                return false;
            }
            if ((reg.getType() & 2) != 0) {
                pos = Math.min(editor.getDocument().getTextLength(), CommandGroups.getInstance().getMotion().moveCaretToLineEnd(editor, true) + 1);
                if (pos > 0 && pos == editor.getDocument().getTextLength() && EditorHelper.getDocumentChars(editor).charAt(pos - 1) != '\n') {
                    editor.getDocument().insertString(pos, (CharSequence)"\n");
                    ++pos;
                }
            } else {
                pos = editor.getCaretModel().getOffset() + 1;
            }
            this.putText(editor, context, pos, reg.getText(), reg.getType(), count, indent, cursorAfter, 0);
            return true;
        }
        return false;
    }

    public boolean putVisualRange(Editor editor, DataPackage context, TextRange range, int count, boolean indent, boolean cursorAfter) {
        int type = CommandState.getInstance(editor).getSubMode();
        Register reg = CommandGroups.getInstance().getRegister().getLastRegister();
        CommandGroups.getInstance().getRegister().resetRegister();
        if (reg != null) {
            if ((reg.getType() & 2) != 0 && editor.isOneLineMode()) {
                return false;
            }
            int start = range.getStartOffset();
            int end = range.getEndOffset();
            int endLine = editor.offsetToLogicalPosition((int)end).line;
            if (logger.isDebugEnabled()) {
                logger.debug("start=" + start);
                logger.debug("end=" + end);
            }
            if ((type & 2) != 0) {
                range = new TextRange(range.getStartOffset(), Math.min(range.getEndOffset() + 1, EditorHelper.getFileSize(editor)));
            }
            CommandGroups.getInstance().getChange().deleteRange(editor, context, range, type, false);
            editor.getCaretModel().moveToOffset(start);
            int pos = start;
            if ((reg.getType() & 2) != 0) {
                if ((type & 2) == 0) {
                    if ((type & 8) != 0) {
                        pos = editor.getDocument().getLineEndOffset(endLine) + 1;
                    } else {
                        editor.getDocument().insertString(start, (CharSequence)"\n");
                        pos = start + 1;
                    }
                }
            } else if ((reg.getType() & 8) == 0 && (type & 2) != 0) {
                editor.getDocument().insertString(start, (CharSequence)"\n");
            }
            this.putText(editor, context, pos, reg.getText(), reg.getType(), count, indent && reg.getType() == 2, cursorAfter, type);
            return true;
        }
        return false;
    }

    public void putText(Editor editor, DataPackage context, int offset, String text, int type, int count, boolean indent, boolean cursorAfter, int mode) {
        if (logger.isDebugEnabled()) {
            logger.debug("offset=" + offset);
            logger.debug("type=" + type);
            logger.debug("mode=" + mode);
        }
        if ((mode & 2) != 0 && editor.isOneLineMode()) {
            return;
        }
        if (indent && (type & 2) == 0 && (mode & 2) == 0) {
            indent = false;
        }
        if ((type & 2) != 0 && text.length() > 0 && text.charAt(text.length() - 1) != '\n') {
            text = text + '\n';
        }
        int insertCnt = 0;
        int endOffset = offset;
        if ((type & 8) == 0) {
            for (int i = 0; i < count; ++i) {
                CommandGroups.getInstance().getChange().insertText(editor, context, offset, text);
                insertCnt += text.length();
                endOffset += text.length();
            }
        } else {
            String segment;
            int i;
            LogicalPosition start = editor.offsetToLogicalPosition(offset);
            int col = (mode & 2) != 0 ? 0 : start.column;
            int line = start.line;
            if (logger.isDebugEnabled()) {
                logger.debug("col=" + col + ", line=" + line);
            }
            int lines = 1;
            for (i = 0; i < text.length(); ++i) {
                if (text.charAt(i) != '\n') continue;
                ++lines;
            }
            if (line + lines >= EditorHelper.getLineCount(editor)) {
                for (i = 0; i < line + lines - EditorHelper.getLineCount(editor); ++i) {
                    CommandGroups.getInstance().getChange().insertText(editor, context, EditorHelper.getFileSize(editor, true), "\n");
                    ++insertCnt;
                }
            }
            StringTokenizer parser = new StringTokenizer(text, "\n");
            int maxlen = 0;
            while (parser.hasMoreTokens()) {
                segment = parser.nextToken();
                maxlen = Math.max(maxlen, segment.length());
            }
            parser = new StringTokenizer(text, "\n");
            while (parser.hasMoreTokens()) {
                int insoff;
                String origSegment = segment = parser.nextToken();
                if (segment.length() < maxlen) {
                    logger.debug("short line");
                    StringBuffer extra = new StringBuffer(maxlen - segment.length());
                    for (int i2 = segment.length(); i2 < maxlen; ++i2) {
                        extra.append(' ');
                    }
                    segment = segment + extra.toString();
                    if (col != 0 && col < EditorHelper.getLineLength(editor, line)) {
                        origSegment = segment;
                    }
                }
                String pad = EditorHelper.pad(editor, line, col);
                endOffset = insoff = editor.logicalPositionToOffset(new LogicalPosition(line, col));
                if (logger.isDebugEnabled()) {
                    logger.debug("segment='" + segment + "'");
                    logger.debug("origSegment='" + origSegment + "'");
                    logger.debug("insoff=" + insoff);
                }
                for (int i3 = 0; i3 < count; ++i3) {
                    String txt = i3 == 0 ? origSegment : segment;
                    CommandGroups.getInstance().getChange().insertText(editor, context, insoff, txt);
                    insertCnt += txt.length();
                    endOffset += txt.length();
                }
                if ((mode & 2) != 0) {
                    CommandGroups.getInstance().getChange().insertText(editor, context, endOffset, "\n");
                    ++insertCnt;
                    ++endOffset;
                } else if (pad.length() > 0) {
                    CommandGroups.getInstance().getChange().insertText(editor, context, insoff, pad);
                    insertCnt += pad.length();
                    endOffset += pad.length();
                }
                ++line;
            }
        }
        LogicalPosition slp = editor.offsetToLogicalPosition(offset);
        LogicalPosition elp = editor.offsetToLogicalPosition(endOffset - 1);
        if (logger.isDebugEnabled()) {
            logger.debug("slp.line=" + slp.line);
            logger.debug("elp.line=" + elp.line);
        }
        if (indent) {
            int startOff = editor.getDocument().getLineStartOffset(slp.line);
            int endOff = editor.getDocument().getLineEndOffset(elp.line);
            editor.getSelectionModel().setSelection(startOff, endOff);
            KeyHandler.executeAction("OrigAutoIndentLines", context);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("insertCnt=" + insertCnt);
        }
        if (indent) {
            endOffset = EditorHelper.getLineEndOffset(editor, elp.line, true);
            insertCnt = endOffset - offset;
            if (logger.isDebugEnabled()) {
                logger.debug("insertCnt=" + insertCnt);
            }
        }
        int cursorMode = (type & 8) != 0 ? ((mode & 2) != 0 ? (cursorAfter ? 4 : 1) : (cursorAfter ? 5 : 1)) : ((type & 2) != 0 ? ((mode & 2) != 0 ? (cursorAfter ? 4 : 3) : (cursorAfter ? 4 : 3)) : ((mode & 2) != 0 ? (cursorAfter ? 4 : 1) : (cursorAfter ? 5 : 2)));
        switch (cursorMode) {
            case 1: {
                MotionGroup.moveCaret(editor, context, offset);
                break;
            }
            case 2: {
                MotionGroup.moveCaret(editor, context, endOffset - 1);
                break;
            }
            case 3: {
                MotionGroup.moveCaret(editor, context, offset);
                MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretToLineStartSkipLeading(editor));
                break;
            }
            case 4: {
                MotionGroup.moveCaret(editor, context, endOffset + 1);
                break;
            }
            case 5: {
                int pos = Math.min(endOffset, EditorHelper.getLineEndForOffset(editor, endOffset - 1) - 1);
                MotionGroup.moveCaret(editor, context, pos);
            }
        }
        CommandGroups.getInstance().getMark().setMark(editor, context, '[', offset);
        CommandGroups.getInstance().getMark().setMark(editor, context, ']', endOffset);
    }
}

