/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.command.CommandState;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.group.AbstractActionGroup;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorData;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.SearchHelper;
import com.maddyhome.idea.vim.helper.StringHelper;
import java.io.File;
import java.util.HashMap;

public class FileGroup
extends AbstractActionGroup {
    private static HashMap<FileEditorManager, VirtualFile> lastSelections = new HashMap();
    private static Logger logger = Logger.getInstance((String)FileGroup.class.getName());

    public boolean openFile(String filename, DataPackage context) {
        if (logger.isDebugEnabled()) {
            logger.debug("openFile(" + filename + ")");
        }
        Project proj = context.getProject();
        VirtualFile found = null;
        if (filename.length() > 2 && filename.charAt(0) == '~' && filename.charAt(1) == File.separatorChar) {
            String homefile = filename.substring(2);
            String dir = System.getProperty("user.home");
            if (logger.isDebugEnabled()) {
                logger.debug("home dir file");
                logger.debug("looking for " + homefile + " in " + dir);
            }
            found = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(dir, homefile));
        } else {
            ProjectRootManager prm = ProjectRootManager.getInstance((Project)proj);
            VirtualFile[] roots = prm.getContentRoots();
            for (int i = 0; i < roots.length; ++i) {
                if (logger.isDebugEnabled()) {
                    logger.debug("root[" + i + "] = " + roots[i].getPath());
                }
                if ((found = this.findFile(roots[i], filename)) != null) break;
            }
            if (found == null) {
                found = LocalFileSystem.getInstance().findFileByIoFile(new File(filename));
            }
        }
        if (found != null) {
            FileType type;
            if (logger.isDebugEnabled()) {
                logger.debug("found file: " + found);
            }
            if ((type = FileTypeManager.getInstance().getKnownFileTypeOrAssociate(found)) != null) {
                FileEditorManager fem = FileEditorManager.getInstance((Project)proj);
                fem.openFile(found, true);
                return true;
            }
            return true;
        }
        VimPlugin.showMessage("Unable to find " + filename);
        return false;
    }

    private VirtualFile findFile(VirtualFile root, String filename) {
        VirtualFile[] children;
        VirtualFile res = root.findFileByRelativePath(filename);
        if (res != null) {
            return res;
        }
        for (VirtualFile child : children = root.getChildren()) {
            if (child.isDirectory()) {
                res = this.findFile(child, filename);
                if (res == null) continue;
                return res;
            }
            if (!child.getName().equals(filename)) continue;
            return child;
        }
        return null;
    }

    public void closeFile(Editor editor, DataPackage context) {
        Project proj = context.getProject();
        FileEditorManager fem = FileEditorManager.getInstance((Project)proj);
        VirtualFile vf = EditorData.getVirtualFile(fem.getSelectedTextEditor());
        if (vf != null) {
            fem.closeFile(vf);
        }
    }

    public void closeAllButCurrent(DataPackage context) {
        KeyHandler.executeAction("CloseAllEditorsButCurrent", context);
    }

    public void closeAllFiles(DataPackage context) {
        KeyHandler.executeAction("CloseAllEditors", context);
    }

    public void saveFile(Editor editor, DataPackage context) {
        FileDocumentManager.getInstance().saveDocument(editor.getDocument());
    }

    public void saveFiles(DataPackage context) {
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    public void closeProject(DataPackage context) {
        KeyHandler.executeAction("CloseProject", context);
    }

    public void exitIdea() {
        ApplicationManager.getApplication().exit();
    }

    public boolean selectFile(int count, DataPackage context) {
        Project proj = context.getProject();
        FileEditorManager fem = FileEditorManager.getInstance((Project)proj);
        VirtualFile[] editors = fem.getOpenFiles();
        if (count == 99) {
            count = editors.length - 1;
        }
        if (count < 0 || count >= editors.length) {
            return false;
        }
        fem.openFile(editors[count], true);
        return true;
    }

    public void selectNextFile(int count, DataPackage context) {
        Project proj = context.getProject();
        FileEditorManager fem = FileEditorManager.getInstance((Project)proj);
        VirtualFile[] editors = fem.getOpenFiles();
        VirtualFile current = fem.getSelectedFiles()[0];
        for (int i = 0; i < editors.length; ++i) {
            if (!editors[i].equals(current)) continue;
            int pos = (i + count % editors.length + editors.length) % editors.length;
            fem.openFile(editors[pos], true);
        }
    }

    public void selectPreviousTab(DataPackage context) {
        Project proj = context.getProject();
        FileEditorManager fem = FileEditorManager.getInstance((Project)proj);
        VirtualFile vf = lastSelections.get(fem);
        if (vf != null) {
            fem.openFile(vf, true);
        } else {
            VimPlugin.indicateError();
        }
    }

    public Editor selectEditor(Project project, VirtualFile file) {
        FileEditorManager fMgr = FileEditorManager.getInstance((Project)project);
        FileEditor[] feditors = fMgr.openFile(file, true);
        if (feditors != null && feditors.length > 0 && feditors[0] instanceof TextEditor) {
            return ((TextEditor)feditors[0]).getEditor();
        }
        return null;
    }

    public void displayAsciiInfo(Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        char ch = editor.getDocument().getCharsSequence().charAt(offset);
        StringBuffer msg = new StringBuffer();
        msg.append('<');
        msg.append(StringHelper.escape("" + ch));
        msg.append(">  ");
        msg.append((int)ch);
        msg.append(",  Hex ");
        msg.append(Long.toHexString(ch));
        msg.append(",  Octal ");
        msg.append(Long.toOctalString(ch));
        VimPlugin.showMessage(msg.toString());
    }

    public void displayHexInfo(Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        char ch = editor.getDocument().getCharsSequence().charAt(offset);
        VimPlugin.showMessage(Long.toHexString(ch));
    }

    public void displayLocationInfo(Editor editor) {
        StringBuffer msg = new StringBuffer();
        Document doc = editor.getDocument();
        if (CommandState.getInstance(editor).getMode() != 5) {
            LogicalPosition lp = editor.getCaretModel().getLogicalPosition();
            int col = editor.getCaretModel().getOffset() - doc.getLineStartOffset(lp.line);
            int endoff = doc.getLineEndOffset(lp.line);
            if (doc.getCharsSequence().charAt(endoff) == '\n') {
                --endoff;
            }
            int ecol = endoff - doc.getLineStartOffset(lp.line);
            LogicalPosition elp = editor.offsetToLogicalPosition(endoff);
            msg.append("Col ").append(col + 1);
            if (col != lp.column) {
                msg.append("-").append(lp.column + 1);
            }
            msg.append(" of ").append(ecol + 1);
            if (ecol != elp.column) {
                msg.append("-").append(elp.column + 1);
            }
            int lline = EditorHelper.getCurrentLogicalLine(editor);
            int total = EditorHelper.getLineCount(editor);
            msg.append("; Line ").append(lline + 1).append(" of ").append(total);
            SearchHelper.CountPosition cp = SearchHelper.countWords(editor);
            msg.append("; Word ").append(cp.getPosition()).append(" of ").append(cp.getCount());
            int offset = editor.getCaretModel().getOffset();
            int size = EditorHelper.getFileSize(editor);
            msg.append("; Character ").append(offset + 1).append(" of ").append(size);
        } else {
            int lines;
            msg.append("Selected ");
            TextRange vr = CommandGroups.getInstance().getMotion().getVisualRange(editor);
            vr.normalize();
            SearchHelper.CountPosition cp = SearchHelper.countWords(editor);
            int words = cp.getCount();
            int word = 0;
            if (vr.isMultiple()) {
                lines = vr.size();
                int cols = vr.getMaxLength();
                msg.append(cols).append(" Cols; ");
                for (int i = 0; i < vr.size(); ++i) {
                    cp = SearchHelper.countWords(editor, vr.getStartOffsets()[i], vr.getEndOffsets()[i] - 1);
                    word += cp.getCount();
                }
            } else {
                LogicalPosition slp = editor.offsetToLogicalPosition(vr.getStartOffset());
                LogicalPosition elp = editor.offsetToLogicalPosition(vr.getEndOffset());
                lines = elp.line - slp.line + 1;
                cp = SearchHelper.countWords(editor, vr.getStartOffset(), vr.getEndOffset() - 1);
                word = cp.getCount();
            }
            int total = EditorHelper.getLineCount(editor);
            msg.append(lines).append(" of ").append(total).append(" Lines");
            msg.append("; ").append(word).append(" of ").append(words).append(" Words");
            int chars = vr.getSelectionCount();
            int size = EditorHelper.getFileSize(editor);
            msg.append("; ").append(chars).append(" of ").append(size).append(" Characters");
        }
        VimPlugin.showMessage(msg.toString());
    }

    public void displayFileInfo(Editor editor, boolean fullPath) {
        StringBuffer msg = new StringBuffer();
        VirtualFile vf = EditorData.getVirtualFile(editor);
        if (vf != null) {
            msg.append('\"');
            if (fullPath) {
                msg.append(vf.getPath());
            } else {
                Project project = EditorData.getProject(editor);
                VirtualFile root = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(vf);
                if (root != null) {
                    msg.append(vf.getPath().substring(root.getPath().length() + 1));
                } else {
                    msg.append(vf.getPath());
                }
            }
            msg.append("\" ");
        } else {
            msg.append("\"[No File]\" ");
        }
        Document doc = editor.getDocument();
        if (!doc.isWritable()) {
            msg.append("[RO] ");
        } else if (FileDocumentManager.getInstance().isDocumentUnsaved(doc)) {
            msg.append("[+] ");
        }
        int lline = EditorHelper.getCurrentLogicalLine(editor);
        int total = EditorHelper.getLineCount(editor);
        int pct = (int)((double)((float)lline / (float)total * 100.0f) + 0.5);
        msg.append("line ").append(lline + 1).append(" of ").append(total);
        msg.append(" --").append(pct).append("%-- ");
        LogicalPosition lp = editor.getCaretModel().getLogicalPosition();
        int col = editor.getCaretModel().getOffset() - doc.getLineStartOffset(lline);
        msg.append("col ").append(col + 1);
        if (col != lp.column) {
            msg.append("-").append(lp.column + 1);
        }
        VimPlugin.showMessage(msg.toString());
    }

    public static class SelectionCheck
    extends FileEditorManagerAdapter {
        public void selectionChanged(FileEditorManagerEvent event) {
            lastSelections.put(event.getManager(), event.getOldFile());
        }
    }
}

