/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.diagnostic.Logger;
import com.maddyhome.idea.vim.group.AbstractActionGroup;
import com.maddyhome.idea.vim.helper.StringHelper;
import com.maddyhome.idea.vim.option.NumberOption;
import com.maddyhome.idea.vim.option.Options;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryGroup
extends AbstractActionGroup {
    public static final String SEARCH = "search";
    public static final String COMMAND = "cmd";
    public static final String EXPRESSION = "expr";
    public static final String INPUT = "input";
    private Map<String, HistoryBlock> histories = new HashMap<String, HistoryBlock>();
    private static Logger logger = Logger.getInstance((String)HistoryGroup.class.getName());

    public void addEntry(String key, String text) {
        if (logger.isDebugEnabled()) {
            logger.debug("Add entry '" + text + "' to " + key);
        }
        HistoryBlock block = this.blocks(key);
        block.addEntry(text);
    }

    public String getEntry(String key, int index) {
        HistoryBlock block = this.blocks(key);
        return block.getEntry(index);
    }

    public List<HistoryEntry> getEntries(String key, int first, int last) {
        HistoryEntry entry;
        HistoryBlock block = this.blocks(key);
        List<HistoryEntry> entries = block.getEntries();
        ArrayList<HistoryEntry> res = new ArrayList<HistoryEntry>();
        if (first < 0) {
            if (-first > entries.size()) {
                first = Integer.MAX_VALUE;
            } else {
                entry = entries.get(entries.size() + first);
                first = entry.getNumber();
            }
        }
        if (last < 0) {
            if (-last > entries.size()) {
                last = Integer.MIN_VALUE;
            } else {
                entry = entries.get(entries.size() + last);
                last = entry.getNumber();
            }
        } else if (last == 0) {
            last = Integer.MAX_VALUE;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("first=" + first);
            logger.debug("last=" + last);
        }
        for (HistoryEntry entry2 : entries) {
            if (entry2.getNumber() < first || entry2.getNumber() > last) continue;
            res.add(entry2);
        }
        return res;
    }

    private HistoryBlock blocks(String key) {
        HistoryBlock block = this.histories.get(key);
        if (block == null) {
            block = new HistoryBlock();
            this.histories.put(key, block);
        }
        return block;
    }

    @Override
    public void saveData(Element element) {
        logger.debug("saveData");
        Element hist = new Element("history");
        this.saveData(hist, SEARCH);
        this.saveData(hist, COMMAND);
        this.saveData(hist, EXPRESSION);
        this.saveData(hist, INPUT);
        element.addContent(hist);
    }

    private void saveData(Element element, String key) {
        HistoryBlock block = this.histories.get(key);
        if (block == null) {
            return;
        }
        Element root = new Element("history-" + key);
        List<HistoryEntry> elems = block.getEntries();
        for (HistoryEntry entry : elems) {
            Element text = new Element("entry");
            CDATA data = new CDATA(StringHelper.entities(entry.getEntry()));
            text.addContent((Content)data);
            root.addContent(text);
        }
        element.addContent(root);
    }

    @Override
    public void readData(Element element) {
        logger.debug("readData");
        Element hist = element.getChild("history");
        if (hist == null) {
            return;
        }
        this.readData(hist, SEARCH);
        this.readData(hist, COMMAND);
        this.readData(hist, EXPRESSION);
        this.readData(hist, INPUT);
    }

    private void readData(Element element, String key) {
        HistoryBlock block = this.histories.get(key);
        if (block != null) {
            return;
        }
        block = new HistoryBlock();
        this.histories.put(key, block);
        Element root = element.getChild("history-" + key);
        if (root != null) {
            List items = root.getChildren("entry");
            for (Object item : items) {
                block.addEntry(StringHelper.unentities(((Element)item).getText()));
            }
        }
    }

    private static int maxLength() {
        NumberOption opt = (NumberOption)Options.getInstance().getOption("history");
        return opt.value();
    }

    public static class HistoryEntry {
        private int number;
        private String entry;

        public HistoryEntry(int number, String entry) {
            this.number = number;
            this.entry = entry;
        }

        public int getNumber() {
            return this.number;
        }

        public String getEntry() {
            return this.entry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HistoryBlock {
        private List<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        private int counter;

        private HistoryBlock() {
        }

        public void addEntry(String text) {
            for (int i = 0; i < this.entries.size(); ++i) {
                HistoryEntry entry = this.entries.get(i);
                if (!text.equals(entry.getEntry())) continue;
                this.entries.remove(i);
                break;
            }
            this.entries.add(new HistoryEntry(++this.counter, text));
            if (this.entries.size() > HistoryGroup.maxLength()) {
                this.entries.remove(0);
            }
        }

        public String getEntry(int index) {
            if (index < this.entries.size()) {
                HistoryEntry entry = this.entries.get(index);
                return entry.getEntry();
            }
            return null;
        }

        public List<HistoryEntry> getEntries() {
            return this.entries;
        }
    }
}

