/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.common.Register;
import com.maddyhome.idea.vim.group.AbstractActionGroup;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.undo.UndoManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroGroup
extends AbstractActionGroup {
    private char lastRegister = '\u0000';
    private static Logger logger = Logger.getInstance((String)MacroGroup.class.getName());

    public boolean playbackRegister(Editor editor, DataPackage context, Project project, char reg, int count) {
        Register register;
        if (logger.isDebugEnabled()) {
            logger.debug("play bakc register " + reg + " " + count + " times");
        }
        if ((register = CommandGroups.getInstance().getRegister().getPlaybackRegister(reg)) == null) {
            return false;
        }
        UndoManager.getInstance().allowNewCommands(false);
        List<KeyStroke> keys = register.getKeys();
        this.playbackKeys(editor, context, project, keys, 0, 0, count);
        this.lastRegister = reg;
        return true;
    }

    public boolean playbackLastRegister(Editor editor, DataPackage context, Project project, int count) {
        if (this.lastRegister != '\u0000') {
            return this.playbackRegister(editor, context, project, this.lastRegister, count);
        }
        return false;
    }

    public void playbackKeys(final Editor editor, final DataPackage context, final Project project, final List<KeyStroke> keys, final int pos, final int cnt, final int total) {
        if (logger.isDebugEnabled()) {
            logger.debug("playbackKeys " + pos);
        }
        if (pos >= keys.size() || cnt >= total) {
            logger.debug("done");
            if (!UndoManager.getInstance().allowNewCommands()) {
                UndoManager.getInstance().allowNewCommands(true);
                UndoManager.getInstance().endCommand(editor);
                UndoManager.getInstance().beginCommand(editor);
            }
            return;
        }
        final Runnable run = new Runnable(){

            public void run() {
                if (logger.isDebugEnabled()) {
                    logger.debug("processing key " + pos);
                }
                KeyHandler.getInstance().handleKey(editor, (KeyStroke)keys.get(pos), context);
                if (pos < keys.size() - 1) {
                    MacroGroup.this.playbackKeys(editor, context, project, keys, pos + 1, cnt, total);
                } else if (cnt < total) {
                    MacroGroup.this.playbackKeys(editor, context, project, keys, 0, cnt + 1, total);
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CommandProcessor.getInstance().executeCommand(project, run, "playback", keys.get(pos));
            }
        });
    }

    public void postKey(KeyStroke stroke, Editor editor) {
        Container component = SwingUtilities.getAncestorOfClass(Window.class, editor.getComponent());
        final KeyEvent event = this.createKeyEvent(stroke, component);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (logger.isDebugEnabled()) {
                    logger.debug("posting " + event);
                }
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(event);
            }
        });
    }

    private KeyEvent createKeyEvent(KeyStroke stroke, Component component) {
        return new KeyEvent(component, stroke.getKeyChar() == '\uffff' ? 401 : 400, System.currentTimeMillis(), stroke.getModifiers(), stroke.getKeyCode(), stroke.getKeyChar());
    }
}

