/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.common.Jump;
import com.maddyhome.idea.vim.common.Mark;
import com.maddyhome.idea.vim.group.AbstractActionGroup;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorData;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.SearchHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkGroup
extends AbstractActionGroup {
    private HashMap<String, FileMarks<Character, Mark>> fileMarks = new HashMap();
    private HashMap<Character, Mark> globalMarks = new HashMap();
    private List<Jump> jumps = new ArrayList<Jump>();
    private int jumpSpot = -1;
    private static int SAVE_MARK_COUNT = 20;
    private static int SAVE_JUMP_COUNT = 100;
    private static final String WR_GLOBAL_MARKS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String WR_FILE_MARKS = "abcdefghijklmnopqrstuvwxyz'";
    private static final String RO_GLOBAL_MARKS = "0123456789";
    private static final String RO_FILE_MARKS = "[]<>^{}()";
    private static final String SAVE_FILE_MARKS = "abcdefghijklmnopqrstuvwxyz'.^[]\"";
    private static final String GLOBAL_MARKS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final String FILE_MARKS = "abcdefghijklmnopqrstuvwxyz'[]<>^{}()";
    private static final String WRITE_MARKS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'";
    private static final String READONLY_MARKS = "0123456789[]<>^{}()";
    private static final String VALID_SET_MARKS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'";
    private static final String VALID_GET_MARKS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'0123456789[]<>^{}()";
    private static Logger logger = Logger.getInstance((String)MarkGroup.class.getName());

    public MarkGroup() {
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new EditorFactoryAdapter(){

            public void editorReleased(EditorFactoryEvent event) {
                Editor editor = event.getEditor();
                MarkGroup.this.setMark(editor, null, '\"', editor.getCaretModel().getOffset());
            }
        });
    }

    public void saveJumpLocation(Editor editor, DataPackage context) {
        this.addJump(editor, context, true);
        this.setMark(editor, context, '\'');
    }

    public Mark getMark(Editor editor, char ch) {
        Mark mark = null;
        if (ch == '`') {
            ch = (char)39;
        }
        if (VALID_GET_MARKS.indexOf(ch) < 0) {
            return null;
        }
        VirtualFile vf = EditorData.getVirtualFile(editor);
        if ("{}".indexOf(ch) >= 0 && vf != null) {
            int offset = SearchHelper.findNextParagraph(editor, ch == '{' ? -1 : 1, false);
            offset = EditorHelper.normalizeOffset(editor, offset, false);
            LogicalPosition lp = editor.offsetToLogicalPosition(offset);
            mark = new Mark(ch, lp.line, lp.column, vf.getPath());
        } else if ("()".indexOf(ch) >= 0 && vf != null) {
            int offset = SearchHelper.findNextSentenceStart(editor, ch == '(' ? -1 : 1, false, true);
            offset = EditorHelper.normalizeOffset(editor, offset, false);
            LogicalPosition lp = editor.offsetToLogicalPosition(offset);
            mark = new Mark(ch, lp.line, lp.column, vf.getPath());
        } else if (FILE_MARKS.indexOf(ch) >= 0) {
            FileMarks<Character, Mark> fmarks = this.getFileMarks(editor.getDocument());
            mark = (Mark)fmarks.get(new Character(ch));
            if (mark != null && mark.isClear()) {
                fmarks.remove(new Character(ch));
                mark = null;
            }
        } else if (GLOBAL_MARKS.indexOf(ch) >= 0 && (mark = this.globalMarks.get(new Character(ch))) != null && mark.isClear()) {
            this.globalMarks.remove(new Character(ch));
            mark = null;
        }
        return mark;
    }

    public Jump getJump(int count) {
        int index = this.jumps.size() - 1 - (this.jumpSpot - count);
        if (index < 0 || index >= this.jumps.size()) {
            return null;
        }
        this.jumpSpot -= count;
        return this.jumps.get(index);
    }

    public Mark getFileMark(Editor editor, char ch) {
        FileMarks<Character, Mark> fmarks;
        Mark mark;
        if (ch == '`') {
            ch = (char)39;
        }
        if ((mark = (Mark)(fmarks = this.getFileMarks(editor.getDocument())).get(new Character(ch))) != null && mark.isClear()) {
            fmarks.remove(new Character(ch));
            mark = null;
        }
        return mark;
    }

    public boolean setMark(Editor editor, DataPackage context, char ch) {
        if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'".indexOf(ch) >= 0) {
            return this.setMark(editor, context, ch, editor.getCaretModel().getOffset());
        }
        return false;
    }

    public boolean setMark(Editor editor, DataPackage context, char ch, int offset) {
        if (ch == '`') {
            ch = (char)39;
        }
        LogicalPosition lp = editor.offsetToLogicalPosition(offset);
        VirtualFile vf = null;
        if (context != null) {
            vf = context.getVirtualFile();
        }
        if (vf == null) {
            vf = EditorData.getVirtualFile(editor);
        }
        if (vf == null) {
            return false;
        }
        Mark mark = new Mark(ch, lp.line, lp.column, vf.getPath());
        if (FILE_MARKS.indexOf(ch) >= 0) {
            FileMarks<Character, Mark> fmarks = this.getFileMarks(editor.getDocument());
            ((HashMap)fmarks).put(Character.valueOf(ch), mark);
        } else if (GLOBAL_MARKS.indexOf(ch) >= 0) {
            FileMarks<Character, Mark> fmarks = this.getFileMarks(editor.getDocument());
            ((HashMap)fmarks).put(Character.valueOf(ch), mark);
            Mark oldMark = this.globalMarks.put(Character.valueOf(ch), mark);
            if (oldMark != null) {
                oldMark.clear();
            }
        }
        return true;
    }

    public void addJump(Editor editor, DataPackage context, boolean reset) {
        this.addJump(editor, context, editor.getCaretModel().getOffset(), reset);
    }

    private void addJump(Editor editor, DataPackage context, int offset, boolean reset) {
        VirtualFile vf = null;
        if (context != null) {
            vf = context.getVirtualFile();
        }
        if (vf == null) {
            vf = EditorData.getVirtualFile(editor);
        }
        if (vf == null) {
            return;
        }
        LogicalPosition lp = editor.offsetToLogicalPosition(offset);
        Jump jump = new Jump(lp.line, lp.column, vf.getPath());
        for (int i = 0; i < this.jumps.size(); ++i) {
            Jump j = this.jumps.get(i);
            if (!j.getFilename().equals(jump.getFilename()) || j.getLogicalLine() != jump.getLogicalLine()) continue;
            this.jumps.remove(i);
            break;
        }
        this.jumps.add(jump);
        this.jumpSpot = reset ? -1 : ++this.jumpSpot;
        if (this.jumps.size() > SAVE_JUMP_COUNT) {
            this.jumps.remove(0);
        }
    }

    private void removeMark(char ch, Mark mark) {
        if (FILE_MARKS.indexOf(ch) >= 0) {
            FileMarks<Character, Mark> fmarks = this.getFileMarks(mark.getFilename());
            fmarks.remove(new Character(ch));
        } else if (GLOBAL_MARKS.indexOf(ch) >= 0) {
            this.globalMarks.remove(new Character(ch));
        }
        mark.clear();
    }

    public List<Mark> getMarks(Editor editor) {
        HashSet<Object> res = new HashSet<Object>();
        res.addAll(this.getFileMarks(editor.getDocument()).values());
        res.addAll(this.globalMarks.values());
        ArrayList<Mark> list = new ArrayList<Mark>(res);
        Collections.sort(list, new Mark.KeySorter());
        return list;
    }

    public List<Jump> getJumps() {
        return this.jumps;
    }

    public int getJumpSpot() {
        return this.jumpSpot;
    }

    private FileMarks<Character, Mark> getFileMarks(Document doc) {
        VirtualFile vf = FileDocumentManager.getInstance().getFile(doc);
        if (vf == null) {
            return null;
        }
        return this.getFileMarks(vf.getPath());
    }

    private HashMap<Character, Mark> getAllFileMarks(Document doc) {
        VirtualFile vf = FileDocumentManager.getInstance().getFile(doc);
        if (vf == null) {
            return null;
        }
        HashMap<Character, Mark> res = new HashMap<Character, Mark>();
        FileMarks<Character, Mark> fileMarks = this.getFileMarks(doc);
        if (fileMarks != null) {
            res.putAll(fileMarks);
        }
        for (Character ch : this.globalMarks.keySet()) {
            Mark mark = this.globalMarks.get(ch);
            if (!mark.getFilename().equals(vf.getPath())) continue;
            res.put(ch, mark);
        }
        return res;
    }

    private FileMarks<Character, Mark> getFileMarks(String filename) {
        FileMarks<Character, Mark> marks = this.fileMarks.get(filename);
        if (marks == null) {
            marks = new FileMarks();
            this.fileMarks.put(filename, marks);
        }
        return marks;
    }

    @Override
    public void saveData(Element element) {
        Element marksElem = new Element("globalmarks");
        for (Mark mark : this.globalMarks.values()) {
            if (mark.isClear()) continue;
            Element markElem = new Element("mark");
            markElem.setAttribute("key", Character.toString(mark.getKey()));
            markElem.setAttribute("line", Integer.toString(mark.getLogicalLine()));
            markElem.setAttribute("column", Integer.toString(mark.getCol()));
            markElem.setAttribute("filename", mark.getFilename());
            marksElem.addContent(markElem);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("saved mark = " + mark);
        }
        element.addContent(marksElem);
        Element fileMarksElem = new Element("filemarks");
        List<FileMarks<Character, Mark>> files = new ArrayList<FileMarks<Character, Mark>>(this.fileMarks.values());
        Collections.sort(files, new Comparator<FileMarks<Character, Mark>>(){

            @Override
            public int compare(FileMarks<Character, Mark> o1, FileMarks<Character, Mark> o2) {
                return ((FileMarks)o1).timestamp.compareTo(((FileMarks)o2).timestamp);
            }
        });
        if (files.size() > SAVE_MARK_COUNT) {
            files = files.subList(files.size() - SAVE_MARK_COUNT, files.size());
        }
        for (String file : this.fileMarks.keySet()) {
            FileMarks<Character, Mark> marks = this.fileMarks.get(file);
            if (!files.contains(marks) || marks.size() <= 0) continue;
            Element fileMarkElem = new Element("file");
            fileMarkElem.setAttribute("name", file);
            fileMarkElem.setAttribute("timestamp", Long.toString(((FileMarks)marks).timestamp.getTime()));
            for (Mark mark : marks.values()) {
                if (mark.isClear() || Character.isUpperCase(mark.getKey()) || SAVE_FILE_MARKS.indexOf(mark.getKey()) < 0) continue;
                Element markElem = new Element("mark");
                markElem.setAttribute("key", Character.toString(mark.getKey()));
                markElem.setAttribute("line", Integer.toString(mark.getLogicalLine()));
                markElem.setAttribute("column", Integer.toString(mark.getCol()));
                fileMarkElem.addContent(markElem);
            }
            fileMarksElem.addContent(fileMarkElem);
        }
        element.addContent(fileMarksElem);
        Element jumpsElem = new Element("jumps");
        for (Jump jump : this.jumps) {
            if (jump.isClear()) continue;
            Element jumpElem = new Element("jump");
            jumpElem.setAttribute("line", Integer.toString(jump.getLogicalLine()));
            jumpElem.setAttribute("column", Integer.toString(jump.getCol()));
            jumpElem.setAttribute("filename", jump.getFilename());
            jumpsElem.addContent(jumpElem);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("saved jump = " + jump);
        }
        element.addContent(jumpsElem);
    }

    @Override
    public void readData(Element element) {
        Element fileMarksElem;
        Element marksElem = element.getChild("globalmarks");
        if (marksElem != null) {
            List markList = marksElem.getChildren("mark");
            for (Object aMarkList : markList) {
                Element markElem = (Element)aMarkList;
                Mark mark = new Mark(markElem.getAttributeValue("key").charAt(0), Integer.parseInt(markElem.getAttributeValue("line")), Integer.parseInt(markElem.getAttributeValue("column")), markElem.getAttributeValue("filename"));
                this.globalMarks.put(Character.valueOf(mark.getKey()), mark);
                FileMarks<Character, Mark> fmarks = this.getFileMarks(mark.getFilename());
                ((HashMap)fmarks).put(Character.valueOf(mark.getKey()), mark);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("globalMarks=" + this.globalMarks);
        }
        if ((fileMarksElem = element.getChild("filemarks")) != null) {
            List fileList = fileMarksElem.getChildren("file");
            for (Object aFileList : fileList) {
                Element fileElem = (Element)aFileList;
                String filename = fileElem.getAttributeValue("name");
                Date timestamp = new Date();
                try {
                    long date = Long.parseLong(fileElem.getAttributeValue("timestamp"));
                    timestamp.setTime(date);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                FileMarks<Character, Mark> fmarks = this.getFileMarks(filename);
                List markList = fileElem.getChildren("mark");
                for (Object aMarkList : markList) {
                    Element markElem = (Element)aMarkList;
                    Mark mark = new Mark(markElem.getAttributeValue("key").charAt(0), Integer.parseInt(markElem.getAttributeValue("line")), Integer.parseInt(markElem.getAttributeValue("column")), filename);
                    fmarks.put(Character.valueOf(mark.getKey()), mark);
                }
                fmarks.setTimestamp(timestamp);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("fileMarks=" + this.fileMarks);
        }
        this.jumps.clear();
        Element jumpsElem = element.getChild("jumps");
        if (jumpsElem != null) {
            List jumpList = jumpsElem.getChildren("jump");
            for (Object aJumpList : jumpList) {
                Element jumpElem = (Element)aJumpList;
                Jump jump = new Jump(Integer.parseInt(jumpElem.getAttributeValue("line")), Integer.parseInt(jumpElem.getAttributeValue("column")), jumpElem.getAttributeValue("filename"));
                this.jumps.add(jump);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("jumps=" + this.jumps);
        }
    }

    public static void updateMarkFromDelete(Editor editor, HashMap<Character, Mark> marks, int delStartOff, int delLength) {
        if (marks != null && marks.size() > 0 && editor != null) {
            int delEndOff = delStartOff + delLength;
            LogicalPosition delStart = editor.offsetToLogicalPosition(delStartOff);
            LogicalPosition delEnd = editor.offsetToLogicalPosition(delEndOff);
            if (logger.isDebugEnabled()) {
                logger.debug("mark delete. delStart = " + delStart + ", delEnd = " + delEnd);
            }
            for (Character ch : marks.keySet()) {
                Mark mark = marks.get(ch);
                if (logger.isDebugEnabled()) {
                    logger.debug("mark = " + mark);
                }
                if (delEnd.line < mark.getLogicalLine()) {
                    int lines = delEnd.line - delStart.line;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Shifting mark by " + lines + " lines");
                    }
                    mark.setLogicalLine(mark.getLogicalLine() - lines);
                    continue;
                }
                if (delStart.line > mark.getLogicalLine() || delEnd.line < mark.getLogicalLine()) continue;
                int markLineStartOff = EditorHelper.getLineStartOffset(editor, mark.getLogicalLine());
                int markLineEndOff = EditorHelper.getLineEndOffset(editor, mark.getLogicalLine(), true);
                if (delStartOff <= markLineStartOff && delEndOff >= markLineEndOff) {
                    CommandGroups.getInstance().getMark().removeMark(ch.charValue(), mark);
                    logger.debug("Removed mark");
                    continue;
                }
                if (delStart.line >= mark.getLogicalLine()) continue;
                mark.setLogicalLine(delStart.line);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Shifting mark to line " + delStart.line);
            }
        }
    }

    public static void updateMarkFromInsert(Editor editor, HashMap<Character, Mark> marks, int insStartOff, int insLength) {
        if (marks != null && marks.size() > 0 && editor != null) {
            int lines;
            int insEndOff = insStartOff + insLength;
            LogicalPosition insStart = editor.offsetToLogicalPosition(insStartOff);
            LogicalPosition insEnd = editor.offsetToLogicalPosition(insEndOff);
            if (logger.isDebugEnabled()) {
                logger.debug("mark insert. insStart = " + insStart + ", insEnd = " + insEnd);
            }
            if ((lines = insEnd.line - insStart.line) == 0) {
                return;
            }
            for (Mark mark : marks.values()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("mark = " + mark);
                }
                if (insStart.line >= mark.getLogicalLine()) continue;
                mark.setLogicalLine(mark.getLogicalLine() + lines);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Shifting mark by " + lines + " lines");
            }
        }
    }

    public static class MarkUpdater
    extends DocumentAdapter {
        public void beforeDocumentChange(DocumentEvent event) {
            if (!VimPlugin.isEnabled()) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("MarkUpdater before, event = " + event);
            }
            if (event.getOldLength() == 0) {
                return;
            }
            Document doc = event.getDocument();
            MarkGroup.updateMarkFromDelete(this.getAnEditor(doc), CommandGroups.getInstance().getMark().getAllFileMarks(doc), event.getOffset(), event.getOldLength());
        }

        public void documentChanged(DocumentEvent event) {
            if (!VimPlugin.isEnabled()) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("MarkUpdater after, event = " + event);
            }
            if (event.getNewLength() == 0 || event.getNewLength() == 1 && !event.getNewFragment().equals("\n")) {
                return;
            }
            Document doc = event.getDocument();
            MarkGroup.updateMarkFromInsert(this.getAnEditor(doc), CommandGroups.getInstance().getMark().getAllFileMarks(doc), event.getOffset(), event.getNewLength());
        }

        private Editor getAnEditor(Document doc) {
            Editor[] editors = EditorFactory.getInstance().getEditors(doc);
            if (editors.length > 0) {
                return editors[0];
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileMarks<K, V>
    extends HashMap<K, V> {
        private Date timestamp = new Date();

        private FileMarks() {
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public V put(K key, V value) {
            this.timestamp = new Date();
            return super.put(key, value);
        }
    }
}

