/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.action.motion.MotionEditorAction;
import com.maddyhome.idea.vim.action.motion.TextObjectAction;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandState;
import com.maddyhome.idea.vim.command.VisualChange;
import com.maddyhome.idea.vim.command.VisualRange;
import com.maddyhome.idea.vim.common.Jump;
import com.maddyhome.idea.vim.common.Mark;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.group.AbstractActionGroup;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.ApiHelper;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorData;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.SearchHelper;
import com.maddyhome.idea.vim.option.BoundStringOption;
import com.maddyhome.idea.vim.option.NumberOption;
import com.maddyhome.idea.vim.option.Options;
import com.maddyhome.idea.vim.ui.ExEntryPanel;
import com.maddyhome.idea.vim.ui.MorePanel;
import java.awt.event.MouseEvent;
import java.io.File;

public class MotionGroup
extends AbstractActionGroup {
    public static final int LAST_F = 1;
    public static final int LAST_f = 2;
    public static final int LAST_T = 3;
    public static final int LAST_t = 4;
    public static final int LAST_COLUMN = 9999;
    private int lastFTCmd = 0;
    private char lastFTChar;
    private int visualStart;
    private int visualEnd;
    private int visualOffset;
    private EditorMouseHandler mouseHandler = new EditorMouseHandler();
    private EditorSelectionHandler selectionHandler = new EditorSelectionHandler();
    private EditorScrollHandler scrollHandler = new EditorScrollHandler();
    private static Logger logger = Logger.getInstance((String)MotionGroup.class.getName());

    public MotionGroup() {
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new EditorFactoryAdapter(){

            public void editorCreated(EditorFactoryEvent event) {
                final Editor editor = event.getEditor();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    public void run() {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            public void run() {
                                ApplicationManager.getApplication().invokeLater(new Runnable(){

                                    public void run() {
                                        editor.addEditorMouseListener((EditorMouseListener)MotionGroup.this.mouseHandler);
                                        editor.addEditorMouseMotionListener((EditorMouseMotionListener)MotionGroup.this.mouseHandler);
                                        editor.getSelectionModel().addSelectionListener((SelectionListener)MotionGroup.this.selectionHandler);
                                        editor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)MotionGroup.this.scrollHandler);
                                        EditorData.setMotionGroup(editor, true);
                                    }
                                });
                            }
                        });
                    }
                });
            }

            public void editorReleased(EditorFactoryEvent event) {
                Editor editor = event.getEditor();
                if (EditorData.getMotionGroup(editor)) {
                    editor.removeEditorMouseListener((EditorMouseListener)MotionGroup.this.mouseHandler);
                    editor.removeEditorMouseMotionListener((EditorMouseMotionListener)MotionGroup.this.mouseHandler);
                    editor.getSelectionModel().removeSelectionListener((SelectionListener)MotionGroup.this.selectionHandler);
                    editor.getScrollingModel().removeVisibleAreaListener((VisibleAreaListener)MotionGroup.this.scrollHandler);
                    EditorData.setMotionGroup(editor, false);
                }
            }
        });
    }

    private void processMouseClick(Editor editor, MouseEvent event) {
        if (ExEntryPanel.getInstance().isActive()) {
            ExEntryPanel.getInstance().deactivate(false);
        }
        if (MorePanel.getInstance().isActive()) {
            MorePanel.getInstance().deactivate(false);
        }
        int visualMode = 0;
        switch (event.getClickCount() % 3) {
            case 1: {
                visualMode = 0;
                break;
            }
            case 2: {
                visualMode = 4;
                break;
            }
            case 0: {
                visualMode = 2;
                if (CommandState.getInstance(editor).getMode() == 5) {
                    CommandState.getInstance(editor).popState();
                }
                int start = editor.getSelectionModel().getSelectionStart();
                int end = editor.getSelectionModel().getSelectionEnd();
                editor.getSelectionModel().setSelection(start, end - 1);
            }
        }
        this.setVisualMode(editor, null, visualMode);
        switch (CommandState.getInstance(editor).getSubMode()) {
            case 0: {
                VisualPosition vp = editor.getCaretModel().getVisualPosition();
                int col = EditorHelper.normalizeVisualColumn(editor, vp.line, vp.column, CommandState.getInstance(editor).getMode() == 2 || CommandState.getInstance(editor).getMode() == 3);
                if (col != vp.column) {
                    editor.getCaretModel().moveToVisualPosition(new VisualPosition(vp.line, col));
                }
                MotionGroup.scrollCaretIntoView(editor);
                break;
            }
            case 4: {
                editor.getCaretModel().moveToOffset(this.visualEnd);
                break;
            }
            case 2: {
                editor.getCaretModel().moveToLogicalPosition(editor.xyToLogicalPosition(event.getPoint()));
            }
        }
        this.visualOffset = editor.getCaretModel().getOffset();
        EditorData.setLastColumn(editor, EditorHelper.getCurrentVisualColumn(editor));
        if (logger.isDebugEnabled()) {
            logger.debug("Mouse click: vp=" + editor.getCaretModel().getVisualPosition() + "lp=" + editor.getCaretModel().getLogicalPosition() + "offset=" + editor.getCaretModel().getOffset());
        }
    }

    private void processLineSelection(Editor editor, boolean update) {
        if (ExEntryPanel.getInstance().isActive()) {
            ExEntryPanel.getInstance().deactivate(false);
        }
        if (MorePanel.getInstance().isActive()) {
            MorePanel.getInstance().deactivate(false);
        }
        if (update) {
            if (CommandState.getInstance(editor).getMode() == 5) {
                this.updateSelection(editor, null, editor.getCaretModel().getOffset());
            }
        } else {
            if (CommandState.getInstance(editor).getMode() == 5) {
                CommandState.getInstance(editor).popState();
            }
            int start = editor.getSelectionModel().getSelectionStart();
            int end = editor.getSelectionModel().getSelectionEnd();
            if (logger.isDebugEnabled()) {
                logger.debug("start=" + start);
                logger.debug("end=" + end);
            }
            editor.getSelectionModel().setSelection(start, end - 1);
            this.setVisualMode(editor, null, 2);
            VisualChange range = this.getVisualOperatorRange(editor, 2);
            if (logger.isDebugEnabled()) {
                logger.debug("range=" + range);
            }
            if (range.getLines() > 1) {
                MotionGroup.moveCaret(editor, null, this.moveCaretVertical(editor, -1));
            }
        }
    }

    private void processMouseReleased(Editor editor, int mode, int startOff, int endOff) {
        if (ExEntryPanel.getInstance().isActive()) {
            ExEntryPanel.getInstance().deactivate(false);
        }
        if (MorePanel.getInstance().isActive()) {
            MorePanel.getInstance().deactivate(false);
        }
        logger.debug("mouse released");
        if (CommandState.getInstance(editor).getMode() == 5) {
            CommandState.getInstance(editor).popState();
        }
        int start = editor.getSelectionModel().getSelectionStart();
        int end = editor.getSelectionModel().getSelectionEnd();
        if (logger.isDebugEnabled()) {
            logger.debug("startOff=" + startOff);
            logger.debug("endOff=" + endOff);
            logger.debug("start=" + start);
            logger.debug("end=" + end);
        }
        if (mode == 2) {
            --end;
            --endOff;
        }
        if (end == startOff || end == endOff) {
            int t = start;
            start = end;
            end = t;
            if (mode == 4) {
                --start;
            }
        }
        MotionGroup.moveCaret(editor, null, start);
        this.toggleVisual(editor, null, 1, 0, mode);
        MotionGroup.moveCaret(editor, null, end);
        KeyHandler.getInstance().reset(editor);
    }

    public static int moveCaretToMotion(Editor editor, DataPackage context, int count, int rawCount, Argument argument) {
        Command cmd = argument.getMotion();
        int cnt = cmd.getCount() * count;
        int raw = rawCount == 0 && cmd.getRawCount() == 0 ? 0 : cnt;
        MotionEditorAction action = (MotionEditorAction)cmd.getAction();
        int offset = action.getOffset(editor, context, cnt, raw, cmd.getArgument());
        MotionGroup.moveCaret(editor, context, offset);
        return offset;
    }

    public TextRange getWordRange(Editor editor, DataPackage context, int count, boolean isOuter, boolean isBig) {
        int dir = 1;
        boolean selection = false;
        if (CommandState.getInstance(editor).getMode() == 5) {
            if (this.visualEnd < this.visualStart) {
                dir = -1;
            }
            if (this.visualStart != this.visualEnd) {
                selection = true;
            }
        }
        return SearchHelper.findWordUnderCursor(editor, count, dir, isOuter, isBig, selection);
    }

    public TextRange getBlockRange(Editor editor, DataPackage context, int count, boolean isOuter, char type) {
        return SearchHelper.findBlockRange(editor, type, count, isOuter);
    }

    public TextRange getSentenceRange(Editor editor, DataPackage context, int count, boolean isOuter) {
        return SearchHelper.findSentenceRange(editor, count, isOuter);
    }

    public TextRange getParagraphRange(Editor editor, DataPackage context, int count, boolean isOuter) {
        return SearchHelper.findParagraphRange(editor, count, isOuter);
    }

    public static TextRange getMotionRange(Editor editor, DataPackage context, int count, int rawCount, Argument argument, boolean incNewline, boolean moveCursor) {
        EditorAction action;
        Command cmd = argument.getMotion();
        int cnt = cmd.getCount() * count;
        int raw = rawCount == 0 && cmd.getRawCount() == 0 ? 0 : cnt;
        int start = 0;
        int end = 0;
        if (cmd.getAction() instanceof MotionEditorAction) {
            action = (MotionEditorAction)cmd.getAction();
            start = editor.getCaretModel().getOffset();
            end = action.getOffset(editor, context, cnt, raw, cmd.getArgument());
            if (end == -1) {
                return null;
            }
            if (moveCursor) {
                MotionGroup.moveCaret(editor, context, end);
            }
        } else if (cmd.getAction() instanceof TextObjectAction) {
            action = (TextObjectAction)cmd.getAction();
            TextRange range = action.getRange(editor, context, cnt, raw, cmd.getArgument());
            if (range == null) {
                return null;
            }
            start = range.getStartOffset();
            end = range.getEndOffset();
            if (moveCursor) {
                MotionGroup.moveCaret(editor, context, start);
            }
        }
        int flags = cmd.getFlags();
        if ((flags & 2) != 0) {
            if (start > end) {
                int t = start;
                start = end;
                end = t;
            }
            start = EditorHelper.getLineStartForOffset(editor, start);
            end = Math.min(EditorHelper.getLineEndForOffset(editor, end) + (incNewline ? 1 : 0), EditorHelper.getFileSize(editor));
        } else if ((flags & 0x10) != 0) {
            end += start <= end ? 1 : -1;
        }
        if (start > end) {
            int t = start;
            start = end;
            end = t;
        }
        return new TextRange(start, end);
    }

    public int moveCaretToNthCharacter(Editor editor, int count) {
        return Math.max(0, Math.min(count, EditorHelper.getFileSize(editor) - 1));
    }

    public int moveCaretToMarkLine(Editor editor, DataPackage context, char ch) {
        Mark mark = CommandGroups.getInstance().getMark().getMark(editor, ch);
        if (mark != null) {
            VirtualFile vf = EditorData.getVirtualFile(editor);
            if (vf == null) {
                return -1;
            }
            int line = mark.getLogicalLine();
            if (!mark.getFilename().equals(vf.getPath())) {
                if ((editor = this.selectEditor(editor, EditorData.getVirtualFile(editor))) != null) {
                    MotionGroup.moveCaret(editor, context, this.moveCaretToLineStartSkipLeading(editor, line));
                }
                return -2;
            }
            return this.moveCaretToLineStartSkipLeading(editor, line);
        }
        return -1;
    }

    public int moveCaretToFileMarkLine(Editor editor, DataPackage context, char ch) {
        Mark mark = CommandGroups.getInstance().getMark().getFileMark(editor, ch);
        if (mark != null) {
            int line = mark.getLogicalLine();
            return this.moveCaretToLineStartSkipLeading(editor, line);
        }
        return -1;
    }

    public int moveCaretToMark(Editor editor, DataPackage context, char ch) {
        Mark mark = CommandGroups.getInstance().getMark().getMark(editor, ch);
        if (mark != null) {
            VirtualFile vf = EditorData.getVirtualFile(editor);
            if (vf == null) {
                return -1;
            }
            LogicalPosition lp = new LogicalPosition(mark.getLogicalLine(), mark.getCol());
            if (!vf.getPath().equals(mark.getFilename())) {
                if ((editor = this.selectEditor(editor, EditorData.getVirtualFile(editor))) != null) {
                    MotionGroup.moveCaret(editor, context, editor.logicalPositionToOffset(lp));
                }
                return -2;
            }
            return editor.logicalPositionToOffset(lp);
        }
        return -1;
    }

    public int moveCaretToJump(Editor editor, DataPackage context, int count) {
        int spot = CommandGroups.getInstance().getMark().getJumpSpot();
        Jump jump = CommandGroups.getInstance().getMark().getJump(count);
        if (jump != null) {
            VirtualFile vf = EditorData.getVirtualFile(editor);
            if (vf == null) {
                return -1;
            }
            LogicalPosition lp = new LogicalPosition(jump.getLogicalLine(), jump.getCol());
            if (!vf.getPath().equals(jump.getFilename())) {
                VirtualFile newFile = LocalFileSystem.getInstance().findFileByPath(jump.getFilename().replace(File.separatorChar, '/'));
                if (newFile == null) {
                    return -2;
                }
                Editor newEditor = this.selectEditor(editor, newFile);
                if (newEditor != null) {
                    if (spot == -1) {
                        CommandGroups.getInstance().getMark().addJump(editor, context, false);
                    }
                    MotionGroup.moveCaret(newEditor, context, EditorHelper.normalizeOffset(newEditor, newEditor.logicalPositionToOffset(lp), false));
                }
                return -2;
            }
            if (spot == -1) {
                CommandGroups.getInstance().getMark().addJump(editor, context, false);
            }
            return editor.logicalPositionToOffset(lp);
        }
        return -1;
    }

    public int moveCaretToFileMark(Editor editor, DataPackage context, char ch) {
        Mark mark = CommandGroups.getInstance().getMark().getFileMark(editor, ch);
        if (mark != null) {
            LogicalPosition lp = new LogicalPosition(mark.getLogicalLine(), mark.getCol());
            return editor.logicalPositionToOffset(lp);
        }
        return -1;
    }

    private Editor selectEditor(Editor editor, VirtualFile file) {
        Project proj = EditorData.getProject(editor);
        return CommandGroups.getInstance().getFile().selectEditor(proj, file);
    }

    public int moveCaretToMatchingPair(Editor editor, DataPackage context) {
        int pos = SearchHelper.findMatchingPairOnCurrentLine(editor);
        if (pos >= 0) {
            return pos;
        }
        return -1;
    }

    public int moveCaretToNextCamel(Editor editor, int count) {
        if (editor.getCaretModel().getOffset() == 0 && count < 0 || editor.getCaretModel().getOffset() >= EditorHelper.getFileSize(editor) - 1 && count > 0) {
            return -1;
        }
        return SearchHelper.findNextCamelStart(editor, count);
    }

    public int moveCaretToNextCamelEnd(Editor editor, int count) {
        if (editor.getCaretModel().getOffset() == 0 && count < 0 || editor.getCaretModel().getOffset() >= EditorHelper.getFileSize(editor) - 1 && count > 0) {
            return -1;
        }
        return SearchHelper.findNextCamelEnd(editor, count);
    }

    public int moveCaretToNextWord(Editor editor, int count, boolean skipPunc) {
        if (editor.getCaretModel().getOffset() == 0 && count < 0 || editor.getCaretModel().getOffset() >= EditorHelper.getFileSize(editor) - 1 && count > 0) {
            return -1;
        }
        return SearchHelper.findNextWord(editor, count, skipPunc);
    }

    public int moveCaretToNextWordEnd(Editor editor, int count, boolean skipPunc) {
        if (editor.getCaretModel().getOffset() == 0 && count < 0 || editor.getCaretModel().getOffset() >= EditorHelper.getFileSize(editor) - 1 && count > 0) {
            return -1;
        }
        boolean stay = CommandState.getInstance(editor).getCommand().getType() == 4;
        int pos = SearchHelper.findNextWordEnd(editor, count, skipPunc, stay);
        if (pos == -1) {
            if (count < 0) {
                return this.moveCaretToLineStart(editor, 0);
            }
            return this.moveCaretToLineEnd(editor, EditorHelper.getLineCount(editor) - 1, false);
        }
        return pos;
    }

    public int moveCaretToNextParagraph(Editor editor, int count) {
        int res = SearchHelper.findNextParagraph(editor, count, false);
        res = res >= 0 ? EditorHelper.normalizeOffset(editor, res, false) : -1;
        return res;
    }

    public int moveCaretToNextSentenceStart(Editor editor, int count) {
        int res = SearchHelper.findNextSentenceStart(editor, count, false, true);
        res = res >= 0 ? EditorHelper.normalizeOffset(editor, res, false) : -1;
        return res;
    }

    public int moveCaretToNextSentenceEnd(Editor editor, int count) {
        int res = SearchHelper.findNextSentenceEnd(editor, count, false, true);
        res = res >= 0 ? EditorHelper.normalizeOffset(editor, res, false) : -1;
        return res;
    }

    public int moveCaretToUnmatchedBlock(Editor editor, int count, char type) {
        if (editor.getCaretModel().getOffset() == 0 && count < 0 || editor.getCaretModel().getOffset() >= EditorHelper.getFileSize(editor) - 1 && count > 0) {
            return -1;
        }
        int res = SearchHelper.findUnmatchedBlock(editor, type, count);
        if (res != -1) {
            res = EditorHelper.normalizeOffset(editor, res, false);
        }
        return res;
    }

    public int moveCaretToSection(Editor editor, char type, int dir, int count) {
        if (editor.getCaretModel().getOffset() == 0 && count < 0 || editor.getCaretModel().getOffset() >= EditorHelper.getFileSize(editor) - 1 && count > 0) {
            return -1;
        }
        int res = SearchHelper.findSection(editor, type, dir, count);
        if (res != -1) {
            res = EditorHelper.normalizeOffset(editor, res, false);
        }
        return res;
    }

    public int moveCaretToMethodStart(Editor editor, int count) {
        return SearchHelper.findMethodStart(editor, count);
    }

    public int moveCaretToMethodEnd(Editor editor, int count) {
        return SearchHelper.findMethodEnd(editor, count);
    }

    public void setLastFTCmd(int lastFTCmd, char lastChar) {
        this.lastFTCmd = lastFTCmd;
        this.lastFTChar = lastChar;
    }

    public int repeatLastMatchChar(Editor editor, int count) {
        int res = -1;
        switch (this.lastFTCmd) {
            case 1: {
                res = this.moveCaretToNextCharacterOnLine(editor, -count, this.lastFTChar);
                break;
            }
            case 2: {
                res = this.moveCaretToNextCharacterOnLine(editor, count, this.lastFTChar);
                break;
            }
            case 3: {
                res = this.moveCaretToBeforeNextCharacterOnLine(editor, -count, this.lastFTChar);
                break;
            }
            case 4: {
                res = this.moveCaretToBeforeNextCharacterOnLine(editor, count, this.lastFTChar);
            }
        }
        return res;
    }

    public int moveCaretToNextCharacterOnLine(Editor editor, int count, char ch) {
        int pos = SearchHelper.findNextCharacterOnLine(editor, count, ch);
        if (pos >= 0) {
            return pos;
        }
        return -1;
    }

    public int moveCaretToBeforeNextCharacterOnLine(Editor editor, int count, char ch) {
        int pos = SearchHelper.findNextCharacterOnLine(editor, count, ch);
        if (pos >= 0) {
            int step = count >= 0 ? 1 : -1;
            return pos - step;
        }
        return -1;
    }

    public boolean scrollLineToFirstScreenLine(Editor editor, DataPackage context, int rawCount, int count, boolean start) {
        this.scrollLineToScreenLine(editor, context, 1, rawCount, count, start);
        return true;
    }

    public boolean scrollLineToMiddleScreenLine(Editor editor, DataPackage context, int rawCount, int count, boolean start) {
        this.scrollLineToScreenLine(editor, context, EditorHelper.getScreenHeight(editor) / 2 + 1, rawCount, count, start);
        return true;
    }

    public boolean scrollLineToLastScreenLine(Editor editor, DataPackage context, int rawCount, int count, boolean start) {
        this.scrollLineToScreenLine(editor, context, EditorHelper.getScreenHeight(editor), rawCount, count, start);
        return true;
    }

    public boolean scrollColumnToFirstScreenColumn(Editor editor, DataPackage context) {
        this.scrollColumnToScreenColumn(editor, 0);
        return true;
    }

    public boolean scrollColumnToLastScreenColumn(Editor editor, DataPackage context) {
        this.scrollColumnToScreenColumn(editor, EditorHelper.getScreenWidth(editor));
        return true;
    }

    private void scrollColumnToScreenColumn(Editor editor, int scol) {
        int width;
        int scrolloff = ((NumberOption)Options.getInstance().getOption("sidescrolloff")).value();
        if (scrolloff > (width = EditorHelper.getScreenWidth(editor)) / 2) {
            scrolloff = width / 2;
        }
        if (scol <= width / 2) {
            if (scol < scrolloff + 1) {
                scol = scrolloff + 1;
            }
        } else if (scol > width - scrolloff) {
            scol = width - scrolloff;
        }
        int vcol = EditorHelper.getCurrentVisualColumn(editor);
        MotionGroup.scrollColumnToLeftOfScreen(editor, EditorHelper.normalizeVisualColumn(editor, EditorHelper.getCurrentVisualLine(editor), vcol - scol + 1, false));
    }

    private void scrollLineToScreenLine(Editor editor, DataPackage context, int sline, int rawCount, int count, boolean start) {
        int height;
        int scrolloff = ((NumberOption)Options.getInstance().getOption("scrolloff")).value();
        if (scrolloff > (height = EditorHelper.getScreenHeight(editor)) / 2) {
            scrolloff = height / 2;
        }
        if (sline <= height / 2) {
            if (sline < scrolloff + 1) {
                sline = scrolloff + 1;
            }
        } else if (sline > height - scrolloff) {
            sline = height - scrolloff;
        }
        int vline = rawCount == 0 ? EditorHelper.getCurrentVisualLine(editor) : EditorHelper.logicalLineToVisualLine(editor, count - 1);
        MotionGroup.scrollLineToTopOfScreen(editor, EditorHelper.normalizeVisualLine(editor, vline - sline + 1));
        if (vline != EditorHelper.getCurrentVisualLine(editor) || start) {
            int offset = start ? this.moveCaretToLineStartSkipLeading(editor, EditorHelper.visualLineToLogicalLine(editor, vline)) : this.moveCaretVertical(editor, EditorHelper.visualLineToLogicalLine(editor, vline) - EditorHelper.getCurrentLogicalLine(editor));
            MotionGroup.moveCaret(editor, context, offset);
        }
    }

    public int moveCaretToFirstScreenLine(Editor editor, DataPackage context, int count) {
        return this.moveCaretToScreenLine(editor, count);
    }

    public int moveCaretToLastScreenLine(Editor editor, DataPackage context, int count) {
        return this.moveCaretToScreenLine(editor, EditorHelper.getScreenHeight(editor) - count + 1);
    }

    public int moveCaretToLastScreenLineEnd(Editor editor, DataPackage context, int count) {
        int offset = this.moveCaretToLastScreenLine(editor, context, count);
        LogicalPosition lline = editor.offsetToLogicalPosition(offset);
        return this.moveCaretToLineEnd(editor, lline.line, false);
    }

    public int moveCaretToMiddleScreenLine(Editor editor, DataPackage context) {
        return this.moveCaretToScreenLine(editor, EditorHelper.getScreenHeight(editor) / 2 + 1);
    }

    private int moveCaretToScreenLine(Editor editor, int line) {
        int height;
        int scrolloff = ((NumberOption)Options.getInstance().getOption("scrolloff")).value();
        if (scrolloff > (height = EditorHelper.getScreenHeight(editor)) / 2) {
            scrolloff = height / 2;
        }
        int top = EditorHelper.getVisualLineAtTopOfScreen(editor);
        if (line > height - scrolloff && top < EditorHelper.getLineCount(editor) - height) {
            line = height - scrolloff;
        } else if (line <= scrolloff && top > 0) {
            line = scrolloff + 1;
        }
        return this.moveCaretToLineStartSkipLeading(editor, EditorHelper.visualLineToLogicalLine(editor, top + line - 1));
    }

    public boolean scrollHalfPage(Editor editor, DataPackage context, int dir, int count) {
        NumberOption scroll = (NumberOption)Options.getInstance().getOption("scroll");
        int height = EditorHelper.getScreenHeight(editor) / 2;
        if (count == 0) {
            count = scroll.value();
            if (count == 0) {
                count = height;
            }
        } else {
            scroll.set(count);
        }
        return this.scrollPage(editor, context, dir, count, EditorHelper.getCurrentVisualScreenLine(editor), true);
    }

    public boolean scrollColumn(Editor editor, DataPackage context, int columns) {
        int vcol = EditorHelper.getVisualColumnAtLeftOfScreen(editor);
        vcol = EditorHelper.normalizeVisualColumn(editor, EditorHelper.getCurrentVisualLine(editor), vcol + columns, false);
        MotionGroup.scrollColumnToLeftOfScreen(editor, vcol);
        MotionGroup.moveCaretToView(editor, context);
        return true;
    }

    public boolean scrollLine(Editor editor, DataPackage context, int lines) {
        if (logger.isDebugEnabled()) {
            logger.debug("lines=" + lines);
        }
        int vline = EditorHelper.getVisualLineAtTopOfScreen(editor);
        vline = EditorHelper.normalizeVisualLine(editor, vline + lines);
        MotionGroup.scrollLineToTopOfScreen(editor, vline);
        MotionGroup.moveCaretToView(editor, context);
        return true;
    }

    public static void moveCaretToView(Editor editor, DataPackage context) {
        int ccol;
        int col;
        int cline;
        if (logger.isDebugEnabled()) {
            logger.debug("editor=" + editor);
        }
        int scrolloff = ((NumberOption)Options.getInstance().getOption("scrolloff")).value();
        int sidescrolloff = ((NumberOption)Options.getInstance().getOption("sidescrolloff")).value();
        int height = EditorHelper.getScreenHeight(editor);
        int width = EditorHelper.getScreenWidth(editor);
        if (scrolloff > height / 2) {
            scrolloff = height / 2;
        }
        if (sidescrolloff > width / 2) {
            sidescrolloff = width / 2;
        }
        int vline = EditorHelper.getVisualLineAtTopOfScreen(editor);
        int newline = cline = EditorHelper.getCurrentVisualLine(editor);
        if (cline < vline + scrolloff) {
            newline = EditorHelper.normalizeVisualLine(editor, vline + scrolloff);
        } else if (cline >= vline + height - scrolloff) {
            newline = EditorHelper.normalizeVisualLine(editor, vline + height - scrolloff - 1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("vline=" + vline + ", cline=" + cline + ", newline=" + newline);
        }
        int ocol = col = EditorHelper.getCurrentVisualColumn(editor);
        if (col >= EditorHelper.getLineLength(editor) - 1) {
            col = EditorData.getLastColumn(editor);
        }
        int vcol = EditorHelper.getVisualColumnAtLeftOfScreen(editor);
        int newcol = ccol = col;
        if (ccol < vcol + sidescrolloff) {
            newcol = vcol + sidescrolloff;
        } else if (ccol >= vcol + width - sidescrolloff) {
            newcol = vcol + width - sidescrolloff - 1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("col=" + col + ", vcol=" + vcol + ", ccol=" + ccol + ", newcol=" + newcol);
        }
        if (newline == cline && newcol != ccol) {
            col = newcol;
        }
        newcol = EditorHelper.normalizeVisualColumn(editor, newline, newcol, CommandState.getInstance(editor).getMode() == 2 || CommandState.getInstance(editor).getMode() == 3);
        if (newline != cline || newcol != ocol) {
            int offset = EditorHelper.visualPostionToOffset(editor, new VisualPosition(newline, newcol));
            MotionGroup.moveCaret(editor, context, offset);
            EditorData.setLastColumn(editor, col);
        }
    }

    public boolean scrollFullPage(Editor editor, DataPackage context, int pages) {
        int height = EditorHelper.getScreenHeight(editor);
        int line = pages > 0 ? 1 : height;
        return this.scrollPage(editor, context, pages, height - 2, line, false);
    }

    public boolean scrollPage(Editor editor, DataPackage context, int pages, int height, int line, boolean partial) {
        if (logger.isDebugEnabled()) {
            logger.debug("scrollPage(" + pages + ")");
        }
        int tline = EditorHelper.getVisualLineAtTopOfScreen(editor);
        int newline = tline + pages * height;
        int topline = EditorHelper.normalizeVisualLine(editor, newline);
        boolean moved = MotionGroup.scrollLineToTopOfScreen(editor, topline);
        tline = EditorHelper.getVisualLineAtTopOfScreen(editor);
        if (moved && topline == newline && topline == tline) {
            MotionGroup.moveCaret(editor, context, this.moveCaretToScreenLine(editor, line));
            return true;
        }
        if (moved && !partial) {
            int vline = Math.abs(tline - newline) % height + 1;
            if (pages < 0) {
                vline = height - vline + 3;
            }
            MotionGroup.moveCaret(editor, context, this.moveCaretToScreenLine(editor, vline));
            return true;
        }
        if (partial) {
            int cline = EditorHelper.getCurrentVisualLine(editor);
            int vline = cline + pages * height;
            if (cline == (vline = EditorHelper.normalizeVisualLine(editor, vline))) {
                return false;
            }
            int lline = editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)vline, (int)0)).line;
            MotionGroup.moveCaret(editor, context, this.moveCaretToLineStartSkipLeading(editor, lline));
            return true;
        }
        MotionGroup.moveCaret(editor, context, this.moveCaretToLineStartSkipLeading(editor));
        return false;
    }

    private static boolean scrollLineToTopOfScreen(Editor editor, int vline) {
        EditorScrollHandler.ignoreChanges(true);
        int pos = vline * editor.getLineHeight();
        int vpos = editor.getScrollingModel().getVerticalScrollOffset();
        editor.getScrollingModel().scrollVertically(pos);
        EditorScrollHandler.ignoreChanges(false);
        return vpos != editor.getScrollingModel().getVerticalScrollOffset();
    }

    private static void scrollColumnToLeftOfScreen(Editor editor, int vcol) {
        EditorScrollHandler.ignoreChanges(true);
        editor.getScrollingModel().scrollHorizontally(vcol * EditorHelper.getColumnWidth(editor));
        EditorScrollHandler.ignoreChanges(false);
    }

    public int moveCaretToMiddleColumn(Editor editor) {
        int width = EditorHelper.getScreenWidth(editor) / 2;
        int len = EditorHelper.getLineLength(editor);
        return this.moveCaretToColumn(editor, Math.max(0, Math.min(len - 1, width)), false);
    }

    public int moveCaretToColumn(Editor editor, int count, boolean allowEnd) {
        int line = EditorHelper.getCurrentLogicalLine(editor);
        int pos = EditorHelper.normalizeColumn(editor, line, count, allowEnd);
        return editor.logicalPositionToOffset(new LogicalPosition(line, pos));
    }

    public int moveCaretToLineStartSkipLeading(Editor editor) {
        int lline = EditorHelper.getCurrentLogicalLine(editor);
        return this.moveCaretToLineStartSkipLeading(editor, lline);
    }

    public int moveCaretToLineStartSkipLeadingOffset(Editor editor, int offset) {
        int line = EditorHelper.normalizeVisualLine(editor, EditorHelper.getCurrentVisualLine(editor) + offset);
        return this.moveCaretToLineStartSkipLeading(editor, EditorHelper.visualLineToLogicalLine(editor, line));
    }

    public int moveCaretToLineStartSkipLeading(Editor editor, int lline) {
        return EditorHelper.getLeadingCharacterOffset(editor, lline);
    }

    public int moveCaretToLineEndSkipLeadingOffset(Editor editor, int offset) {
        int line = EditorHelper.normalizeVisualLine(editor, EditorHelper.getCurrentVisualLine(editor) + offset);
        return this.moveCaretToLineEndSkipLeading(editor, EditorHelper.visualLineToLogicalLine(editor, line));
    }

    public int moveCaretToLineEndSkipLeading(Editor editor, int lline) {
        int start = EditorHelper.getLineStartOffset(editor, lline);
        int end = EditorHelper.getLineEndOffset(editor, lline, true);
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int pos = start;
        for (int offset = end; offset > start && offset < chars.length(); --offset) {
            if (Character.isWhitespace(chars.charAt(offset))) continue;
            pos = offset;
            break;
        }
        return pos;
    }

    public int moveCaretToLineEnd(Editor editor, boolean allowPastEnd) {
        return this.moveCaretToLineEnd(editor, EditorHelper.getCurrentLogicalLine(editor), allowPastEnd);
    }

    public int moveCaretToLineEnd(Editor editor, int lline, boolean allowPastEnd) {
        return EditorHelper.normalizeOffset(editor, lline, EditorHelper.getLineEndOffset(editor, lline, allowPastEnd), allowPastEnd);
    }

    public int moveCaretToLineEndOffset(Editor editor, int cntForward, boolean allowPastEnd) {
        int line = EditorHelper.normalizeVisualLine(editor, EditorHelper.getCurrentVisualLine(editor) + cntForward);
        if (line < 0) {
            return 0;
        }
        return this.moveCaretToLineEnd(editor, EditorHelper.visualLineToLogicalLine(editor, line), allowPastEnd);
    }

    public int moveCaretToLineStart(Editor editor) {
        int lline = EditorHelper.getCurrentLogicalLine(editor);
        return this.moveCaretToLineStart(editor, lline);
    }

    public int moveCaretToLineStart(Editor editor, int lline) {
        if (lline >= EditorHelper.getLineCount(editor)) {
            return EditorHelper.getFileSize(editor);
        }
        return EditorHelper.getLineStartOffset(editor, lline);
    }

    public int moveCaretToLineStartOffset(Editor editor, int offset) {
        int line = EditorHelper.normalizeVisualLine(editor, EditorHelper.getCurrentVisualLine(editor) + offset);
        return this.moveCaretToLineStart(editor, EditorHelper.visualLineToLogicalLine(editor, line));
    }

    public int moveCaretToLineScreenStart(Editor editor) {
        int col = EditorHelper.getVisualColumnAtLeftOfScreen(editor);
        return this.moveCaretToColumn(editor, col, false);
    }

    public int moveCaretToLineScreenStartSkipLeading(Editor editor) {
        int col = EditorHelper.getVisualColumnAtLeftOfScreen(editor);
        int lline = EditorHelper.getCurrentLogicalLine(editor);
        return EditorHelper.getLeadingCharacterOffset(editor, lline, col);
    }

    public int moveCaretToLineScreenEnd(Editor editor, boolean allowEnd) {
        int col = EditorHelper.getVisualColumnAtLeftOfScreen(editor) + EditorHelper.getScreenWidth(editor) - 1;
        return this.moveCaretToColumn(editor, col, allowEnd);
    }

    public int moveCaretHorizontalWrap(Editor editor, int count) {
        int oldoffset = editor.getCaretModel().getOffset();
        int offset = Math.min(Math.max(0, editor.getCaretModel().getOffset() + count), EditorHelper.getFileSize(editor));
        if (offset == oldoffset) {
            return -1;
        }
        return offset;
    }

    public int moveCaretHorizontal(Editor editor, int count, boolean allowPastEnd) {
        int oldoffset = editor.getCaretModel().getOffset();
        int offset = EditorHelper.normalizeOffset(editor, EditorHelper.getCurrentLogicalLine(editor), oldoffset + count, allowPastEnd);
        if (offset == oldoffset) {
            return -1;
        }
        return offset;
    }

    public int moveCaretVertical(Editor editor, int count) {
        VisualPosition pos = editor.getCaretModel().getVisualPosition();
        if (pos.line == 0 && count < 0 || pos.line >= EditorHelper.getVisualLineCount(editor) - 1 && count > 0) {
            return -1;
        }
        int col = EditorData.getLastColumn(editor);
        int line = EditorHelper.normalizeVisualLine(editor, pos.line + count);
        VisualPosition newPos = new VisualPosition(line, EditorHelper.normalizeVisualColumn(editor, line, col, CommandState.getInstance(editor).getMode() == 2 || CommandState.getInstance(editor).getMode() == 3));
        return EditorHelper.visualPostionToOffset(editor, newPos);
    }

    public int moveCaretToLine(Editor editor, DataPackage context, int lline) {
        int col = EditorData.getLastColumn(editor);
        int line = lline;
        if (lline < 0) {
            line = 0;
            col = 0;
        } else if (lline >= EditorHelper.getLineCount(editor)) {
            line = EditorHelper.normalizeLine(editor, EditorHelper.getLineCount(editor) - 1);
            col = EditorHelper.getLineLength(editor, line);
        }
        LogicalPosition newPos = new LogicalPosition(line, EditorHelper.normalizeColumn(editor, line, col, false));
        return editor.logicalPositionToOffset(newPos);
    }

    public int moveCaretToLinePercent(Editor editor, DataPackage context, int count) {
        if (count > 100) {
            count = 100;
        }
        return this.moveCaretToLineStartSkipLeading(editor, EditorHelper.normalizeLine(editor, (EditorHelper.getLineCount(editor) * count + 99) / 100 - 1));
    }

    public int moveCaretGotoLineLast(Editor editor, DataPackage context, int rawCount, int lline) {
        return this.moveCaretToLineStartSkipLeading(editor, rawCount == 0 ? EditorHelper.normalizeLine(editor, EditorHelper.getLineCount(editor) - 1) : lline);
    }

    public int moveCaretGotoLineLastEnd(Editor editor, DataPackage context, int rawCount, int lline, boolean pastEnd) {
        return this.moveCaretToLineEnd(editor, rawCount == 0 ? EditorHelper.normalizeLine(editor, EditorHelper.getLineCount(editor) - 1) : lline, pastEnd);
    }

    public int moveCaretGotoLineFirst(Editor editor, DataPackage context, int lline) {
        return this.moveCaretToLineStartSkipLeading(editor, lline);
    }

    public static void moveCaret(Editor editor, DataPackage context, int offset) {
        if (offset >= 0 && offset <= editor.getDocument().getTextLength()) {
            editor.getCaretModel().moveToOffset(offset);
            EditorData.setLastColumn(editor, editor.getCaretModel().getVisualPosition().column);
            MotionGroup.scrollCaretIntoView(editor);
            if (CommandState.getInstance(editor).getMode() == 5) {
                CommandGroups.getInstance().getMotion().updateSelection(editor, context, offset);
            } else {
                editor.getSelectionModel().removeSelection();
            }
        }
    }

    public static void scrollCaretIntoView(Editor editor) {
        int diff;
        int cline = EditorHelper.getCurrentVisualLine(editor);
        int vline = EditorHelper.getVisualLineAtTopOfScreen(editor);
        boolean scrolljump = (CommandState.getInstance(editor).getFlags() & 0x1000) == 0;
        int scrolloff = ((NumberOption)Options.getInstance().getOption("scrolloff")).value();
        int sjSize = 0;
        if (scrolljump) {
            sjSize = Math.max(0, ((NumberOption)Options.getInstance().getOption("scrolljump")).value() - 1);
        }
        int height = EditorHelper.getScreenHeight(editor);
        int vtop = vline + scrolloff;
        int vbot = vline + height - scrolloff;
        if (scrolloff >= height / 2 && (vtop = vline + (scrolloff = height / 2)) == (vbot = vline + height - scrolloff)) {
            ++vbot;
        }
        if (cline < vtop) {
            diff = cline - vtop;
            sjSize = -sjSize;
        } else {
            diff = cline - vbot + 1;
            if (diff < 0) {
                diff = 0;
            }
        }
        if (diff != 0) {
            int line = Math.abs(diff) > height / 2 ? cline - height / 2 - 1 : vline + diff + sjSize;
            line = Math.min(line, EditorHelper.getVisualLineCount(editor) - height);
            line = Math.max(0, line);
            MotionGroup.scrollLineToTopOfScreen(editor, line);
        }
        int ccol = EditorHelper.getCurrentVisualColumn(editor);
        int vcol = EditorHelper.getVisualColumnAtLeftOfScreen(editor);
        int width = EditorHelper.getScreenWidth(editor);
        scrolljump = (CommandState.getInstance(editor).getFlags() & 0x2000) == 0;
        scrolloff = ((NumberOption)Options.getInstance().getOption("sidescrolloff")).value();
        sjSize = 0;
        if (scrolljump && (sjSize = Math.max(0, ((NumberOption)Options.getInstance().getOption("sidescroll")).value() - 1)) == 0) {
            sjSize = width / 2;
        }
        int vleft = vcol + scrolloff;
        int vright = vcol + width - scrolloff;
        if (scrolloff >= width / 2 && (vleft = vcol + (scrolloff = width / 2)) == (vright = vcol + width - scrolloff)) {
            ++vright;
        }
        sjSize = Math.min(sjSize, width / 2 - scrolloff);
        if (ccol < vleft) {
            diff = ccol - vleft + 1;
            sjSize = -sjSize;
        } else {
            diff = ccol - vright + 1;
            if (diff < 0) {
                diff = 0;
            }
        }
        if (diff != 0) {
            int col = Math.abs(diff) > width / 2 ? ccol - width / 2 - 1 : vcol + diff + sjSize;
            col = Math.max(0, col);
            MotionGroup.scrollColumnToLeftOfScreen(editor, col);
        }
    }

    public boolean selectPreviousVisualMode(Editor editor, DataPackage context) {
        logger.debug("selectPreviousVisualMode");
        VisualRange vr = EditorData.getLastVisualRange(editor);
        if (vr == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("vr=" + vr);
        }
        CommandState.getInstance(editor).pushState(5, vr.getType(), 2);
        this.visualStart = vr.getStart();
        this.visualEnd = vr.getEnd();
        this.visualOffset = vr.getOffset();
        this.updateSelection(editor, context, this.visualEnd);
        editor.getCaretModel().moveToOffset(this.visualOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        return true;
    }

    public boolean swapVisualSelections(Editor editor, DataPackage context) {
        VisualRange vr = EditorData.getLastVisualRange(editor);
        if (vr == null) {
            return false;
        }
        EditorData.setLastVisualRange(editor, new VisualRange(this.visualStart, this.visualEnd, CommandState.getInstance(editor).getSubMode(), this.visualOffset));
        this.visualStart = vr.getStart();
        this.visualEnd = vr.getEnd();
        this.visualOffset = vr.getOffset();
        CommandState.getInstance(editor).setSubMode(vr.getType());
        this.updateSelection(editor, context, this.visualEnd);
        editor.getCaretModel().moveToOffset(this.visualOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        return true;
    }

    public void setVisualMode(Editor editor, DataPackage context, int mode) {
        int end;
        int start;
        logger.debug("setVisualMode");
        int oldMode = CommandState.getInstance(editor).getSubMode();
        if (mode == 0 && (start = editor.getSelectionModel().getSelectionStart()) != (end = editor.getSelectionModel().getSelectionEnd())) {
            int line = editor.offsetToLogicalPosition((int)start).line;
            int lstart = EditorHelper.getLineStartOffset(editor, line);
            int lend = EditorHelper.getLineEndOffset(editor, line, true);
            if (logger.isDebugEnabled()) {
                logger.debug("start=" + start + ", end=" + end + ", lstart=" + lstart + ", lend=" + lend);
            }
            mode = lstart == start && lend + 1 == end ? 2 : 4;
        }
        if (oldMode == 0 && mode == 0) {
            editor.getSelectionModel().removeSelection();
            return;
        }
        if (mode == 0) {
            this.exitVisual(editor);
        } else {
            CommandState.getInstance(editor).pushState(5, mode, 2);
        }
        KeyHandler.getInstance().reset(editor);
        this.visualStart = editor.getSelectionModel().getSelectionStart();
        this.visualEnd = editor.getSelectionModel().getSelectionEnd();
        if (CommandState.getInstance(editor).getSubMode() == 4) {
            BoundStringOption opt = (BoundStringOption)Options.getInstance().getOption("selection");
            int adj = 1;
            if (opt.getValue().equals("exclusive")) {
                adj = 0;
            }
            this.visualEnd -= adj;
        }
        this.visualOffset = editor.getCaretModel().getOffset();
        if (logger.isDebugEnabled()) {
            logger.debug("visualStart=" + this.visualStart + ", visualEnd=" + this.visualEnd);
        }
        CommandGroups.getInstance().getMark().setMark(editor, context, '<', this.visualStart);
        CommandGroups.getInstance().getMark().setMark(editor, context, '>', this.visualEnd);
    }

    public boolean toggleVisual(Editor editor, DataPackage context, int count, int rawCount, int mode) {
        if (logger.isDebugEnabled()) {
            logger.debug("toggleVisual: mode=" + mode);
        }
        int currentMode = CommandState.getInstance(editor).getSubMode();
        if (CommandState.getInstance(editor).getMode() != 5) {
            int end;
            int start;
            if (rawCount > 0) {
                VisualChange range = EditorData.getLastVisualOperatorRange(editor);
                if (range == null) {
                    logger.debug("no prior visual range");
                    return false;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("last visual change: " + range);
                }
                mode = range.getType();
                start = editor.getCaretModel().getOffset();
                end = this.calculateVisualRange(editor, context, range, count);
            } else {
                start = end = editor.getSelectionModel().getSelectionStart();
            }
            CommandState.getInstance(editor).pushState(5, mode, 2);
            this.visualStart = start;
            this.updateSelection(editor, context, end);
            MotionGroup.moveCaret(editor, context, this.visualEnd);
        } else if (mode == currentMode) {
            this.exitVisual(editor);
        } else {
            CommandState.getInstance(editor).setSubMode(mode);
            this.updateSelection(editor, context, this.visualEnd);
        }
        return true;
    }

    private int calculateVisualRange(Editor editor, DataPackage context, VisualChange range, int count) {
        int res;
        int lines = range.getLines();
        int chars = range.getColumns();
        if (range.getType() == 2 || range.getType() == 8 || lines > 1) {
            lines *= count;
        }
        if (range.getType() == 4 && lines == 1 || range.getType() == 8) {
            chars *= count;
        }
        int start = editor.getCaretModel().getOffset();
        LogicalPosition sp = editor.offsetToLogicalPosition(start);
        int endLine = sp.line + lines - 1;
        if (range.getType() == 2) {
            res = this.moveCaretToLine(editor, context, endLine);
        } else if (range.getType() == 4) {
            res = lines > 1 ? this.moveCaretToLineStart(editor, endLine) + Math.min(EditorHelper.getLineLength(editor, endLine), chars) : EditorHelper.normalizeOffset(editor, sp.line, start + chars - 1, false);
        } else {
            int endcol = Math.min(EditorHelper.getLineLength(editor, endLine), sp.column + chars - 1);
            res = editor.logicalPositionToOffset(new LogicalPosition(endLine, endcol));
        }
        return res;
    }

    public void exitVisual(Editor editor) {
        this.resetVisual(editor);
        if (CommandState.getInstance(editor).getMode() == 5) {
            CommandState.getInstance(editor).popState();
        }
    }

    public void resetVisual(Editor editor) {
        logger.debug("resetVisual");
        EditorData.setLastVisualRange(editor, new VisualRange(this.visualStart, this.visualEnd, CommandState.getInstance(editor).getSubMode(), this.visualOffset));
        if (logger.isDebugEnabled()) {
            logger.debug("visualStart=" + this.visualStart + ", visualEnd=" + this.visualEnd);
        }
        editor.getSelectionModel().removeSelection();
        CommandState.getInstance(editor).setSubMode(0);
    }

    public VisualChange getVisualOperatorRange(Editor editor, int cmdFlags) {
        int type;
        int chars;
        logger.debug("vis op range");
        int start = this.visualStart;
        int end = this.visualEnd;
        if (start > end) {
            int t = start;
            start = end;
            end = t;
        }
        start = EditorHelper.normalizeOffset(editor, start, false);
        end = EditorHelper.normalizeOffset(editor, end, false);
        if (logger.isDebugEnabled()) {
            logger.debug("start=" + start);
            logger.debug("end=" + end);
        }
        LogicalPosition sp = editor.offsetToLogicalPosition(start);
        LogicalPosition ep = editor.offsetToLogicalPosition(end);
        int lines = ep.line - sp.line + 1;
        if (CommandState.getInstance(editor).getSubMode() == 2 || (cmdFlags & 2) != 0) {
            chars = ep.column;
            type = 2;
        } else if (CommandState.getInstance(editor).getSubMode() == 4) {
            type = 4;
            chars = lines > 1 ? ep.column : ep.column - sp.column + 1;
        } else {
            chars = ep.column - sp.column + 1;
            if (EditorData.getLastColumn(editor) == 9999) {
                chars = 9999;
            }
            type = 8;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("lines=" + lines);
            logger.debug("chars=" + chars);
            logger.debug("type=" + type);
        }
        return new VisualChange(lines, chars, type);
    }

    public TextRange getVisualRange(Editor editor) {
        if (ApiHelper.supportsBlockSelection() && editor.getSelectionModel().hasBlockSelection()) {
            TextRange res = new TextRange(editor.getSelectionModel().getBlockSelectionStarts(), editor.getSelectionModel().getBlockSelectionEnds());
            if (EditorData.getLastColumn(editor) >= 9999) {
                int[] starts = res.getStartOffsets();
                int[] ends = res.getEndOffsets();
                for (int i = 0; i < starts.length; ++i) {
                    if (ends[i] <= starts[i]) continue;
                    ends[i] = EditorHelper.getLineEndForOffset(editor, starts[i]);
                }
                res = new TextRange(starts, ends);
            }
            return res;
        }
        return new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
    }

    public TextRange getRawVisualRange() {
        return new TextRange(this.visualStart, this.visualEnd);
    }

    private void updateSelection(Editor editor, DataPackage context, int offset) {
        logger.debug("updateSelection");
        this.visualEnd = offset;
        this.visualOffset = offset;
        int start = this.visualStart;
        int end = this.visualEnd;
        if (start > end) {
            int t = start;
            start = end;
            end = t;
        }
        if (CommandState.getInstance(editor).getSubMode() == 4) {
            BoundStringOption opt = (BoundStringOption)Options.getInstance().getOption("selection");
            int lineend = EditorHelper.getLineEndForOffset(editor, end);
            if (logger.isDebugEnabled()) {
                logger.debug("lineend=" + lineend);
                logger.debug("end=" + end);
            }
            int adj = 1;
            if (opt.getValue().equals("exclusive") || end == lineend) {
                adj = 0;
            }
            end = Math.min(EditorHelper.getFileSize(editor), end + adj);
            if (logger.isDebugEnabled()) {
                logger.debug("start=" + start + ", end=" + end);
            }
            editor.getSelectionModel().setSelection(start, end);
        } else if (CommandState.getInstance(editor).getSubMode() == 2) {
            start = EditorHelper.getLineStartForOffset(editor, start);
            end = EditorHelper.getLineEndForOffset(editor, end);
            if (logger.isDebugEnabled()) {
                logger.debug("start=" + start + ", end=" + end);
            }
            editor.getSelectionModel().setSelection(start, end);
        } else if (ApiHelper.supportsBlockSelection()) {
            LogicalPosition lstart = editor.offsetToLogicalPosition(start);
            LogicalPosition lend = editor.offsetToLogicalPosition(end);
            if (logger.isDebugEnabled()) {
                logger.debug("lstart=" + lstart + ", lend=" + lend);
            }
            editor.getSelectionModel().setBlockSelection(lstart, lend);
        }
        CommandGroups.getInstance().getMark().setMark(editor, context, '<', start);
        CommandGroups.getInstance().getMark().setMark(editor, context, '>', end);
    }

    public boolean swapVisualEnds(Editor editor, DataPackage context) {
        int t = this.visualEnd;
        this.visualEnd = this.visualStart;
        this.visualStart = t;
        MotionGroup.moveCaret(editor, context, this.visualEnd);
        return true;
    }

    public boolean swapVisualEndsBlock(Editor editor, DataPackage context) {
        if (CommandState.getInstance(editor).getSubMode() != 8) {
            return this.swapVisualEnds(editor, context);
        }
        LogicalPosition lstart = editor.getSelectionModel().getBlockStart();
        LogicalPosition lend = editor.getSelectionModel().getBlockEnd();
        if (lstart == null || lend == null) {
            return false;
        }
        if (this.visualStart > this.visualEnd) {
            LogicalPosition t = lend;
            lend = lstart;
            lstart = t;
        }
        LogicalPosition nstart = new LogicalPosition(lstart.line, lend.column);
        LogicalPosition nend = new LogicalPosition(lend.line, lstart.column);
        this.visualStart = editor.logicalPositionToOffset(nstart);
        this.visualEnd = editor.logicalPositionToOffset(nend);
        MotionGroup.moveCaret(editor, context, this.visualEnd);
        return true;
    }

    public void moveVisualStart(Editor editor, int startOffset) {
        this.visualStart = startOffset;
    }

    public void processEscape(Editor editor, DataPackage context) {
        this.exitVisual(editor);
    }

    private static class EditorMouseHandler
    implements EditorMouseListener,
    EditorMouseMotionListener {
        private Editor dragEditor = null;
        private int mode;
        private int startOff;
        private int endOff;

        private EditorMouseHandler() {
        }

        public void mouseMoved(EditorMouseEvent event) {
        }

        public void mouseDragged(EditorMouseEvent event) {
            if (!VimPlugin.isEnabled()) {
                return;
            }
            if (event.getArea() == EditorMouseEventArea.EDITING_AREA || event.getArea() != EditorMouseEventArea.ANNOTATIONS_AREA) {
                if (this.dragEditor == null) {
                    if (event.getArea() == EditorMouseEventArea.EDITING_AREA) {
                        this.mode = 4;
                    } else if (event.getArea() != EditorMouseEventArea.ANNOTATIONS_AREA) {
                        this.mode = 2;
                    }
                    this.startOff = event.getEditor().getSelectionModel().getSelectionStart();
                    this.endOff = event.getEditor().getSelectionModel().getSelectionEnd();
                    if (logger.isDebugEnabled()) {
                        logger.debug("startOff=" + this.startOff);
                    }
                }
                this.dragEditor = event.getEditor();
            }
        }

        public void mousePressed(EditorMouseEvent event) {
        }

        public void mouseClicked(EditorMouseEvent event) {
            if (!VimPlugin.isEnabled()) {
                return;
            }
            if (event.getArea() == EditorMouseEventArea.EDITING_AREA) {
                CommandGroups.getInstance().getMotion().processMouseClick(event.getEditor(), event.getMouseEvent());
            } else if (event.getArea() != EditorMouseEventArea.ANNOTATIONS_AREA && event.getArea() != EditorMouseEventArea.FOLDING_OUTLINE_AREA) {
                CommandGroups.getInstance().getMotion().processLineSelection(event.getEditor(), event.getMouseEvent().getButton() == 3);
            }
        }

        public void mouseReleased(EditorMouseEvent event) {
            if (!VimPlugin.isEnabled()) {
                return;
            }
            if (event.getEditor().equals(this.dragEditor)) {
                CommandGroups.getInstance().getMotion().processMouseReleased(event.getEditor(), this.mode, this.startOff, this.endOff);
                this.dragEditor = null;
            }
        }

        public void mouseEntered(EditorMouseEvent event) {
        }

        public void mouseExited(EditorMouseEvent event) {
        }
    }

    private static class EditorScrollHandler
    implements VisibleAreaListener {
        private static boolean ignore = false;

        private EditorScrollHandler() {
        }

        public static void ignoreChanges(boolean ignore) {
            EditorScrollHandler.ignore = ignore;
        }

        public void visibleAreaChanged(VisibleAreaEvent visibleAreaEvent) {
            if (ignore) {
                return;
            }
            Editor editor = visibleAreaEvent.getEditor();
            if (CommandState.getInstance(editor).getMode() == 2 || CommandState.getInstance(editor).getMode() == 3) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("old=" + visibleAreaEvent.getOldRectangle());
                logger.debug("new=" + visibleAreaEvent.getNewRectangle());
            }
            if (!visibleAreaEvent.getNewRectangle().equals(visibleAreaEvent.getOldRectangle()) && !EditorData.isConsoleOutput(editor)) {
                MotionGroup.moveCaretToView(editor, null);
            }
        }
    }

    private static class EditorSelectionHandler
    implements SelectionListener {
        private boolean makingChanges = false;

        private EditorSelectionHandler() {
        }

        public void selectionChanged(SelectionEvent selectionEvent) {
            Editor[] editors;
            if (this.makingChanges) {
                return;
            }
            this.makingChanges = true;
            Editor editor = selectionEvent.getEditor();
            TextRange range = new TextRange(selectionEvent.getNewRange().getStartOffset(), selectionEvent.getNewRange().getEndOffset());
            for (Editor ed : editors = EditorFactory.getInstance().getEditors(editor.getDocument())) {
                if (ed.equals(editor)) continue;
                ed.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
                ed.getCaretModel().moveToOffset(editor.getCaretModel().getOffset());
            }
            this.makingChanges = false;
        }
    }

    public static class MotionEditorChange
    extends FileEditorManagerAdapter {
        public void selectionChanged(FileEditorManagerEvent event) {
            Editor editor;
            FileEditor fe;
            if (ExEntryPanel.getInstance().isActive()) {
                ExEntryPanel.getInstance().deactivate(false);
            }
            if (MorePanel.getInstance().isActive()) {
                MorePanel.getInstance().deactivate(false);
            }
            if ((fe = event.getOldEditor()) instanceof TextEditor && CommandState.getInstance(editor = ((TextEditor)fe).getEditor()).getMode() == 5) {
                CommandGroups.getInstance().getMotion().exitVisual(EditorHelper.getEditor(event.getManager(), event.getOldFile()));
            }
        }
    }
}

