/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandState;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.CommandParser;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.group.AbstractActionGroup;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorData;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.RunnableHelper;
import com.maddyhome.idea.vim.ui.ExEntryPanel;
import com.maddyhome.idea.vim.ui.MorePanel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ProcessGroup
extends AbstractActionGroup {
    private String lastCommand;
    private static Logger logger = Logger.getInstance((String)ProcessGroup.class.getName());

    public String getLastCommand() {
        return this.lastCommand;
    }

    public void startSearchCommand(Editor editor, DataPackage context, int count, char leader) {
        if (editor.isOneLineMode()) {
            return;
        }
        String initText = "";
        String label = "" + leader;
        ExEntryPanel panel = ExEntryPanel.getInstance();
        panel.activate(editor, context, label, initText, count);
    }

    public String endSearchCommand(final Editor editor, DataPackage context) {
        ExEntryPanel panel = ExEntryPanel.getInstance();
        panel.deactivate(false);
        final Project project = context.getProject();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VirtualFile vf = EditorData.getVirtualFile(editor);
                if (vf != null) {
                    FileEditorManager.getInstance((Project)project).openFile(EditorData.getVirtualFile(editor), true);
                }
            }
        });
        this.record(editor, panel.getText());
        return panel.getText();
    }

    public void startExCommand(Editor editor, DataPackage context, Command cmd) {
        if (editor.isOneLineMode()) {
            return;
        }
        String initText = this.getRange(editor, cmd);
        CommandState.getInstance(editor).pushState(6, 0, 16);
        ExEntryPanel panel = ExEntryPanel.getInstance();
        panel.activate(editor, context, ":", initText, 1);
    }

    public boolean processExKey(Editor editor, DataPackage context, KeyStroke stroke, boolean charOnly) {
        ExEntryPanel panel = ExEntryPanel.getInstance();
        if (panel.isActive()) {
            panel.requestFocus();
            panel.handleKey(stroke);
            return true;
        }
        CommandState.getInstance(editor).popState();
        KeyHandler.getInstance().reset(editor);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean processExEntry(Editor editor, DataPackage context) {
        Project project;
        int flg;
        ExEntryPanel panel = ExEntryPanel.getInstance();
        panel.deactivate(false);
        boolean res = true;
        int flags = 0;
        try {
            CommandState.getInstance(editor).popState();
            logger.debug("processing command");
            String text = panel.getText();
            this.record(editor, text);
            if (logger.isDebugEnabled()) {
                logger.debug("swing=" + SwingUtilities.isEventDispatchThread());
            }
            if (panel.getLabel().equals(":")) {
                flags = CommandParser.getInstance().processCommand(editor, context, text, 1);
                if (logger.isDebugEnabled()) {
                    logger.debug("flags=" + flags);
                }
                if (CommandState.getInstance(editor).getMode() == 5) {
                    CommandGroups.getInstance().getMotion().exitVisual(editor);
                }
            } else {
                int pos = CommandGroups.getInstance().getSearch().search(editor, context, text, panel.getCount(), panel.getLabel().equals("/") ? 65536 : 131072, true);
                if (pos == -1) {
                    res = false;
                }
            }
            flg = flags;
            project = context.getProject();
        }
        catch (ExException ex) {
            logger.info(ex.getMessage());
            VimPlugin.indicateError();
            res = false;
            int flg2 = flags;
            Project project2 = context.getProject();
            SwingUtilities.invokeLater(new Runnable(flg2, editor, project2){
                final /* synthetic */ int val$flg;
                final /* synthetic */ Editor val$editor;
                final /* synthetic */ Project val$project;
                {
                    this.val$flg = n;
                    this.val$editor = editor;
                    this.val$project = project;
                }

                public void run() {
                    VirtualFile vf;
                    if ((this.val$flg & 4) == 0 && (vf = EditorData.getVirtualFile(this.val$editor)) != null) {
                        FileEditorManager.getInstance((Project)this.val$project).openFile(EditorData.getVirtualFile(this.val$editor), true);
                    }
                    if ((this.val$flg & 2) != 0 && MorePanel.getInstance(this.val$editor).hasText()) {
                        RunnableHelper.runReadCommand(this.val$project, new Runnable(){

                            public void run() {
                                MorePanel.getInstance(val$editor).activate();
                            }
                        }, "ShowMorePanel", "ExCommand");
                    }
                }
            });
        }
        catch (Exception bad) {
            logger.error((Throwable)bad);
            VimPlugin.indicateError();
            res = false;
            int flg3 = flags;
            Project project3 = context.getProject();
            {
                catch (Throwable throwable) {
                    int flg4 = flags;
                    Project project4 = context.getProject();
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        return res;
    }

    public boolean cancelExEntry(final Editor editor, DataPackage context) {
        CommandState.getInstance(editor).popState();
        KeyHandler.getInstance().reset(editor);
        ExEntryPanel panel = ExEntryPanel.getInstance();
        panel.deactivate(false);
        final Project project = context.getProject();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VirtualFile vf = EditorData.getVirtualFile(editor);
                if (vf != null) {
                    FileEditorManager.getInstance((Project)project).openFile(EditorData.getVirtualFile(editor), true);
                }
            }
        });
        return true;
    }

    private void record(Editor editor, String text) {
        if (CommandState.getInstance(editor).isRecording()) {
            CommandGroups.getInstance().getRegister().addText(text);
        }
    }

    public void startFilterCommand(Editor editor, DataPackage context, Command cmd) {
        String initText = this.getRange(editor, cmd) + "!";
        CommandState.getInstance(editor).pushState(6, 0, 16);
        ExEntryPanel panel = ExEntryPanel.getInstance();
        panel.activate(editor, context, ":", initText, 1);
    }

    private String getRange(Editor editor, Command cmd) {
        String initText = "";
        if (CommandState.getInstance(editor).getMode() == 5) {
            initText = "'<,'>";
        } else if (cmd.getRawCount() > 0) {
            initText = cmd.getCount() == 1 ? "." : ".,.+" + (cmd.getCount() - 1);
        }
        return initText;
    }

    public boolean executeFilter(Editor editor, DataPackage context, TextRange range, String command) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("command=" + command);
        }
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        StringReader car = new StringReader(((Object)chars.subSequence(range.getStartOffset(), range.getEndOffset())).toString());
        StringWriter sw = new StringWriter();
        logger.debug("about to create filter");
        Process filter = Runtime.getRuntime().exec(command);
        logger.debug("filter created");
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(filter.getOutputStream()));
        logger.debug("sending text");
        this.copy(car, writer);
        writer.close();
        logger.debug("sent");
        BufferedReader reader = new BufferedReader(new InputStreamReader(filter.getInputStream()));
        logger.debug("getting result");
        this.copy(reader, sw);
        sw.close();
        logger.debug("received");
        editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)sw.toString());
        this.lastCommand = command;
        return true;
    }

    private void copy(Reader from, Writer to) throws IOException {
        int cnt;
        char[] buf = new char[2048];
        while ((cnt = from.read(buf)) != -1) {
            if (logger.isDebugEnabled()) {
                logger.debug("buf=" + buf);
            }
            to.write(buf, 0, cnt);
        }
    }
}

