/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.command.CommandState;
import com.maddyhome.idea.vim.common.Register;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.group.AbstractActionGroup;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.StringHelper;
import com.maddyhome.idea.vim.ui.ClipboardHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.KeyStroke;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterGroup
extends AbstractActionGroup {
    public static final char REGISTER_DEFAULT = '\"';
    private char lastRegister = (char)34;
    private HashMap<Character, Register> registers = new HashMap();
    private char recordRegister = '\u0000';
    private List<KeyStroke> recordList = null;
    private static final String WRITABLE_REGISTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-*+_/\"";
    private static final String READONLY_REGISTERS = ":.%#=/";
    private static final String RECORDABLE_REGISTER = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String PLAYBACK_REGISTER = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\".*+";
    private static final String VALID_REGISTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-*+_/\":.%#=/";
    private static Logger logger = Logger.getInstance((String)RegisterGroup.class.getName());

    public boolean isRegisterWritable() {
        return READONLY_REGISTERS.indexOf(this.lastRegister) < 0;
    }

    public boolean selectRegister(char reg) {
        if (VALID_REGISTERS.indexOf(reg) != -1) {
            this.lastRegister = reg;
            if (logger.isDebugEnabled()) {
                logger.debug("register selected: " + this.lastRegister);
            }
            return true;
        }
        return false;
    }

    public void resetRegister() {
        this.lastRegister = (char)34;
        logger.debug("register reset");
    }

    public boolean storeText(Editor editor, DataPackage context, TextRange range, int type, boolean isDelete, boolean isYank) {
        if (this.isRegisterWritable()) {
            String text = EditorHelper.getText(editor, range);
            return this.storeTextInternal(editor, context, range, text, type, this.lastRegister, isDelete, isYank);
        }
        return false;
    }

    public void storeKeys(List<KeyStroke> strokes, int type, char register) {
        this.registers.put(Character.valueOf(register), new Register(register, type, strokes));
    }

    public boolean storeTextInternal(Editor editor, DataPackage context, TextRange range, String text, int type, char register, boolean isDelete, boolean isYank) {
        int end;
        if (this.lastRegister == '_') {
            return true;
        }
        int start = range.getStartOffset();
        if (start > (end = range.getEndOffset())) {
            int t = start;
            start = end;
            end = t;
        }
        if (type == 2 && text.length() > 0 && text.charAt(text.length() - 1) != '\n') {
            text = text + '\n';
        }
        if (Character.isUpperCase(register)) {
            char lreg = Character.toLowerCase(register);
            Register r = this.registers.get(new Character(lreg));
            if (r != null) {
                r.addText(text);
            } else {
                this.registers.put(Character.valueOf(lreg), new Register(lreg, type, text));
                if (logger.isDebugEnabled()) {
                    logger.debug("register '" + register + "' contains: \"" + text + "\"");
                }
            }
        } else if (register == '*' || register == '+') {
            ClipboardHandler.setClipboardText(text);
        } else {
            this.registers.put(Character.valueOf(register), new Register(register, type, text));
            if (logger.isDebugEnabled()) {
                logger.debug("register '" + register + "' contains: \"" + text + "\"");
            }
        }
        if (register != '\"' && ".:/".indexOf(register) == -1) {
            this.registers.put(Character.valueOf('\"'), new Register('\"', type, text));
            if (logger.isDebugEnabled()) {
                logger.debug("register '" + register + "' contains: \"" + text + "\"");
            }
        }
        if (isDelete) {
            for (char d = '8'; d >= '1'; d = (char)(d - '\u0001')) {
                Register t = this.registers.get(new Character(d));
                if (t == null) continue;
                t.rename((char)(d + '\u0001'));
                this.registers.put(Character.valueOf((char)(d + '\u0001')), t);
            }
            this.registers.put(Character.valueOf('1'), new Register('1', type, text));
            if (type == 4 && editor.offsetToLogicalPosition((int)start).line == editor.offsetToLogicalPosition((int)end).line) {
                this.registers.put(Character.valueOf('-'), new Register('-', type, text));
            }
        } else if (register == '\"') {
            this.registers.put(Character.valueOf('0'), new Register('0', type, text));
            if (logger.isDebugEnabled()) {
                logger.debug("register '0' contains: \"" + text + "\"");
            }
        }
        if (start != -1) {
            CommandGroups.getInstance().getMark().setMark(editor, context, '[', start);
            CommandGroups.getInstance().getMark().setMark(editor, context, ']', end - 1);
        }
        return true;
    }

    public Register getLastRegister() {
        return this.getRegister(this.lastRegister);
    }

    public Register getPlaybackRegister(char r) {
        if (PLAYBACK_REGISTER.indexOf(r) != 0) {
            return this.getRegister(r);
        }
        return null;
    }

    public Register getRegister(char r) {
        if (Character.isUpperCase(r)) {
            r = Character.toLowerCase(r);
        }
        Register reg = null;
        if (r == '*' || r == '+') {
            String text = ClipboardHandler.getClipboardText();
            if (text != null) {
                reg = new Register(r, 4, text);
            }
        } else {
            reg = this.registers.get(new Character(r));
        }
        return reg;
    }

    public char getCurrentRegister() {
        return this.lastRegister;
    }

    public List<Register> getRegisters() {
        ArrayList<Register> res = new ArrayList<Register>(this.registers.values());
        Collections.sort(res, new Register.KeySorter());
        return res;
    }

    public boolean startRecording(Editor editor, char register) {
        if (RECORDABLE_REGISTER.indexOf(register) != -1) {
            CommandState.getInstance(editor).setRecording(true);
            this.recordRegister = register;
            this.recordList = new ArrayList<KeyStroke>();
            return true;
        }
        return false;
    }

    public void addKeyStroke(KeyStroke key) {
        if (this.recordRegister != '\u0000') {
            this.recordList.add(key);
        }
    }

    public void addText(String text) {
        if (this.recordRegister != '\u0000') {
            this.recordList.addAll(StringHelper.stringToKeys(text));
        }
    }

    public void finishRecording(Editor editor) {
        if (this.recordRegister != '\u0000') {
            Register reg = null;
            if (Character.isUpperCase(this.recordRegister)) {
                reg = this.getRegister(this.recordRegister);
            }
            if (reg == null) {
                reg = new Register(Character.toLowerCase(this.recordRegister), 4, this.recordList);
                this.registers.put(Character.valueOf(Character.toLowerCase(this.recordRegister)), reg);
            } else {
                reg.addKeys(this.recordList);
            }
            CommandState.getInstance(editor).setRecording(false);
        }
        this.recordRegister = '\u0000';
    }

    @Override
    public void saveData(Element element) {
        logger.debug("saveData");
        Element regs = new Element("registers");
        for (Character key : this.registers.keySet()) {
            Register register = this.registers.get(key);
            Element reg = new Element("register");
            reg.setAttribute("name", String.valueOf(key));
            reg.setAttribute("type", Integer.toString(register.getType()));
            if (register.isText()) {
                Element text = new Element("text");
                CDATA data = new CDATA(StringHelper.entities(register.getText()));
                text.addContent((Content)data);
                reg.addContent(text);
                if (logger.isDebugEnabled()) {
                    logger.debug("register='" + register.getText() + "'");
                    logger.debug("data=" + data);
                    logger.debug("text=" + text);
                }
            } else {
                Element keys = new Element("keys");
                List<KeyStroke> list = register.getKeys();
                for (KeyStroke stroke : list) {
                    Element k = new Element("key");
                    k.setAttribute("char", Integer.toString(stroke.getKeyChar()));
                    k.setAttribute("code", Integer.toString(stroke.getKeyCode()));
                    k.setAttribute("mods", Integer.toString(stroke.getModifiers()));
                    keys.addContent(k);
                }
                reg.addContent(keys);
            }
            regs.addContent(reg);
        }
        element.addContent(regs);
    }

    @Override
    public void readData(Element element) {
        logger.debug("readData");
        Element regs = element.getChild("registers");
        if (regs != null) {
            List list = regs.getChildren("register");
            for (Element reg : list) {
                Register register;
                Character key = Character.valueOf(reg.getAttributeValue("name").charAt(0));
                if (reg.getChild("text") != null) {
                    register = new Register(key.charValue(), Integer.parseInt(reg.getAttributeValue("type")), StringHelper.unentities(reg.getChild("text").getText()));
                } else {
                    Element keys = reg.getChild("keys");
                    List klist = keys.getChildren("key");
                    ArrayList<KeyStroke> strokes = new ArrayList<KeyStroke>();
                    for (Element kelem : klist) {
                        int code = Integer.parseInt(kelem.getAttributeValue("code"));
                        int mods = Integer.parseInt(kelem.getAttributeValue("mods"));
                        char ch = (char)Integer.parseInt(kelem.getAttributeValue("char"));
                        if (ch == '\uffff') {
                            strokes.add(KeyStroke.getKeyStroke(code, mods));
                            continue;
                        }
                        strokes.add(KeyStroke.getKeyStroke(new Character(ch), mods));
                    }
                    register = new Register(key.charValue(), Integer.parseInt(reg.getAttributeValue("type")), strokes);
                }
                this.registers.put(key, register);
            }
        }
    }
}

