/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.common.CharacterPosition;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.LineRange;
import com.maddyhome.idea.vim.group.AbstractActionGroup;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.group.MotionGroup;
import com.maddyhome.idea.vim.helper.ApiHelper;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.EditorData;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.helper.SearchHelper;
import com.maddyhome.idea.vim.helper.StringHelper;
import com.maddyhome.idea.vim.option.OptionChangeEvent;
import com.maddyhome.idea.vim.option.OptionChangeListener;
import com.maddyhome.idea.vim.option.Options;
import com.maddyhome.idea.vim.regexp.CharHelper;
import com.maddyhome.idea.vim.regexp.CharPointer;
import com.maddyhome.idea.vim.regexp.CharacterClasses;
import com.maddyhome.idea.vim.regexp.RegExp;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

public class SearchGroup
extends AbstractActionGroup {
    public static final int KEEP_FLAGS = 1;
    public static final int CONFIRM = 2;
    public static final int IGNORE_ERROR = 4;
    public static final int GLOBAL = 8;
    public static final int IGNORE_CASE = 16;
    public static final int NO_IGNORE_CASE = 32;
    public static final int PRINT = 64;
    public static final int REUSE = 128;
    private String lastSearch;
    private String lastPattern;
    private String lastSubstitute;
    private String lastReplace;
    private String lastOffset;
    private int lastDir;
    private JButton[] confirmBtns;
    private JOptionPane confirmDlg = null;
    private boolean showSearchHighlight = Options.getInstance().isSet("hlsearch");
    private boolean do_all = false;
    private boolean do_ask = false;
    private boolean do_error = true;
    private char do_ic = '\u0000';
    private static final int RE_LAST = 1;
    private static final int RE_SEARCH = 2;
    private static final int RE_SUBST = 3;
    private static Logger logger = Logger.getInstance((String)SearchGroup.class.getName());

    public SearchGroup() {
        if (ApiHelper.supportsColorSchemes()) {
            Options.getInstance().getOption("hlsearch").addOptionChangeListener(new OptionChangeListener(){

                public void valueChange(OptionChangeEvent event) {
                    SearchGroup.this.showSearchHighlight = Options.getInstance().isSet("hlsearch");
                    SearchGroup.this.updateHighlight();
                }
            });
        }
    }

    public String getLastSearch() {
        return this.lastSearch;
    }

    public String getLastPattern() {
        return this.lastPattern;
    }

    private void setLastPattern(Editor editor, DataPackage context, String lastPattern) {
        this.lastPattern = lastPattern;
        CommandGroups.getInstance().getRegister().storeTextInternal(editor, context, new TextRange(-1, -1), lastPattern, 4, '/', false, false);
        CommandGroups.getInstance().getHistory().addEntry("search", lastPattern);
    }

    public boolean searchAndReplace(Editor editor, DataPackage context, LineRange range, String excmd, String exarg) {
        CharPointer sub;
        CharPointer pat;
        boolean res = true;
        CharPointer cmd = new CharPointer(new StringBuffer(exarg));
        int which_pat = excmd.equals("~") ? 1 : 3;
        if (excmd.charAt(0) == 's' && !cmd.isNul() && !Character.isWhitespace(cmd.charAt()) && "0123456789cegriIp|\"".indexOf(cmd.charAt()) == -1) {
            char delimiter;
            if (CharacterClasses.isAlpha(cmd.charAt())) {
                MessageHelper.EMSG("E146");
                return false;
            }
            if (cmd.charAt() == '\\') {
                cmd.inc();
                if ("/?&".indexOf(cmd.charAt()) == -1) {
                    MessageHelper.EMSG("e_backslash");
                    return false;
                }
                if (cmd.charAt() != '&') {
                    which_pat = 2;
                }
                pat = new CharPointer("");
                delimiter = cmd.charAt();
                cmd.inc();
            } else {
                which_pat = 1;
                delimiter = cmd.charAt();
                cmd.inc();
                pat = cmd.ref(0);
                cmd = RegExp.skip_regexp(cmd, delimiter, true);
                if (cmd.charAt() == delimiter) {
                    cmd.set('\u0000').inc();
                }
            }
            sub = cmd.ref(0);
            while (!cmd.isNul()) {
                if (cmd.charAt() == delimiter) {
                    cmd.set('\u0000').inc();
                    break;
                }
                if (cmd.charAt(0) == '\\' && cmd.charAt(1) != '\u0000') {
                    cmd.inc();
                }
                cmd.inc();
            }
        } else {
            if (this.lastReplace == null) {
                MessageHelper.EMSG("e_nopresub");
                return false;
            }
            pat = null;
            sub = new CharPointer(this.lastReplace);
        }
        if (cmd.charAt() == '&') {
            cmd.inc();
        } else {
            this.do_all = Options.getInstance().isSet("gdefault");
            this.do_ask = false;
            this.do_error = true;
            this.do_ic = '\u0000';
        }
        while (!cmd.isNul()) {
            if (cmd.charAt() == 'g') {
                this.do_all = !this.do_all;
            } else if (cmd.charAt() == 'c') {
                this.do_ask = !this.do_ask;
            } else if (cmd.charAt() == 'e') {
                this.do_error = !this.do_error;
            } else if (cmd.charAt() == 'r') {
                which_pat = 1;
            } else if (cmd.charAt() != 'p') {
                if (cmd.charAt() == 'i') {
                    this.do_ic = (char)105;
                } else {
                    if (cmd.charAt() != 'I') break;
                    this.do_ic = (char)73;
                }
            }
            cmd.inc();
        }
        int line1 = range.getStartLine();
        int line2 = range.getEndLine();
        if (CharacterClasses.isDigit((cmd = CharHelper.skipwhite(cmd)).charAt())) {
            int i = CharHelper.getdigits(cmd);
            if (i <= 0 && this.do_error) {
                MessageHelper.EMSG("e_zerocount");
                return false;
            }
            line1 = line2;
            line2 = EditorHelper.normalizeLine(editor, line1 + i - 1);
        }
        if (!(cmd = CharHelper.skipwhite(cmd)).isNul() && cmd.charAt() != '\"') {
            MessageHelper.EMSG("e_trailing");
            return false;
        }
        String pattern = "";
        if (pat == null || pat.isNul()) {
            switch (which_pat) {
                case 1: {
                    pattern = this.lastPattern;
                    break;
                }
                case 2: {
                    pattern = this.lastSearch;
                    break;
                }
                case 3: {
                    pattern = this.lastSubstitute;
                }
            }
        } else {
            pattern = pat.toString();
        }
        this.lastSubstitute = pattern;
        this.setLastPattern(editor, context, pattern);
        int start = editor.getDocument().getLineStartOffset(line1);
        int end = editor.getDocument().getLineEndOffset(line2);
        RegExp.regmmatch_T regmatch = new RegExp.regmmatch_T();
        RegExp sp = new RegExp();
        regmatch.regprog = sp.vim_regcomp(pattern, 1);
        if (regmatch.regprog == null) {
            if (this.do_error) {
                MessageHelper.EMSG("e_invcmd");
            }
            return false;
        }
        if (this.do_ic == 'i') {
            regmatch.rmm_ic = true;
        } else if (this.do_ic == 'I') {
            regmatch.rmm_ic = false;
        }
        if ((sub.charAt(0) != '\\' || sub.charAt(1) != '=') && this.lastReplace != null) {
            StringBuffer tmp = new StringBuffer(sub.toString());
            int pos = 0;
            while ((pos = tmp.indexOf("~", pos)) != -1) {
                if (pos == 0 || tmp.charAt(pos - 1) != '\\') {
                    tmp.replace(pos, pos + 1, this.lastReplace);
                    pos += this.lastReplace.length();
                }
                ++pos;
            }
            sub = new CharPointer(tmp);
        }
        this.lastReplace = sub.toString();
        this.searchHighlight(false);
        if (logger.isDebugEnabled()) {
            logger.debug("search range=[" + start + "," + end + "]");
            logger.debug("pattern=" + pattern + ", replace=" + sub);
        }
        int lastMatch = -1;
        int lastLine = -1;
        int searchcol = 0;
        boolean firstMatch = true;
        boolean got_quit = false;
        int lcount = EditorHelper.getLineCount(editor);
        int lnum = line1;
        while (lnum <= line2 && !got_quit) {
            CharacterPosition newpos = null;
            int nmatch = sp.vim_regexec_multi(regmatch, editor, lcount, lnum, searchcol);
            if (nmatch > 0) {
                if (firstMatch) {
                    CommandGroups.getInstance().getMark().saveJumpLocation(editor, context);
                    firstMatch = false;
                }
                String match = sp.vim_regsub_multi(regmatch, lnum, sub, 1, false);
                int line = lnum + regmatch.startpos[0].lnum;
                CharacterPosition startpos = new CharacterPosition(lnum + regmatch.startpos[0].lnum, regmatch.startpos[0].col);
                CharacterPosition endpos = new CharacterPosition(lnum + regmatch.endpos[0].lnum, regmatch.endpos[0].col);
                int startoff = EditorHelper.characterPositionToOffset(editor, startpos);
                int endoff = EditorHelper.characterPositionToOffset(editor, endpos);
                int newend = startoff + match.length();
                if (this.do_all || line != lastLine) {
                    boolean doReplace = true;
                    if (this.do_ask) {
                        RangeHighlighter hl = this.highlightConfirm(editor, startoff, endoff);
                        int choice = this.getConfirmChoice(match);
                        editor.getMarkupModel().removeHighlighter(hl);
                        switch (choice) {
                            case 0: {
                                doReplace = true;
                                break;
                            }
                            case 1: {
                                doReplace = false;
                                break;
                            }
                            case 2: {
                                this.do_ask = false;
                                break;
                            }
                            case -1: 
                            case 3: {
                                doReplace = false;
                                got_quit = true;
                                break;
                            }
                            case 4: {
                                this.do_all = false;
                                line2 = lnum;
                                doReplace = true;
                            }
                        }
                    }
                    if (doReplace) {
                        editor.getDocument().replaceString(startoff, endoff, (CharSequence)match);
                        lastMatch = startoff;
                        newpos = EditorHelper.offsetToCharacterPosition(editor, newend);
                        line2 += newpos.line - endpos.line;
                    }
                }
                lastLine = line;
                lnum += nmatch - 1;
                if (this.do_all) {
                    if (newpos != null) {
                        searchcol = newpos.column;
                        continue;
                    }
                    searchcol = endpos.column;
                    continue;
                }
                searchcol = 0;
                ++lnum;
                continue;
            }
            ++lnum;
            searchcol = 0;
        }
        if (lastMatch != -1) {
            MotionGroup.moveCaret(editor, context, CommandGroups.getInstance().getMotion().moveCaretToLineStartSkipLeading(editor, editor.offsetToLogicalPosition((int)lastMatch).line));
        } else {
            MessageHelper.EMSG("e_patnotf2", pattern);
        }
        return res;
    }

    private int getConfirmChoice(String match) {
        Object[] btns = this.getConfirmButtons();
        this.confirmDlg = new JOptionPane("Replace with " + match + " ?", 3, -1, null, btns, btns[0]);
        JDialog dlg = this.confirmDlg.createDialog(null, "Confirm Replace");
        dlg.setVisible(true);
        Object res = this.confirmDlg.getValue();
        this.confirmDlg = null;
        if (res == null) {
            return -1;
        }
        for (int i = 0; i < btns.length; ++i) {
            if (!btns[i].equals(res)) continue;
            return i;
        }
        return -1;
    }

    private boolean shouldIgnoreCase(String pattern, boolean noSmartCase) {
        boolean sc = !noSmartCase && Options.getInstance().isSet("smartcase");
        boolean ic = Options.getInstance().isSet("ignorecase");
        return ic && (!sc || !StringHelper.containsUpperCase(pattern));
    }

    public static int argsToFlags(String args) {
        int res = 0;
        boolean global = Options.getInstance().isSet("gdefault");
        block10: for (int i = 0; i < args.length(); ++i) {
            switch (args.charAt(i)) {
                case '&': {
                    res |= 1;
                    continue block10;
                }
                case 'c': {
                    res |= 2;
                    continue block10;
                }
                case 'e': {
                    res |= 4;
                    continue block10;
                }
                case 'g': {
                    global = !global;
                    continue block10;
                }
                case 'i': {
                    res |= 0x10;
                    continue block10;
                }
                case 'I': {
                    res |= 0x20;
                    continue block10;
                }
                case 'p': {
                    res |= 0x40;
                    continue block10;
                }
                case 'r': {
                    res |= 0x80;
                }
            }
        }
        if (global) {
            res |= 8;
        }
        return res;
    }

    private Object[] getConfirmButtons() {
        if (this.confirmBtns == null) {
            this.confirmBtns = new JButton[]{new JButton("Yes"), new JButton("No"), new JButton("All"), new JButton("Quit"), new JButton("Last")};
            this.confirmBtns[0].setMnemonic('Y');
            this.confirmBtns[1].setMnemonic('N');
            this.confirmBtns[2].setMnemonic('A');
            this.confirmBtns[3].setMnemonic('Q');
            this.confirmBtns[4].setMnemonic('L');
            for (int i = 0; i < this.confirmBtns.length; ++i) {
                this.confirmBtns[i].addActionListener(new ButtonActionListener(i));
            }
        }
        return this.confirmBtns;
    }

    public int search(Editor editor, DataPackage context, String command, int count, int flags, boolean moveCursor) {
        int res = this.search(editor, context, command, editor.getCaretModel().getOffset(), count, flags);
        if (res != -1 && moveCursor) {
            CommandGroups.getInstance().getMark().saveJumpLocation(editor, context);
            MotionGroup.moveCaret(editor, context, res);
        }
        return res;
    }

    public int search(Editor editor, DataPackage context, String command, int startOffset, int count, int flags) {
        int dir = 1;
        char type = '/';
        String pattern = this.lastSearch;
        String offset = this.lastOffset;
        if ((flags & 0x20000) != 0) {
            dir = -1;
            type = '?';
        }
        if (command.length() > 0) {
            if (command.charAt(0) != type) {
                CharPointer p = new CharPointer(command);
                CharPointer end = RegExp.skip_regexp(p.ref(0), type, true);
                pattern = p.substring(end.pointer() - p.pointer());
                if (logger.isDebugEnabled()) {
                    logger.debug("pattern=" + pattern);
                }
                if (p.charAt() != type) {
                    logger.debug("no offset");
                    offset = "";
                } else {
                    p.inc();
                    offset = p.toString();
                    if (logger.isDebugEnabled()) {
                        logger.debug("offset=" + offset);
                    }
                }
            } else if (command.length() == 1) {
                offset = "";
            } else {
                offset = command.substring(1);
                if (logger.isDebugEnabled()) {
                    logger.debug("offset=" + offset);
                }
            }
        }
        this.lastSearch = pattern;
        this.setLastPattern(editor, context, pattern);
        this.lastOffset = offset;
        this.lastDir = dir;
        if (logger.isDebugEnabled()) {
            logger.debug("lastSearch=" + this.lastSearch);
            logger.debug("lastOffset=" + this.lastOffset);
            logger.debug("lastDir=" + this.lastDir);
        }
        this.searchHighlight(false);
        return this.findItOffset(editor, context, startOffset, count, this.lastDir, false);
    }

    public int searchWord(Editor editor, DataPackage context, int count, boolean whole, int dir) {
        TextRange range = SearchHelper.findWordUnderCursor(editor);
        if (range == null) {
            return -1;
        }
        StringBuffer pattern = new StringBuffer();
        if (whole) {
            pattern.append("\\<");
        }
        pattern.append(EditorHelper.getText(editor, range.getStartOffset(), range.getEndOffset()));
        if (whole) {
            pattern.append("\\>");
        }
        MotionGroup.moveCaret(editor, context, range.getStartOffset());
        this.lastSearch = pattern.toString();
        this.setLastPattern(editor, context, this.lastSearch);
        this.lastOffset = "";
        this.lastDir = dir;
        this.searchHighlight(true);
        return this.findItOffset(editor, context, editor.getCaretModel().getOffset(), count, this.lastDir, true);
    }

    public int searchNext(Editor editor, DataPackage context, int count) {
        this.searchHighlight(false);
        return this.findItOffset(editor, context, editor.getCaretModel().getOffset(), count, this.lastDir, false);
    }

    public int searchPrevious(Editor editor, DataPackage context, int count) {
        this.searchHighlight(false);
        return this.findItOffset(editor, context, editor.getCaretModel().getOffset(), count, -this.lastDir, false);
    }

    public void updateHighlight() {
        if (!ApiHelper.supportsColorSchemes()) {
            return;
        }
        this.highlightSearch(false);
    }

    private void searchHighlight(boolean noSmartCase) {
        if (!ApiHelper.supportsColorSchemes()) {
            return;
        }
        this.showSearchHighlight = Options.getInstance().isSet("hlsearch");
        this.highlightSearch(noSmartCase);
    }

    private void highlightSearch(boolean noSmartCase) {
        Project[] projects;
        if (!ApiHelper.supportsColorSchemes()) {
            return;
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            Editor[] editors;
            Editor current = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            Editor[] editorArray = editors = current == null ? null : EditorFactory.getInstance().getEditors(current.getDocument(), project);
            if (editors == null) continue;
            for (Editor editor : editors) {
                String els = EditorData.getLastSearch(editor);
                if (!this.showSearchHighlight) {
                    SearchGroup.removeSearchHighlight(editor);
                    continue;
                }
                if (this.lastSearch != null && this.lastSearch.equals(els) || this.lastSearch == null) continue;
                SearchGroup.removeSearchHighlight(editor);
                SearchGroup.highlightSearchLines(editor, 0, -1, this.lastSearch, this.shouldIgnoreCase(this.lastSearch, noSmartCase));
                EditorData.setLastSearch(editor, this.lastSearch);
            }
        }
    }

    private void highlightSearchLines(Editor editor, boolean noSmartCase, int startLine, int endLine) {
        SearchGroup.highlightSearchLines(editor, startLine, endLine, this.lastSearch, this.shouldIgnoreCase(this.lastSearch, noSmartCase));
    }

    private static void highlightSearchLines(Editor editor, int startLine, int endLine, String text, boolean ic) {
        if (!ApiHelper.supportsColorSchemes()) {
            return;
        }
        TextAttributes color = editor.getColorsScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        Collection<RangeHighlighter> hls = EditorData.getLastHighlights(editor);
        if (hls == null) {
            hls = new ArrayList<RangeHighlighter>();
            EditorData.setLastHighlights(editor, hls);
        }
        int line2 = endLine == -1 ? EditorHelper.getLineCount(editor) : endLine;
        RegExp.regmmatch_T regmatch = new RegExp.regmmatch_T();
        RegExp sp = new RegExp();
        regmatch.regprog = sp.vim_regcomp(text, 1);
        if (regmatch.regprog == null) {
            return;
        }
        regmatch.rmm_ic = ic;
        int searchcol = 0;
        int lcount = EditorHelper.getLineCount(editor);
        int lnum = startLine;
        while (lnum <= line2) {
            int nmatch = sp.vim_regexec_multi(regmatch, editor, lcount, lnum, searchcol);
            if (nmatch > 0) {
                CharacterPosition startpos = new CharacterPosition(lnum + regmatch.startpos[0].lnum, regmatch.startpos[0].col);
                CharacterPosition endpos = new CharacterPosition(lnum + regmatch.endpos[0].lnum, regmatch.endpos[0].col);
                int startoff = EditorHelper.characterPositionToOffset(editor, startpos);
                int endoff = EditorHelper.characterPositionToOffset(editor, endpos);
                RangeHighlighter rh = SearchGroup.highlightMatch(editor, startoff, endoff);
                rh.setErrorStripeMarkColor(color.getBackgroundColor());
                rh.setErrorStripeTooltip((Object)text);
                hls.add(rh);
                lnum += nmatch - 1;
                searchcol = endpos.column;
                continue;
            }
            ++lnum;
            searchcol = 0;
        }
    }

    private int findItOffset(Editor editor, DataPackage context, int startOffset, int count, int dir, boolean noSmartCase) {
        boolean wrap = Options.getInstance().isSet("wrapscan");
        TextRange range = this.findIt(editor, startOffset, count, dir, noSmartCase, wrap, true, true);
        if (range == null) {
            return -1;
        }
        ParsePosition pp = new ParsePosition(0);
        int res = range.getStartOffset();
        if (this.lastOffset.length() == 0) {
            return range.getStartOffset();
        }
        if (Character.isDigit(this.lastOffset.charAt(0)) || this.lastOffset.charAt(0) == '+' || this.lastOffset.charAt(0) == '-') {
            int lineOffset = 0;
            if (this.lastOffset.equals("+")) {
                lineOffset = 1;
            } else if (this.lastOffset.equals("-")) {
                lineOffset = -1;
            } else {
                NumberFormat nf;
                Number num;
                if (this.lastOffset.charAt(0) == '+') {
                    this.lastOffset = this.lastOffset.substring(1);
                }
                if ((num = (nf = NumberFormat.getIntegerInstance()).parse(this.lastOffset, pp = new ParsePosition(0))) != null) {
                    lineOffset = num.intValue();
                }
            }
            int line = editor.offsetToLogicalPosition((int)range.getStartOffset()).line;
            int newLine = EditorHelper.normalizeLine(editor, line + lineOffset);
            res = CommandGroups.getInstance().getMotion().moveCaretToLineStart(editor, newLine);
        } else if ("ebs".indexOf(this.lastOffset.charAt(0)) != -1) {
            int charOffset = 0;
            if (this.lastOffset.length() >= 2) {
                NumberFormat nf;
                Number num;
                if ("+-".indexOf(this.lastOffset.charAt(1)) != -1) {
                    charOffset = 1;
                }
                if ((num = (nf = NumberFormat.getIntegerInstance()).parse(this.lastOffset, pp = new ParsePosition(this.lastOffset.charAt(1) == '+' ? 2 : 1))) != null) {
                    charOffset = num.intValue();
                }
            }
            int base = range.getStartOffset();
            if (this.lastOffset.charAt(0) == 'e') {
                base = range.getEndOffset() - 1;
            }
            res = Math.max(0, Math.min(base + charOffset, EditorHelper.getFileSize(editor) - 1));
        }
        int ppos = pp.getIndex();
        if (ppos < this.lastOffset.length() - 1 && this.lastOffset.charAt(ppos) == ';') {
            int flags;
            if (this.lastOffset.charAt(ppos + 1) == '/') {
                flags = 65536;
            } else if (this.lastOffset.charAt(ppos + 1) == '?') {
                flags = 131072;
            } else {
                return res;
            }
            if (this.lastOffset.length() - ppos > 2) {
                ++ppos;
            }
            res = this.search(editor, context, this.lastOffset.substring(ppos + 1), res, 1, flags);
            return res;
        }
        return res;
    }

    private TextRange findIt(Editor editor, int startOffset, int count, int dir, boolean noSmartCase, boolean wrap, boolean showMessages, boolean wholeFile) {
        int lnum;
        boolean found;
        TextRange res = null;
        if (this.lastSearch == null || this.lastSearch.length() == 0) {
            return res;
        }
        RegExp.regmmatch_T regmatch = new RegExp.regmmatch_T();
        regmatch.rmm_ic = this.shouldIgnoreCase(this.lastSearch, noSmartCase);
        RegExp sp = new RegExp();
        regmatch.regprog = sp.vim_regcomp(this.lastSearch, 1);
        if (regmatch == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("bad pattern: " + this.lastSearch);
            }
            return res;
        }
        CharacterPosition lpos = EditorHelper.offsetToCharacterPosition(editor, startOffset);
        RegExp.lpos_T pos = new RegExp.lpos_T();
        pos.lnum = lpos.line;
        pos.col = lpos.column;
        RegExp.lpos_T endpos = new RegExp.lpos_T();
        int extra_col = 1;
        int lineCount = EditorHelper.getLineCount(editor);
        int startLine = 0;
        int endLine = lineCount;
        block0: do {
            RegExp.lpos_T start_pos = new RegExp.lpos_T(pos);
            found = false;
            boolean at_first_line = true;
            if (pos.lnum == -1) {
                pos.lnum = 0;
                pos.col = 0;
                at_first_line = false;
            }
            if (dir == -1 && start_pos.col == 0) {
                lnum = pos.lnum - 1;
                at_first_line = false;
            } else {
                lnum = pos.lnum;
            }
            int lcount = EditorHelper.getLineCount(editor);
            for (int loop = 0; loop <= 1; ++loop) {
                if (!wholeFile) {
                    startLine = lnum;
                    endLine = lnum + 1;
                }
                while (lnum >= startLine && lnum < endLine) {
                    block26: {
                        block24: {
                            int startcol;
                            int first_lnum;
                            block27: {
                                int matchcol;
                                boolean match_ok;
                                CharPointer ptr;
                                long nmatched;
                                block25: {
                                    first_lnum = lnum;
                                    nmatched = sp.vim_regexec_multi(regmatch, editor, lcount, lnum, 0);
                                    if (nmatched <= 0L) break block24;
                                    ptr = new CharPointer(EditorHelper.getLineBuffer(editor, lnum += regmatch.startpos[0].lnum));
                                    startcol = regmatch.startpos[0].col;
                                    endpos = regmatch.endpos[0];
                                    if (dir != 1 || !at_first_line) break block25;
                                    match_ok = true;
                                    while (startcol - (startcol == ptr.strlen() ? 1 : 0) < start_pos.col + extra_col) {
                                        if (nmatched > 1L) {
                                            match_ok = false;
                                            break;
                                        }
                                        matchcol = endpos.col;
                                        if (matchcol == startcol && ptr.charAt(matchcol) != '\u0000') {
                                            ++matchcol;
                                        }
                                        if (ptr.charAt(matchcol) == '\u0000' || (nmatched = (long)sp.vim_regexec_multi(regmatch, editor, lcount, lnum, matchcol)) == 0L) {
                                            match_ok = false;
                                            break;
                                        }
                                        startcol = regmatch.startpos[0].col;
                                        endpos = regmatch.endpos[0];
                                        ptr = new CharPointer(EditorHelper.getLineBuffer(editor, lnum));
                                    }
                                    if (!match_ok) break block26;
                                }
                                if (dir != -1) break block27;
                                match_ok = false;
                                while (!at_first_line || regmatch.startpos[0].col + extra_col <= start_pos.col) {
                                    match_ok = true;
                                    startcol = regmatch.startpos[0].col;
                                    endpos = regmatch.endpos[0];
                                    if (nmatched > 1L) break;
                                    matchcol = endpos.col;
                                    if (matchcol == startcol && ptr.charAt(matchcol) != '\u0000') {
                                        ++matchcol;
                                    }
                                    if (ptr.charAt(matchcol) == '\u0000' || (nmatched = (long)sp.vim_regexec_multi(regmatch, editor, lcount, lnum, matchcol)) == 0L) break;
                                    ptr = new CharPointer(EditorHelper.getLineBuffer(editor, lnum));
                                }
                                if (!match_ok) break block26;
                            }
                            pos.lnum = lnum;
                            pos.col = startcol;
                            endpos.lnum += first_lnum;
                            found = true;
                            break;
                        }
                        if (loop != 0 && lnum == start_pos.lnum) break;
                    }
                    lnum += dir;
                    at_first_line = false;
                }
                at_first_line = false;
                if (!wrap || found) continue block0;
                lnum = dir == -1 ? lineCount - 1 : 0;
            }
        } while (--count > 0 && found);
        if (!found) {
            if (showMessages) {
                if (wrap) {
                    MessageHelper.EMSG("e_patnotf2", this.lastSearch);
                } else if (lnum <= 0) {
                    MessageHelper.EMSG("E384", this.lastSearch);
                } else {
                    MessageHelper.EMSG("E385", this.lastSearch);
                }
            }
            return null;
        }
        return new TextRange(EditorHelper.characterPositionToOffset(editor, new CharacterPosition(pos.lnum, pos.col)), EditorHelper.characterPositionToOffset(editor, new CharacterPosition(endpos.lnum, endpos.col)));
    }

    private RangeHighlighter highlightConfirm(Editor editor, int start, int end) {
        if (ApiHelper.supportsColorSchemes()) {
            TextAttributes color = new TextAttributes(editor.getColorsScheme().getColor(EditorColors.SELECTION_FOREGROUND_COLOR), editor.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR), null, null, 0);
            return editor.getMarkupModel().addRangeHighlighter(start, end, 3002, color, HighlighterTargetArea.EXACT_RANGE);
        }
        return editor.getMarkupModel().addRangeHighlighter(start, end, 6000, new TextAttributes(Color.BLACK, Color.YELLOW, null, null, 0), HighlighterTargetArea.EXACT_RANGE);
    }

    private static RangeHighlighter highlightMatch(Editor editor, int start, int end) {
        if (!ApiHelper.supportsColorSchemes()) {
            return null;
        }
        TextAttributes color = editor.getColorsScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        return editor.getMarkupModel().addRangeHighlighter(start, end, 3001, color, HighlighterTargetArea.EXACT_RANGE);
    }

    public void clearSearchHighlight(Editor editor, DataPackage context) {
        if (!ApiHelper.supportsColorSchemes()) {
            return;
        }
        this.showSearchHighlight = false;
        this.updateHighlight();
    }

    private static void removeSearchHighlight(Editor editor) {
        if (!ApiHelper.supportsColorSchemes()) {
            return;
        }
        Collection<RangeHighlighter> ehl = EditorData.getLastHighlights(editor);
        if (ehl == null) {
            return;
        }
        for (RangeHighlighter rh : ehl) {
            editor.getMarkupModel().removeHighlighter(rh);
        }
        ehl.clear();
        EditorData.setLastHighlights(editor, null);
        EditorData.setLastSearch(editor, null);
    }

    public void saveData(Element element) {
        CDATA data;
        Element text;
        logger.debug("saveData");
        Element search = new Element("search");
        if (this.lastSearch != null) {
            text = new Element("last-search");
            data = new CDATA(StringHelper.entities(this.lastSearch));
            text.addContent((Content)data);
            search.addContent(text);
        }
        if (this.lastOffset != null) {
            text = new Element("last-offset");
            data = new CDATA(StringHelper.entities(this.lastOffset));
            text.addContent((Content)data);
            search.addContent(text);
        }
        if (this.lastPattern != null) {
            text = new Element("last-pattern");
            data = new CDATA(StringHelper.entities(this.lastPattern));
            text.addContent((Content)data);
            search.addContent(text);
        }
        if (this.lastReplace != null) {
            text = new Element("last-replace");
            data = new CDATA(StringHelper.entities(this.lastReplace));
            text.addContent((Content)data);
            search.addContent(text);
        }
        if (this.lastSubstitute != null) {
            text = new Element("last-substitute");
            data = new CDATA(StringHelper.entities(this.lastSubstitute));
            text.addContent((Content)data);
            search.addContent(text);
        }
        text = new Element("last-dir");
        text.addContent(Integer.toString(this.lastDir));
        search.addContent(text);
        text = new Element("show-last");
        text.addContent(Boolean.toString(this.showSearchHighlight));
        if (logger.isDebugEnabled()) {
            logger.debug("text=" + text);
        }
        search.addContent(text);
        element.addContent(search);
    }

    public void readData(Element element) {
        logger.debug("readData");
        Element search = element.getChild("search");
        if (search == null) {
            return;
        }
        if (search.getChild("last-search") != null) {
            this.lastSearch = StringHelper.unentities(search.getChildText("last-search"));
        }
        if (search.getChild("last-offset") != null) {
            this.lastOffset = StringHelper.unentities(search.getChildText("last-offset"));
        }
        if (search.getChild("last-pattern") != null) {
            this.lastPattern = StringHelper.unentities(search.getChildText("last-pattern"));
        }
        if (search.getChild("last-replace") != null) {
            this.lastReplace = StringHelper.unentities(search.getChildText("last-replace"));
        }
        if (search.getChild("last-substitute") != null) {
            this.lastSubstitute = StringHelper.unentities(search.getChildText("last-substitute"));
        }
        Element dir = search.getChild("last-dir");
        this.lastDir = Integer.parseInt(dir.getText());
        Element show = search.getChild("show-last");
        this.showSearchHighlight = Boolean.valueOf(show.getText());
        if (logger.isDebugEnabled()) {
            logger.debug("show=" + show + "(" + show.getText() + ")");
            logger.debug("showSearchHighlight=" + this.showSearchHighlight);
        }
    }

    public static class DocumentSearchListener
    extends DocumentAdapter {
        public void documentChanged(DocumentEvent event) {
            Project[] projs;
            if (!VimPlugin.isEnabled()) {
                return;
            }
            for (Project proj : projs = ProjectManager.getInstance().getOpenProjects()) {
                Editor[] editors;
                for (Editor editor : editors = EditorFactory.getInstance().getEditors(event.getDocument(), proj)) {
                    Collection<RangeHighlighter> hls = EditorData.getLastHighlights(editor);
                    if (hls == null) continue;
                    int soff = event.getOffset();
                    int eoff = soff + event.getNewLength();
                    if (logger.isDebugEnabled()) {
                        logger.debug("hls=" + hls);
                        logger.debug("event=" + event);
                    }
                    Iterator<RangeHighlighter> iter = hls.iterator();
                    while (iter.hasNext()) {
                        RangeHighlighter rh = iter.next();
                        if (rh.isValid() && (eoff < rh.getStartOffset() || soff > rh.getEndOffset())) continue;
                        iter.remove();
                        editor.getMarkupModel().removeHighlighter(rh);
                    }
                    int sl = editor.offsetToLogicalPosition((int)soff).line;
                    int el = editor.offsetToLogicalPosition((int)eoff).line;
                    CommandGroups.getInstance().getSearch().highlightSearchLines(editor, false, sl, el);
                    hls = EditorData.getLastHighlights(editor);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("sl=" + sl + ", el=" + el);
                    logger.debug("hls=" + hls);
                }
            }
        }
    }

    public static class EditorSelectionCheck
    extends FileEditorManagerAdapter {
        public void selectionChanged(FileEditorManagerEvent event) {
            CommandGroups.getInstance().getSearch().updateHighlight();
        }
    }

    private class ButtonActionListener
    implements ActionListener {
        private int index;

        public ButtonActionListener(int i) {
            this.index = i;
        }

        public void actionPerformed(ActionEvent event) {
            if (SearchGroup.this.confirmDlg != null) {
                SearchGroup.this.confirmDlg.setValue(SearchGroup.this.confirmBtns[this.index]);
            }
        }
    }
}

