/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.handler;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandState;
import com.maddyhome.idea.vim.handler.DelegateActionHandler;
import com.maddyhome.idea.vim.helper.DataPackage;

public abstract class AbstractEditorActionHandler
extends EditorActionHandler {
    private static Logger logger = Logger.getInstance((String)AbstractEditorActionHandler.class.getName());

    public final void execute(Editor editor, DataContext dataContext) {
        this.execute(editor, new DataPackage(dataContext));
    }

    public final void execute(Editor editor, DataPackage context) {
        logger.debug("execute");
        if ((editor == null || !VimPlugin.isEnabled()) && this instanceof DelegateActionHandler) {
            KeyHandler.executeAction(((DelegateActionHandler)((Object)this)).getOrigAction(), context);
            return;
        }
        CommandState state = CommandState.getInstance(editor);
        Command cmd = state.getCommand();
        if (!this.execute(editor, context, cmd)) {
            VimPlugin.indicateError();
        }
    }

    public void process(Command cmd) {
    }

    protected abstract boolean execute(Editor var1, DataPackage var2, Command var3);
}

