/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.handler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandState;
import com.maddyhome.idea.vim.command.VisualChange;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.handler.AbstractEditorActionHandler;
import com.maddyhome.idea.vim.helper.DataPackage;
import com.maddyhome.idea.vim.helper.DelegateCommandListener;
import com.maddyhome.idea.vim.helper.EditorData;
import com.maddyhome.idea.vim.undo.UndoManager;

public abstract class VisualOperatorActionHandler
extends AbstractEditorActionHandler {
    private static Logger logger = Logger.getInstance((String)VisualOperatorActionHandler.class.getName());

    protected final boolean execute(Editor editor, DataPackage context, Command cmd) {
        if (logger.isDebugEnabled()) {
            logger.debug("execute, cmd=" + cmd);
        }
        TextRange range = null;
        if (CommandState.getInstance(editor).getMode() == 5) {
            range = CommandGroups.getInstance().getMotion().getVisualRange(editor);
            if (logger.isDebugEnabled()) {
                logger.debug("range=" + range);
            }
        }
        VisualStartFinishRunnable runnable = new VisualStartFinishRunnable(editor, context, cmd);
        if (cmd == null || (cmd.getFlags() & 0x800000) != 0) {
            DelegateCommandListener.getInstance().setRunnable(runnable);
        } else {
            range = runnable.start();
        }
        boolean res = this.execute(editor, context, cmd, range);
        if (cmd != null && (cmd.getFlags() & 0x800000) == 0) {
            runnable.setRes(res);
            runnable.finish();
        }
        return res;
    }

    protected abstract boolean execute(Editor var1, DataPackage var2, Command var3, TextRange var4);

    private static class VisualStartFinishRunnable
    implements DelegateCommandListener.StartFinishRunnable {
        private Command cmd;
        private Editor editor;
        private DataPackage context;
        private boolean res;
        private int lastMode;
        private boolean wasRepeat;
        private int lastColumn;
        VisualChange change = null;

        public VisualStartFinishRunnable(Editor editor, DataPackage context, Command cmd) {
            this.editor = editor;
            this.context = context;
            this.cmd = cmd;
            this.res = true;
        }

        public void setRes(boolean res) {
            this.res = res;
        }

        public TextRange start() {
            logger.debug("start");
            if (this.cmd == null || !this.cmd.isReadType()) {
                UndoManager.getInstance().endCommand(this.editor);
                UndoManager.getInstance().beginCommand(this.editor);
            }
            this.wasRepeat = false;
            if (CommandState.getInstance(this.editor).getMode() == 4) {
                this.wasRepeat = true;
                this.lastColumn = EditorData.getLastColumn(this.editor);
                VisualChange range = EditorData.getLastVisualOperatorRange(this.editor);
                CommandGroups.getInstance().getMotion().toggleVisual(this.editor, this.context, 1, 1, 0);
                if (range.getColumns() == 9999) {
                    EditorData.setLastColumn(this.editor, 9999);
                }
            }
            TextRange res = null;
            if (CommandState.getInstance(this.editor).getMode() == 5) {
                res = CommandGroups.getInstance().getMotion().getVisualRange(this.editor);
                if (!this.wasRepeat) {
                    this.change = CommandGroups.getInstance().getMotion().getVisualOperatorRange(this.editor, this.cmd == null ? 2 : this.cmd.getFlags());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("change=" + this.change);
                }
            }
            if (this.cmd != null && (this.cmd.getFlags() & 0x2000000) != 0) {
                logger.debug("multikey undo - exit visual");
                CommandGroups.getInstance().getMotion().exitVisual(this.editor);
            } else if (this.cmd != null && (this.cmd.getFlags() & 0x400000) != 0) {
                this.lastMode = CommandState.getInstance(this.editor).getSubMode();
                if (this.lastMode != 2 && (this.cmd.getFlags() & 0x200000) != 0) {
                    CommandGroups.getInstance().getMotion().toggleVisual(this.editor, this.context, 1, 0, 2);
                }
            }
            return res;
        }

        public void finish() {
            logger.debug("finish");
            if (this.cmd != null && (this.cmd.getFlags() & 0x400000) != 0 && this.lastMode != 2 && (this.cmd.getFlags() & 0x200000) != 0) {
                CommandGroups.getInstance().getMotion().toggleVisual(this.editor, this.context, 1, 0, this.lastMode);
            }
            if (this.cmd == null || (this.cmd.getFlags() & 0x2000000) == 0 && (this.cmd.getFlags() & 0x4000000) == 0) {
                logger.debug("not multikey undo - exit visual");
                if (this.cmd == null || (this.cmd.getFlags() & 0x100000) == 0) {
                    CommandGroups.getInstance().getMotion().exitVisual(this.editor);
                }
                if (this.wasRepeat) {
                    EditorData.setLastColumn(this.editor, this.lastColumn);
                }
            }
            if (this.res) {
                logger.debug("res");
                if (this.change != null) {
                    EditorData.setLastVisualOperatorRange(this.editor, this.change);
                }
                if (this.cmd == null || (this.cmd.getFlags() & 0x2000000) == 0 && !this.cmd.isReadType()) {
                    UndoManager.getInstance().endCommand(this.editor);
                    UndoManager.getInstance().beginCommand(this.editor);
                }
                if (this.cmd != null) {
                    CommandState.getInstance(this.editor).saveLastChangeCommand(this.cmd);
                }
            } else if (this.cmd == null || !this.cmd.isReadType()) {
                UndoManager.getInstance().abortCommand(this.editor);
                UndoManager.getInstance().beginCommand(this.editor);
            }
            if (this.cmd != null && (this.cmd.getFlags() & 0x800000) != 0) {
                KeyHandler.getInstance().reset(this.editor);
            }
        }
    }
}

