/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.handler.key;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.command.CommandState;
import com.maddyhome.idea.vim.helper.DataPackage;
import javax.swing.KeyStroke;

public class EditorKeyHandler
extends EditorActionHandler {
    protected EditorActionHandler origHandler;
    protected KeyStroke stroke;
    protected boolean special;
    private static Logger logger = Logger.getInstance((String)EditorKeyHandler.class.getName());

    public EditorKeyHandler(EditorActionHandler origHandler, KeyStroke stroke) {
        this(origHandler, stroke, false);
    }

    public EditorKeyHandler(EditorActionHandler origHandler, KeyStroke stroke, boolean special) {
        this.origHandler = origHandler;
        this.stroke = stroke;
        this.special = special;
    }

    public void execute(Editor editor, DataContext context) {
        logger.debug("execute");
        if (editor != null && VimPlugin.isEnabled()) {
            this.handle(editor, context);
        } else {
            this.original(editor, context);
        }
    }

    protected void original(Editor editor, DataContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("original for " + this.stroke);
            logger.debug("original is " + this.origHandler.getClass().getName());
            logger.debug("editor viewer=" + editor.isViewer());
            logger.debug("project=" + DataKeys.PROJECT.getData(context));
        }
        this.origHandler.execute(editor, context);
    }

    protected void handle(Editor editor, DataContext context) {
        KeyHandler.getInstance().handleKey(editor, this.stroke, new DataPackage(context));
    }

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        boolean res = true;
        if (editor == null || !VimPlugin.isEnabled()) {
            logger.debug("no editor or disabled");
            res = this.origHandler.isEnabled(editor, dataContext);
        } else if (DataKeys.VIRTUAL_FILE.getData(dataContext) == null) {
            logger.debug("no file");
            if (!this.special) {
                logger.debug("not special");
                res = this.origHandler.isEnabled(editor, dataContext);
            } else {
                int mode = CommandState.getInstance(editor).getMode();
                if (mode != 2 && mode != 3) {
                    logger.debug("not insert or replace");
                    res = this.origHandler.isEnabled(editor, dataContext);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("res=" + res);
        }
        return res;
    }
}

