/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.maddyhome.idea.vim.common.TextRange;

public class DelegateCommandListener
extends CommandAdapter {
    private boolean inCommand = false;
    private StartFinishRunnable runnable;
    private static Logger logger = Logger.getInstance((String)DelegateCommandListener.class.getName());
    private static DelegateCommandListener instance = new DelegateCommandListener();

    public static DelegateCommandListener getInstance() {
        return instance;
    }

    public void setRunnable(StartFinishRunnable runnable) {
        this.runnable = runnable;
        this.inCommand = false;
    }

    public StartFinishRunnable getRunnable() {
        return this.runnable;
    }

    public void commandStarted(CommandEvent event) {
        this.inCommand = true;
        if (logger.isDebugEnabled()) {
            logger.debug("Command started: " + event);
            logger.debug("Name: " + event.getCommandName());
            logger.debug("Group: " + event.getCommandGroupId());
        }
        if (this.runnable != null) {
            this.runnable.start();
        }
    }

    public void commandFinished(CommandEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("Command finished: " + event);
            logger.debug("Name: " + event.getCommandName());
            logger.debug("Group: " + event.getCommandGroupId());
        }
        if (this.runnable != null && this.inCommand) {
            this.runnable.finish();
            this.runnable = null;
        }
        this.inCommand = false;
    }

    private DelegateCommandListener() {
    }

    public static interface StartFinishRunnable {
        public TextRange start();

        public void finish();
    }
}

