/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.group.CommandGroups;
import com.maddyhome.idea.vim.helper.DataPackage;
import javax.swing.KeyStroke;

public class DigraphSequence {
    private int digraphState = 1;
    private char digraphChar;
    private char[] codeChars;
    private int codeCnt;
    private int codeType;
    private int codeMax;
    private static final int DIG_STATE_START = 1;
    private static final int DIG_STATE_DIG_ONE = 2;
    private static final int DIG_STATE_DIG_TWO = 3;
    private static final int DIG_STATE_CODE_START = 10;
    private static final int DIG_STATE_CODE_CHAR = 11;
    private static Logger logger = Logger.getInstance((String)DigraphSequence.class.getName());

    public static boolean isDigraphStart(KeyStroke key) {
        return (key.getModifiers() & 2) != 0 && (key.getKeyCode() == 75 || key.getKeyCode() == 86 || key.getKeyCode() == 81);
    }

    public DigraphResult processKey(KeyStroke key, Editor editor, DataPackage context) {
        switch (this.digraphState) {
            case 1: {
                logger.debug("DIG_STATE_START");
                if (key.getKeyCode() == 75 && (key.getModifiers() & 2) != 0) {
                    logger.debug("found Ctrl-K");
                    this.digraphState = 2;
                    return DigraphResult.OK;
                }
                if ((key.getKeyCode() == 86 || key.getKeyCode() == 81) && (key.getModifiers() & 2) != 0) {
                    logger.debug("found Ctrl-V");
                    this.digraphState = 10;
                    this.codeChars = new char[8];
                    this.codeCnt = 0;
                    return DigraphResult.OK;
                }
                return new DigraphResult(key);
            }
            case 2: {
                logger.debug("DIG_STATE_DIG_ONE");
                if (key.getKeyChar() != '\uffff') {
                    this.digraphChar = key.getKeyChar();
                    this.digraphState = 3;
                    return DigraphResult.OK;
                }
                this.digraphState = 1;
                return DigraphResult.BAD;
            }
            case 3: {
                logger.debug("DIG_STATE_DIG_TWO");
                this.digraphState = 1;
                if (key.getKeyChar() != '\uffff') {
                    char ch = CommandGroups.getInstance().getDigraph().getDigraph(this.digraphChar, key.getKeyChar());
                    return new DigraphResult(KeyStroke.getKeyStroke(ch));
                }
                return DigraphResult.BAD;
            }
            case 10: {
                logger.debug("DIG_STATE_CODE_START");
                switch (key.getKeyChar()) {
                    case 'O': 
                    case 'o': {
                        this.codeMax = 3;
                        this.digraphState = 11;
                        this.codeType = 8;
                        logger.debug("Octal");
                        return DigraphResult.OK;
                    }
                    case 'X': 
                    case 'x': {
                        this.codeMax = 2;
                        this.digraphState = 11;
                        this.codeType = 16;
                        logger.debug("hex2");
                        return DigraphResult.OK;
                    }
                    case 'u': {
                        this.codeMax = 4;
                        this.digraphState = 11;
                        this.codeType = 16;
                        logger.debug("hex4");
                        return DigraphResult.OK;
                    }
                    case 'U': {
                        this.codeMax = 8;
                        this.digraphState = 11;
                        this.codeType = 16;
                        logger.debug("hex8");
                        return DigraphResult.OK;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.codeMax = 3;
                        this.digraphState = 11;
                        this.codeType = 10;
                        this.codeChars[this.codeCnt++] = key.getKeyChar();
                        logger.debug("decimal");
                        return DigraphResult.OK;
                    }
                }
                switch (key.getKeyCode()) {
                    case 9: {
                        KeyStroke code = KeyStroke.getKeyStroke('\t');
                        this.digraphState = 1;
                        return new DigraphResult(code);
                    }
                }
                logger.debug("unknown");
                this.digraphState = 1;
                return new DigraphResult(key);
            }
            case 11: {
                logger.debug("DIG_STATE_CODE_CHAR");
                boolean valid = false;
                switch (this.codeType) {
                    case 10: {
                        if (key.getKeyChar() < '0' || key.getKeyChar() > '9') break;
                        valid = true;
                        break;
                    }
                    case 8: {
                        if (key.getKeyChar() < '0' || key.getKeyChar() > '7') break;
                        valid = true;
                        break;
                    }
                    case 16: {
                        if (!(key.getKeyChar() >= '0' && key.getKeyChar() <= '9' || key.getKeyChar() >= 'a' && key.getKeyChar() <= 'f') && (key.getKeyChar() < 'A' || key.getKeyChar() > 'F')) break;
                        valid = true;
                    }
                }
                if (valid) {
                    logger.debug("valid");
                    this.codeChars[this.codeCnt++] = key.getKeyChar();
                    if (this.codeCnt == this.codeMax) {
                        String digits = new String(this.codeChars, 0, this.codeCnt);
                        int val = Integer.parseInt(digits, this.codeType);
                        KeyStroke code = KeyStroke.getKeyStroke((char)val);
                        this.digraphState = 1;
                        return new DigraphResult(code);
                    }
                    return DigraphResult.OK;
                }
                if (this.codeCnt > 0) {
                    logger.debug("invalid");
                    String digits = new String(this.codeChars, 0, this.codeCnt);
                    int val = Integer.parseInt(digits, this.codeType);
                    this.digraphState = 1;
                    KeyStroke code = KeyStroke.getKeyStroke((char)val);
                    CommandGroups.getInstance().getMacro().postKey(key, editor);
                    return new DigraphResult(code);
                }
                return DigraphResult.BAD;
            }
        }
        return DigraphResult.BAD;
    }

    public static class DigraphResult {
        public static final int RES_OK = 0;
        public static final int RES_BAD = 1;
        public static final int RES_DONE = 2;
        public static final DigraphResult OK = new DigraphResult(0);
        public static final DigraphResult BAD = new DigraphResult(1);
        private int result;
        private KeyStroke stroke;

        DigraphResult(int result) {
            this.result = result;
            this.stroke = null;
        }

        DigraphResult(KeyStroke stroke) {
            this.result = 2;
            this.stroke = stroke;
        }

        public KeyStroke getStroke() {
            return this.stroke;
        }

        public int getResult() {
            return this.result;
        }
    }
}

