/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashSet;

public class DocumentManager {
    private HashSet<DocumentListener> docListeners = new HashSet();
    private static final Key<String> LISTENER_MARKER = new Key("listenerMarker");
    private static DocumentManager instance = new DocumentManager();
    private static Logger logger = Logger.getInstance((String)DocumentManager.class.getName());

    public static DocumentManager getInstance() {
        return instance;
    }

    public void init() {
        logger.debug("opening project");
    }

    public void addDocumentListener(DocumentListener listener) {
        this.docListeners.add(listener);
    }

    public void reloadDocument(Document doc, Project p) {
        logger.debug("marking as up-to-date");
        VirtualFile vf = FileDocumentManager.getInstance().getFile(doc);
        if (logger.isDebugEnabled()) {
            logger.debug("file=" + vf);
        }
        if (vf != null) {
            this.removeListeners(doc);
            FileDocumentManager.getInstance().reloadFromDisk(doc);
            FileStatusManager.getInstance((Project)p).fileStatusChanged(vf);
            this.addListeners(doc);
        }
    }

    public void addListeners(Document doc) {
        Object marker = doc.getUserData(LISTENER_MARKER);
        if (marker != null) {
            return;
        }
        doc.putUserData(LISTENER_MARKER, (Object)"foo");
        for (DocumentListener docListener : this.docListeners) {
            doc.addDocumentListener(docListener);
        }
    }

    public void removeListeners(Document doc) {
        Object marker = doc.getUserData(LISTENER_MARKER);
        if (marker == null) {
            return;
        }
        doc.putUserData(LISTENER_MARKER, null);
        for (DocumentListener docListener : this.docListeners) {
            doc.removeDocumentListener(docListener);
        }
    }

    private DocumentManager() {
    }

    private class FileDocumentListener
    extends FileDocumentManagerAdapter {
        private FileDocumentListener() {
        }

        public void fileContentLoaded(VirtualFile file, Document document) {
            if (logger.isDebugEnabled()) {
                logger.debug("loaded vf=" + file.getName());
            }
        }
    }
}

