/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.maddyhome.idea.vim.command.CommandState;
import com.maddyhome.idea.vim.command.VisualChange;
import com.maddyhome.idea.vim.command.VisualRange;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.undo.UndoManager;
import java.lang.reflect.Field;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorData {
    private static final Key<Integer> LAST_COLUMN = new Key("lastColumn");
    private static final Key<Project> PROJECT = new Key("project");
    private static final Key<VisualRange> VISUAL = new Key("lastVisual");
    private static final Key<VisualChange> VISUAL_OP = new Key("lastVisualOp");
    private static final Key<String> LAST_SEARCH = new Key("lastSearch");
    private static final Key<Collection<RangeHighlighter>> LAST_HIGHLIGHTS = new Key("lastHighlights");
    private static final Key<CommandState> COMMAND_STATE = new Key("commandState");
    private static final Key<Boolean> CHANGE_GROUP = new Key("changeGroup");
    private static final Key<Boolean> MOTION_GROUP = new Key("motionGroup");
    private static Key CONSOLE_OUTPUT = Key.create((String)"CONSOLE_VIEW_IN_EDITOR_VIEW");
    private static Logger logger = Logger.getInstance((String)EditorData.class.getName());

    public static void initializeEditor(Editor editor) {
        if (logger.isDebugEnabled()) {
            logger.debug("editor created: " + editor);
        }
        UndoManager.getInstance().editorOpened(editor);
    }

    public static void uninitializeEditor(Editor editor) {
        if (logger.isDebugEnabled()) {
            logger.debug("editor closed: " + editor);
        }
        UndoManager.getInstance().editorClosed(editor);
        editor.putUserData(COMMAND_STATE, null);
        editor.putUserData(LAST_HIGHLIGHTS, null);
        editor.putUserData(VISUAL, null);
        editor.putUserData(VISUAL_OP, null);
    }

    public static int getLastColumn(Editor editor) {
        Integer col = (Integer)editor.getUserData(LAST_COLUMN);
        if (col == null) {
            return EditorHelper.getCurrentVisualColumn(editor);
        }
        return col;
    }

    public static void setLastColumn(Editor editor, int col) {
        editor.putUserData(LAST_COLUMN, (Object)col);
        int t = EditorData.getLastColumn(editor);
        if (logger.isDebugEnabled()) {
            logger.debug("setLastColumn(" + col + ") is now " + t);
        }
    }

    public static String getLastSearch(Editor editor) {
        return (String)editor.getUserData(LAST_SEARCH);
    }

    public static void setLastSearch(Editor editor, String search) {
        editor.putUserData(LAST_SEARCH, (Object)search);
    }

    public static Collection<RangeHighlighter> getLastHighlights(Editor editor) {
        return (Collection)editor.getUserData(LAST_HIGHLIGHTS);
    }

    public static void setLastHighlights(Editor editor, Collection<RangeHighlighter> highlights) {
        editor.putUserData(LAST_HIGHLIGHTS, highlights);
    }

    public static VisualRange getLastVisualRange(Editor editor) {
        return (VisualRange)editor.getDocument().getUserData(VISUAL);
    }

    public static void setLastVisualRange(Editor editor, VisualRange range) {
        editor.getDocument().putUserData(VISUAL, (Object)range);
    }

    public static VisualChange getLastVisualOperatorRange(Editor editor) {
        return (VisualChange)editor.getDocument().getUserData(VISUAL_OP);
    }

    public static void setLastVisualOperatorRange(Editor editor, VisualChange range) {
        editor.getDocument().putUserData(VISUAL_OP, (Object)range);
    }

    public static CommandState getCommandState(Editor editor) {
        return (CommandState)editor.getUserData(COMMAND_STATE);
    }

    public static void setCommandState(Editor editor, CommandState state) {
        editor.putUserData(COMMAND_STATE, (Object)state);
    }

    public static boolean getChangeGroup(Editor editor) {
        Boolean res = (Boolean)editor.getUserData(CHANGE_GROUP);
        if (res != null) {
            return res;
        }
        return false;
    }

    public static void setChangeGroup(Editor editor, boolean adapter) {
        editor.putUserData(CHANGE_GROUP, (Object)adapter);
    }

    public static boolean getMotionGroup(Editor editor) {
        Boolean res = (Boolean)editor.getUserData(MOTION_GROUP);
        if (res != null) {
            return res;
        }
        return false;
    }

    public static void setMotionGroup(Editor editor, boolean adapter) {
        editor.putUserData(MOTION_GROUP, (Object)adapter);
    }

    public static boolean isConsoleOutput(Editor editor) {
        Object res = editor.getUserData(CONSOLE_OUTPUT);
        logger.debug("isConsoleOutput for editor " + editor + " - " + res);
        return res != null;
    }

    public static Project getProject(Editor editor) {
        Project proj = (Project)editor.getUserData(PROJECT);
        if (proj == null) {
            Project[] projs;
            block0: for (Project p : projs = ProjectManager.getInstance().getOpenProjects()) {
                Editor[] editors;
                for (Editor e : editors = EditorFactory.getInstance().getEditors(editor.getDocument(), p)) {
                    if (!e.equals(editor)) continue;
                    editor.putUserData(PROJECT, (Object)p);
                    proj = p;
                    continue block0;
                }
            }
        }
        return proj;
    }

    public static Project getProject(FileEditorManager mgr) {
        Project[] projs;
        for (Project proj : projs = ProjectManager.getInstance().getOpenProjects()) {
            FileEditorManager fem = FileEditorManager.getInstance((Project)proj);
            if (!fem.equals(mgr)) continue;
            return proj;
        }
        return null;
    }

    public static VirtualFile getVirtualFile(Editor editor) {
        return FileDocumentManager.getInstance().getFile(editor.getDocument());
    }

    private EditorData() {
    }

    static {
        try {
            Field[] flds;
            Class<?> cvi = Class.forName("com.intellij.execution.impl.ConsoleViewImpl");
            for (Field f : flds = cvi.getDeclaredFields()) {
                Key key;
                if (!f.getType().equals(Key.class)) continue;
                f.setAccessible(true);
                CONSOLE_OUTPUT = key = (Key)f.get(null);
                break;
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("ConsoleViewImpl not found");
        }
        catch (IllegalAccessException e) {
            logger.error("Can't access field 'c'");
        }
    }
}

