/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.maddyhome.idea.vim.common.CharacterPosition;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.helper.EditorData;
import java.awt.Point;
import java.awt.Rectangle;
import java.nio.CharBuffer;

public class EditorHelper {
    private static final Logger logger = Logger.getInstance((String)EditorHelper.class.getName());

    public static int getCurrentVisualLine(Editor editor) {
        return editor.getCaretModel().getVisualPosition().line;
    }

    public static int getCurrentVisualColumn(Editor editor) {
        return editor.getCaretModel().getVisualPosition().column;
    }

    public static int getCurrentLogicalLine(Editor editor) {
        return editor.getCaretModel().getLogicalPosition().line;
    }

    public static int getCurrentLogicalColumn(Editor editor) {
        return editor.getCaretModel().getLogicalPosition().column;
    }

    public static int getVisualLineAtTopOfScreen(Editor editor) {
        int lh = editor.getLineHeight();
        return (editor.getScrollingModel().getVerticalScrollOffset() + lh - 1) / lh;
    }

    public static int getCurrentVisualScreenLine(Editor editor) {
        return EditorHelper.getCurrentVisualLine(editor) - EditorHelper.getVisualLineAtTopOfScreen(editor) + 1;
    }

    public static int getLineLength(Editor editor) {
        int lline = EditorHelper.getCurrentLogicalLine(editor);
        return EditorHelper.getLineLength(editor, lline);
    }

    public static int getLineLength(Editor editor, int lline) {
        if (EditorHelper.getLineCount(editor) == 0) {
            return 0;
        }
        return Math.max(0, editor.offsetToLogicalPosition((int)editor.getDocument().getLineEndOffset((int)lline)).column);
    }

    public static int getVisualLineLength(Editor editor, int vline) {
        int lline = EditorHelper.visualLineToLogicalLine(editor, vline);
        return EditorHelper.getLineLength(editor, lline);
    }

    public static int getVisualLineCount(Editor editor) {
        int count = EditorHelper.getLineCount(editor);
        return count == 0 ? 0 : EditorHelper.logicalLineToVisualLine(editor, count - 1) + 1;
    }

    public static int getLineCount(Editor editor) {
        int len = editor.getDocument().getLineCount();
        if (editor.getDocument().getTextLength() > 0 && EditorHelper.getDocumentChars(editor).charAt(editor.getDocument().getTextLength() - 1) == '\n') {
            --len;
        }
        return len;
    }

    public static int getFileSize(Editor editor) {
        return EditorHelper.getFileSize(editor, false);
    }

    public static int getFileSize(Editor editor, boolean incEnd) {
        Document doc = editor.getDocument();
        int len = doc.getTextLength();
        if (!incEnd && len >= 1 && EditorHelper.getDocumentChars(editor).charAt(len - 1) == '\n') {
            --len;
        }
        return len;
    }

    public static int getScreenHeight(Editor editor) {
        int lh = editor.getLineHeight();
        int height = editor.getScrollingModel().getVisibleArea().y + editor.getScrollingModel().getVisibleArea().height - EditorHelper.getVisualLineAtTopOfScreen(editor) * lh;
        return height / lh;
    }

    public static int getScreenWidth(Editor editor) {
        Rectangle rect = editor.getScrollingModel().getVisibleArea();
        Point pt = new Point(rect.width, 0);
        VisualPosition vp = editor.xyToVisualPosition(pt);
        return vp.column;
    }

    public static int getColumnWidth(Editor editor) {
        Rectangle rect = editor.getScrollingModel().getVisibleArea();
        if (rect.width == 0) {
            return 0;
        }
        Point pt = new Point(rect.width, 0);
        VisualPosition vp = editor.xyToVisualPosition(pt);
        if (vp.column == 0) {
            return 0;
        }
        return rect.width / vp.column;
    }

    public static int getVisualColumnAtLeftOfScreen(Editor editor) {
        int cw = EditorHelper.getColumnWidth(editor);
        if (cw == 0) {
            return 0;
        }
        return (editor.getScrollingModel().getHorizontalScrollOffset() + cw - 1) / cw;
    }

    public static int visualLineToLogicalLine(Editor editor, int vline) {
        int lline = editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)vline, (int)0)).line;
        return EditorHelper.normalizeLine(editor, lline);
    }

    public static int logicalLineToVisualLine(Editor editor, int lline) {
        return editor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)lline, (int)0)).line;
    }

    public static int getLineStartOffset(Editor editor, int lline) {
        if (lline < 0) {
            return 0;
        }
        if (lline >= EditorHelper.getLineCount(editor)) {
            return EditorHelper.getFileSize(editor);
        }
        return editor.getDocument().getLineStartOffset(lline);
    }

    public static int getLineEndOffset(Editor editor, int lline, boolean incEnd) {
        if (lline < 0) {
            return 0;
        }
        if (lline >= EditorHelper.getLineCount(editor)) {
            return EditorHelper.getFileSize(editor, incEnd);
        }
        return editor.getDocument().getLineEndOffset(lline) - (incEnd ? 0 : 1);
    }

    public static int normalizeVisualLine(Editor editor, int vline) {
        vline = Math.max(0, Math.min(vline, EditorHelper.getVisualLineCount(editor) - 1));
        return vline;
    }

    public static int normalizeLine(Editor editor, int lline) {
        lline = Math.max(0, Math.min(lline, EditorHelper.getLineCount(editor) - 1));
        return lline;
    }

    public static int normalizeVisualColumn(Editor editor, int vline, int col, boolean allowEnd) {
        col = Math.max(0, Math.min(col, EditorHelper.getVisualLineLength(editor, vline) - (allowEnd ? 0 : 1)));
        return col;
    }

    public static int normalizeColumn(Editor editor, int lline, int col, boolean allowEnd) {
        col = Math.min(Math.max(0, EditorHelper.getLineLength(editor, lline) - (allowEnd ? 0 : 1)), col);
        return col;
    }

    public static int normalizeOffset(Editor editor, int lline, int offset, boolean allowEnd) {
        if (EditorHelper.getFileSize(editor, allowEnd) == 0) {
            return 0;
        }
        int min = EditorHelper.getLineStartOffset(editor, lline);
        int max = EditorHelper.getLineEndOffset(editor, lline, allowEnd);
        offset = Math.max(Math.min(offset, max), min);
        return offset;
    }

    public static int normalizeOffset(Editor editor, int offset, boolean allowEnd) {
        int lline = editor.offsetToLogicalPosition((int)offset).line;
        return EditorHelper.normalizeOffset(editor, lline, offset, allowEnd);
    }

    public static int getLeadingCharacterOffset(Editor editor, int lline) {
        return EditorHelper.getLeadingCharacterOffset(editor, lline, 0);
    }

    public static int getLeadingCharacterOffset(Editor editor, int lline, int col) {
        int start = EditorHelper.getLineStartOffset(editor, lline) + col;
        int end = EditorHelper.getLineEndOffset(editor, lline, true);
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int pos = end;
        for (int offset = start; offset < end && offset < chars.length(); ++offset) {
            if (Character.isWhitespace(chars.charAt(offset))) continue;
            pos = offset;
            break;
        }
        return pos;
    }

    public static String getLeadingWhitespace(Editor editor, int lline) {
        int start = EditorHelper.getLineStartOffset(editor, lline);
        int end = EditorHelper.getLeadingCharacterOffset(editor, lline);
        return ((Object)EditorHelper.getDocumentChars(editor).subSequence(start, end)).toString();
    }

    public static Editor getEditor(FileEditorManager manager, VirtualFile file) {
        if (file == null) {
            return null;
        }
        Document doc = FileDocumentManager.getInstance().getDocument(file);
        Editor[] editors = EditorFactory.getInstance().getEditors(doc, EditorData.getProject(manager));
        if (editors != null && editors.length > 0) {
            return editors[0];
        }
        return null;
    }

    public static int visualPostionToOffset(Editor editor, VisualPosition pos) {
        return editor.logicalPositionToOffset(editor.visualToLogicalPosition(pos));
    }

    public static String getText(Editor editor, int start, int end) {
        return ((Object)EditorHelper.getDocumentChars(editor).subSequence(start, end)).toString();
    }

    public static String getText(Editor editor, TextRange range) {
        int len = range.size();
        if (len == 1) {
            return EditorHelper.getText(editor, range.getStartOffset(), range.getEndOffset());
        }
        StringBuffer res = new StringBuffer();
        int max = range.getMaxLength();
        for (int i = 0; i < len; ++i) {
            String line;
            if (i > 0) {
                res.append('\n');
            }
            if ((line = EditorHelper.getText(editor, range.getStartOffsets()[i], range.getEndOffsets()[i])).length() == 0) {
                for (int j = 0; j < max; ++j) {
                    res.append(' ');
                }
                continue;
            }
            res.append(line);
        }
        return res.toString();
    }

    public static int getLineStartForOffset(Editor editor, int offset) {
        LogicalPosition pos = editor.offsetToLogicalPosition(offset);
        return editor.getDocument().getLineStartOffset(pos.line);
    }

    public static int getLineEndForOffset(Editor editor, int offset) {
        if (logger.isDebugEnabled()) {
            logger.debug("editor=" + editor);
        }
        LogicalPosition pos = editor.offsetToLogicalPosition(offset);
        return editor.getDocument().getLineEndOffset(pos.line);
    }

    public static int getLineCharCount(Editor editor, int lline) {
        return EditorHelper.getLineEndOffset(editor, lline, true) - EditorHelper.getLineStartOffset(editor, lline);
    }

    public static String getLineText(Editor editor, int lline) {
        return EditorHelper.getText(editor, EditorHelper.getLineStartOffset(editor, lline), EditorHelper.getLineEndOffset(editor, lline, true));
    }

    public static CharacterPosition offsetToCharacterPosition(Editor editor, int offset) {
        int line = editor.getDocument().getLineNumber(offset);
        int col = offset - editor.getDocument().getLineStartOffset(line);
        return new CharacterPosition(line, col);
    }

    public static int characterPositionToOffset(Editor editor, CharacterPosition pos) {
        return editor.getDocument().getLineStartOffset(pos.line) + pos.column;
    }

    public static CharBuffer getLineBuffer(Editor editor, int lline) {
        int start = EditorHelper.getLineStartOffset(editor, lline);
        return CharBuffer.wrap(EditorHelper.getDocumentChars(editor), start, start + EditorHelper.getLineCharCount(editor, lline));
    }

    public static boolean isLineEmpty(Editor editor, int lline, boolean allowBlanks) {
        int offset;
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        if (chars.charAt(offset = EditorHelper.getLineStartOffset(editor, lline)) == '\n') {
            return true;
        }
        if (allowBlanks) {
            while (offset < chars.length()) {
                if (chars.charAt(offset) == '\n') {
                    return true;
                }
                if (!Character.isWhitespace(chars.charAt(offset))) {
                    return false;
                }
                ++offset;
            }
        }
        return false;
    }

    public static String pad(Editor editor, int lline, int to) {
        StringBuffer res = new StringBuffer();
        int len = EditorHelper.getLineLength(editor, lline);
        if (logger.isDebugEnabled()) {
            logger.debug("lline=" + lline);
            logger.debug("len=" + len);
            logger.debug("to=" + to);
        }
        if (len < to) {
            for (int i = len; i < to; ++i) {
                res.append(' ');
            }
        }
        return res.toString();
    }

    public static CharSequence getDocumentChars(Editor editor) {
        return editor.getDocument().getCharsSequence();
    }

    public static boolean canEdit(Project project, Editor editor) {
        return (editor.getDocument().isWritable() || FileDocumentManager.fileForDocumentCheckedOutSuccessfully((Document)editor.getDocument(), (Project)project)) && !EditorData.isConsoleOutput(editor);
    }
}

