/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.maddyhome.idea.vim.helper.EditorData;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsiHelper {
    public static boolean isJavaFile(Editor editor) {
        PsiFile file = PsiHelper.getFile(editor);
        if (file == null) {
            return false;
        }
        return file instanceof PsiJavaFile;
    }

    public static int findMethodStart(Editor editor, int offset, int count) {
        return PsiHelper.findMethodOrClass(editor, offset, count, true);
    }

    public static int findMethodEnd(Editor editor, int offset, int count) {
        return PsiHelper.findMethodOrClass(editor, offset, count, false);
    }

    private static int findMethodOrClass(Editor editor, int offset, int count, boolean isStart) {
        PsiJavaFile file = (PsiJavaFile)PsiHelper.getFile(editor);
        int dir = count > 0 ? 1 : -1;
        count = Math.abs(count);
        int res = offset;
        for (int i = 0; i < count && (res = PsiHelper.scanClasses(file.getClasses(), res, dir, isStart)) != -1; ++i) {
        }
        return res;
    }

    private static int scanClasses(PsiClass[] classes, int offset, int dir, boolean isStart) {
        PsiJavaToken lbrace;
        PsiClass fclass = null;
        boolean inside = false;
        int closest = dir > 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        for (PsiClass clazz : classes) {
            PsiJavaToken lbrace2 = clazz.getLBrace();
            PsiJavaToken rbrace = clazz.getRBrace();
            if (lbrace2 == null || rbrace == null) continue;
            if (dir > 0) {
                if (offset >= lbrace2.getTextOffset() && offset < rbrace.getTextOffset()) {
                    fclass = clazz;
                    inside = true;
                    break;
                }
                if (offset >= lbrace2.getTextOffset() || lbrace2.getTextOffset() >= closest) continue;
                fclass = clazz;
                closest = lbrace2.getTextOffset();
                continue;
            }
            if (offset > lbrace2.getTextOffset() && offset <= rbrace.getTextOffset()) {
                fclass = clazz;
                inside = true;
                break;
            }
            if (offset <= rbrace.getTextOffset() || rbrace.getTextOffset() <= closest) continue;
            fclass = clazz;
            closest = rbrace.getTextOffset();
        }
        if (fclass == null) {
            return -1;
        }
        if (!inside) {
            lbrace = fclass.getLBrace();
            PsiJavaToken rbrace = fclass.getRBrace();
            if (lbrace == null || rbrace == null) {
                return -1;
            }
            return dir > 0 ? lbrace.getTextOffset() : rbrace.getTextOffset();
        }
        lbrace = fclass.getLBrace();
        PsiJavaToken rbrace = fclass.getRBrace();
        if (lbrace == null || rbrace == null) {
            return -1;
        }
        int res = PsiHelper.scanClass(fclass, offset, dir, isStart);
        if (res == -1) {
            res = dir > 0 ? rbrace.getTextOffset() : lbrace.getTextOffset();
        }
        return res;
    }

    private static int scanClass(PsiClass clazz, int offset, int dir, boolean isStart) {
        PsiClass[] classes;
        int closest = dir > 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        PsiMethod fmethod = null;
        PsiClass fclass = null;
        boolean inside = false;
        for (PsiClass aClass : classes = clazz.getInnerClasses()) {
            PsiJavaToken lbrace = aClass.getLBrace();
            PsiJavaToken rbrace = aClass.getRBrace();
            if (lbrace == null || rbrace == null) continue;
            if (dir > 0) {
                if (offset >= lbrace.getTextOffset() && offset < rbrace.getTextOffset()) {
                    fclass = aClass;
                    inside = true;
                    break;
                }
                if (offset >= lbrace.getTextOffset() || lbrace.getTextOffset() >= closest) continue;
                fclass = aClass;
                closest = lbrace.getTextOffset();
                continue;
            }
            if (offset > lbrace.getTextOffset() && offset <= rbrace.getTextOffset()) {
                fclass = aClass;
                inside = true;
                break;
            }
            if (offset <= rbrace.getTextOffset() || rbrace.getTextOffset() <= closest) continue;
            fclass = aClass;
            closest = rbrace.getTextOffset();
        }
        PsiMethod[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length && !inside; ++i) {
            int res;
            PsiJavaToken brace;
            PsiCodeBlock body = methods[i].getBody();
            if (body == null) continue;
            PsiJavaToken lbrace = body.getLBrace();
            PsiJavaToken rbrace = body.getRBrace();
            if (lbrace == null || rbrace == null) continue;
            PsiJavaToken psiJavaToken = brace = isStart ? lbrace : rbrace;
            if (dir > 0) {
                if (offset >= lbrace.getTextOffset() && offset <= rbrace.getTextOffset() && (res = PsiHelper.scanMethod(methods[i], offset, dir, isStart)) != -1) {
                    return res;
                }
                if (offset >= brace.getTextOffset() || brace.getTextOffset() >= closest) continue;
                fmethod = methods[i];
                closest = brace.getTextOffset();
                if (isStart || (res = PsiHelper.scanMethod(methods[i], offset, dir, isStart)) == -1) continue;
                closest = res;
                inside = true;
                continue;
            }
            if (offset >= lbrace.getTextOffset() && offset <= rbrace.getTextOffset() && (res = PsiHelper.scanMethod(methods[i], offset, dir, isStart)) != -1) {
                return res;
            }
            if (offset <= brace.getTextOffset() || brace.getTextOffset() <= closest) continue;
            fmethod = methods[i];
            closest = brace.getTextOffset();
            if (!isStart || (res = PsiHelper.scanMethod(methods[i], offset, dir, isStart)) == -1) continue;
            closest = res;
            inside = true;
        }
        if (fmethod == null && fclass == null) {
            return -1;
        }
        if (fmethod != null) {
            if (!inside) {
                PsiCodeBlock body = fmethod.getBody();
                if (body == null) {
                    return -1;
                }
                PsiJavaToken lbrace = body.getLBrace();
                PsiJavaToken rbrace = body.getRBrace();
                if (lbrace == null || rbrace == null) {
                    return -1;
                }
                return isStart ? lbrace.getTextOffset() : rbrace.getTextOffset();
            }
            return closest;
        }
        if (fclass != null) {
            if (!inside) {
                PsiJavaToken lbrace = fclass.getLBrace();
                PsiJavaToken rbrace = fclass.getRBrace();
                if (lbrace == null || rbrace == null) {
                    return -1;
                }
                return dir > 0 ? lbrace.getTextOffset() : rbrace.getTextOffset();
            }
            PsiJavaToken lbrace = fclass.getLBrace();
            PsiJavaToken rbrace = fclass.getRBrace();
            if (lbrace == null || rbrace == null) {
                return -1;
            }
            int res = PsiHelper.scanClass(fclass, offset, dir, isStart);
            if (res == -1) {
                res = dir > 0 ? rbrace.getTextOffset() : lbrace.getTextOffset();
            }
            return res;
        }
        return -1;
    }

    private static int scanMethod(PsiMethod fmethod, int offset, int dir, boolean start) {
        ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
        PsiHelper.findClasses((PsiElement)fmethod.getBody(), classes);
        if (classes.size() > 0) {
            return PsiHelper.scanClasses(classes.toArray(new PsiClass[0]), offset, dir, start);
        }
        return -1;
    }

    private static void findClasses(PsiElement element, List<PsiClass> classes) {
        PsiElement[] children;
        for (PsiElement child : children = element.getChildren()) {
            if (child instanceof PsiClass) {
                classes.add((PsiClass)child);
                return;
            }
            PsiHelper.findClasses(child, classes);
        }
    }

    private static PsiFile getFile(Editor editor) {
        VirtualFile vf = EditorData.getVirtualFile(editor);
        Project proj = EditorData.getProject(editor);
        PsiManager mgr = PsiManager.getInstance((Project)proj);
        return mgr.findFile(vf);
    }
}

