/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.maddyhome.idea.vim.KeyHandler;

public class RunnableHelper {
    private static Logger logger = Logger.getInstance((String)KeyHandler.class.getName());

    public static void runReadCommand(Project project, Runnable cmd, String name, Object groupId) {
        if (logger.isDebugEnabled()) {
            logger.debug("read command " + cmd);
        }
        CommandProcessor.getInstance().executeCommand(project, (Runnable)new ReadAction(cmd), name, groupId);
    }

    public static void runWriteCommand(Project project, Runnable cmd, String name, Object groupId) {
        if (logger.isDebugEnabled()) {
            logger.debug("write command " + cmd);
        }
        CommandProcessor.getInstance().executeCommand(project, (Runnable)new WriteAction(cmd), name, groupId);
    }

    private RunnableHelper() {
    }

    static class WriteAction
    implements Runnable {
        Runnable cmd;

        WriteAction(Runnable cmd) {
            this.cmd = cmd;
        }

        public void run() {
            ApplicationManager.getApplication().runWriteAction(this.cmd);
        }
    }

    static class ReadAction
    implements Runnable {
        Runnable cmd;

        ReadAction(Runnable cmd) {
            this.cmd = cmd;
        }

        public void run() {
            ApplicationManager.getApplication().runReadAction(this.cmd);
        }
    }
}

