/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.helper.CharacterHelper;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.PsiHelper;
import com.maddyhome.idea.vim.option.ListOption;
import com.maddyhome.idea.vim.option.OptionChangeEvent;
import com.maddyhome.idea.vim.option.OptionChangeListener;
import com.maddyhome.idea.vim.option.Options;
import java.util.List;

public class SearchHelper {
    private static String pairsChars = null;
    private static String blockChars = "{}()[]<>";
    private static Logger logger = Logger.getInstance((String)SearchHelper.class.getName());

    public static boolean anyNonWhitespace(Editor editor, int offset, int dir) {
        int end;
        int start;
        if (dir > 0) {
            start = offset + 1;
            end = EditorHelper.getLineEndForOffset(editor, offset);
        } else {
            start = EditorHelper.getLineStartForOffset(editor, offset);
            end = offset - 1;
        }
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        for (int i = start; i <= end; ++i) {
            if (Character.isWhitespace(chars.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static int findSection(Editor editor, char type, int dir, int count) {
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int maxline = EditorHelper.getLineCount(editor);
        int res = -1;
        for (int line = EditorHelper.getCurrentLogicalLine(editor) + dir; line > 0 && line < maxline && count > 0; line += dir) {
            int offset = EditorHelper.getLineStartOffset(editor, line);
            char ch = chars.charAt(offset);
            if (ch != type && ch != '\f') continue;
            res = offset;
            --count;
        }
        if (res == -1) {
            res = dir < 0 ? 0 : chars.length() - 1;
        }
        return res;
    }

    public static int findUnmatchedBlock(Editor editor, char type, int count) {
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int pos = editor.getCaretModel().getOffset();
        int loc = blockChars.indexOf(type);
        int dir = loc % 2 == 0 ? -1 : 1;
        char match = blockChars.charAt(loc);
        char found = blockChars.charAt(loc - dir);
        return SearchHelper.findBlockLocation(chars, found, match, dir, pos, count);
    }

    public static TextRange findBlockRange(Editor editor, char type, int count, boolean isOuter) {
        int loc;
        char close;
        int bstart;
        int end;
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int pos = editor.getCaretModel().getOffset();
        int start = editor.getSelectionModel().getSelectionStart();
        if (start != (end = editor.getSelectionModel().getSelectionEnd())) {
            pos = Math.min(start, end);
        }
        if ((bstart = SearchHelper.findBlockLocation(chars, close = blockChars.charAt((loc = blockChars.indexOf(type)) + 1), type, -1, pos, count)) == -1) {
            return null;
        }
        int bend = SearchHelper.findBlockLocation(chars, type, close, 1, bstart + 1, 1);
        if (!isOuter) {
            if (chars.charAt(++bstart) == '\n') {
                ++bstart;
            }
            int o = EditorHelper.getLineStartForOffset(editor, bend);
            boolean allWhite = true;
            for (int i = o; i < bend; ++i) {
                if (Character.isWhitespace(chars.charAt(i))) continue;
                allWhite = false;
                break;
            }
            bend = allWhite ? o - 2 : --bend;
        }
        return new TextRange(bstart, bend);
    }

    public static int findMatchingPairOnCurrentLine(Editor editor) {
        int pos;
        int line = EditorHelper.getCurrentLogicalLine(editor);
        int end = EditorHelper.getLineEndOffset(editor, line, true);
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int loc = -1;
        for (pos = editor.getCaretModel().getOffset(); pos < end && (loc = SearchHelper.getPairChars().indexOf(chars.charAt(pos))) < 0; ++pos) {
        }
        int res = -1;
        if (loc >= 0) {
            int dir = loc % 2 == 0 ? 1 : -1;
            char found = SearchHelper.getPairChars().charAt(loc);
            char match = SearchHelper.getPairChars().charAt(loc + dir);
            res = SearchHelper.findBlockLocation(chars, found, match, dir, pos, 1);
        }
        return res;
    }

    private static int findBlockLocation(CharSequence chars, char found, char match, int dir, int pos, int cnt) {
        int res = -1;
        boolean inString = SearchHelper.checkInString(chars, pos, true);
        boolean inChar = SearchHelper.checkInString(chars, pos, false);
        int stack = 0;
        pos += dir;
        while (pos >= 0 && pos < chars.length() && cnt > 0) {
            if (chars.charAt(pos) == match && !inString && !inChar) {
                if (stack == 0) {
                    res = pos;
                    --cnt;
                } else {
                    --stack;
                }
            } else if (chars.charAt(pos) == found && !inString && !inChar) {
                ++stack;
            } else if (!(inChar || chars.charAt(pos) != '\"' || pos != 0 && chars.charAt(pos - 1) == '\\')) {
                inString = !inString;
            } else if (!(inString || chars.charAt(pos) != '\'' || pos != 0 && chars.charAt(pos - 1) == '\\')) {
                inChar = !inChar;
            } else if (chars.charAt(pos) == '\n') {
                inString = false;
                inChar = false;
            }
            pos += dir;
        }
        return res;
    }

    private static boolean checkInString(CharSequence chars, int pos, boolean str) {
        for (int offset = pos; offset >= 0 && chars.charAt(offset) != '\n'; --offset) {
        }
        boolean inString = false;
        boolean inChar = false;
        for (int i = offset; i < pos; ++i) {
            if (!(inChar || chars.charAt(i) != '\"' || i != 0 && chars.charAt(i - 1) == '\\')) {
                inString = !inString;
                continue;
            }
            if (inString || chars.charAt(i) != '\'' || i != 0 && chars.charAt(i - 1) == '\\') continue;
            inChar = !inChar;
        }
        return str ? inString : inChar;
    }

    public static int findNextCamelStart(Editor editor, int count) {
        int step;
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int pos = editor.getCaretModel().getOffset();
        int size = EditorHelper.getFileSize(editor);
        int found = 0;
        int n = step = count >= 0 ? 1 : -1;
        if (pos < 0 || pos >= size) {
            return pos;
        }
        int res = pos;
        pos += step;
        while (pos >= 0 && pos < size && found < Math.abs(count)) {
            if (Character.isUpperCase(chars.charAt(pos))) {
                if (pos == 0 || !Character.isUpperCase(chars.charAt(pos - 1)) || pos == size - 1 || Character.isLowerCase(chars.charAt(pos + 1))) {
                    res = pos;
                    ++found;
                }
            } else if (Character.isLowerCase(chars.charAt(pos))) {
                if (pos == 0 || !Character.isLetter(chars.charAt(pos - 1))) {
                    res = pos;
                    ++found;
                }
            } else if (Character.isDigit(chars.charAt(pos)) && (pos == 0 || !Character.isDigit(chars.charAt(pos - 1)))) {
                res = pos;
                ++found;
            }
            pos += step;
        }
        if (found < Math.abs(count)) {
            res = -1;
        }
        return res;
    }

    public static int findNextCamelEnd(Editor editor, int count) {
        int step;
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int pos = editor.getCaretModel().getOffset();
        int size = EditorHelper.getFileSize(editor);
        int found = 0;
        int n = step = count >= 0 ? 1 : -1;
        if (pos < 0 || pos >= size) {
            return pos;
        }
        int res = pos;
        pos += step;
        while (pos >= 0 && pos < size && found < Math.abs(count)) {
            if (Character.isUpperCase(chars.charAt(pos))) {
                if (pos == size - 1 || !Character.isLetter(chars.charAt(pos + 1)) || Character.isUpperCase(chars.charAt(pos + 1)) && pos <= size - 2 && Character.isLowerCase(chars.charAt(pos + 2))) {
                    res = pos;
                    ++found;
                }
            } else if (Character.isLowerCase(chars.charAt(pos))) {
                if (pos == size - 1 || !Character.isLowerCase(chars.charAt(pos + 1))) {
                    res = pos;
                    ++found;
                }
            } else if (Character.isDigit(chars.charAt(pos)) && (pos == size - 1 || !Character.isDigit(chars.charAt(pos + 1)))) {
                res = pos;
                ++found;
            }
            pos += step;
        }
        if (found < Math.abs(count)) {
            res = -1;
        }
        return res;
    }

    public static CountPosition countWords(Editor editor) {
        int size = EditorHelper.getFileSize(editor);
        return SearchHelper.countWords(editor, 0, size);
    }

    public static CountPosition countWords(Editor editor, int start, int end) {
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int offset = editor.getCaretModel().getOffset();
        return SearchHelper.countWords(chars, start, end, offset);
    }

    public static CountPosition countWords(CharSequence chars, int start, int end, int offset) {
        int count = 1;
        int position = 0;
        int last = -1;
        int res = start;
        while ((res = SearchHelper.findNextWordOne(chars, res, end, 1, true, false)) != start && res != 0 && res <= end && res != last) {
            ++count;
            if (res == offset) {
                position = count;
            } else if (last < offset && res >= offset) {
                position = count == 2 && res > offset ? 1 : count - 1;
            }
            last = res;
        }
        if (position == 0 && res == offset) {
            position = count;
        }
        return new CountPosition(count, position);
    }

    public static int findNextWord(Editor editor, int count, boolean skipPunc) {
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int pos = editor.getCaretModel().getOffset();
        int size = EditorHelper.getFileSize(editor);
        return SearchHelper.findNextWord(chars, pos, size, count, skipPunc, false);
    }

    public static int findNextWord(CharSequence chars, int pos, int size, int count, boolean skipPunc, boolean spaceWords) {
        int step = count >= 0 ? 1 : -1;
        count = Math.abs(count);
        int res = pos;
        for (int i = 0; i < count && (res = SearchHelper.findNextWordOne(chars, res, size, step, skipPunc, spaceWords)) != pos && res != 0 && res != size - 1; ++i) {
        }
        return res;
    }

    private static int findNextWordOne(CharSequence chars, int pos, int size, int step, boolean skipPunc, boolean spaceWords) {
        boolean found = false;
        if (step < 0 && pos > 0) {
            if (CharacterHelper.charType(chars.charAt(pos - 1), skipPunc) == 3 && !spaceWords) {
                pos = SearchHelper.skipSpace(chars, pos - 1, step, size) + 1;
            }
            if (CharacterHelper.charType(chars.charAt(pos), skipPunc) != CharacterHelper.charType(chars.charAt(pos - 1), skipPunc)) {
                pos += step;
            }
        }
        int res = pos;
        if (pos < 0 || pos >= size) {
            return pos;
        }
        int type = CharacterHelper.charType(chars.charAt(pos), skipPunc);
        if (type == 3 && step < 0 && pos > 0 && !spaceWords) {
            type = CharacterHelper.charType(chars.charAt(pos - 1), skipPunc);
        }
        pos += step;
        while (pos >= 0 && pos < size && !found) {
            int newType = CharacterHelper.charType(chars.charAt(pos), skipPunc);
            if (newType != type) {
                res = newType == 3 && step >= 0 && !spaceWords ? (pos = SearchHelper.skipSpace(chars, pos, step, size)) : (step < 0 ? pos + 1 : pos);
                type = CharacterHelper.charType(chars.charAt(res), skipPunc);
                found = true;
            }
            pos += step;
        }
        if (found) {
            if (res < 0) {
                res = 0;
            } else if (res >= size) {
                res = size - 1;
            }
        } else if (pos <= 0) {
            res = 0;
        }
        return res;
    }

    public static TextRange findNumberUnderCursor(Editor editor, boolean alpha, boolean hex, boolean octal) {
        int start;
        int end;
        int lline = EditorHelper.getCurrentLogicalLine(editor);
        String text = EditorHelper.getLineText(editor, lline).toLowerCase();
        int offset = EditorHelper.getLineStartOffset(editor, lline);
        int pos = editor.getCaretModel().getOffset() - offset;
        if (logger.isDebugEnabled()) {
            logger.debug("lline=" + lline);
            logger.debug("text=" + text);
            logger.debug("offset=" + offset);
            logger.debug("pos=" + pos);
        }
        while (true) {
            int start2;
            int end2;
            boolean isHexChar;
            if (pos < text.length() && !SearchHelper.isNumberChar(text.charAt(pos), alpha, hex, octal, true)) {
                ++pos;
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("pos=" + pos);
            }
            if (pos >= text.length()) {
                logger.debug("no number char on line");
                return null;
            }
            boolean bl = isHexChar = "abcdefABCDEF".indexOf(text.charAt(pos)) >= 0;
            if (!hex) break;
            if (text.charAt(pos) == '0' && pos < text.length() - 1 && "xX".indexOf(text.charAt(pos + 1)) >= 0) {
                pos += 2;
            } else if ("xX".indexOf(text.charAt(pos)) < 0 || pos <= 0 || text.charAt(pos - 1) == '0') {
                // empty if block
            }
            logger.debug("checking hex");
            for (end2 = ++pos; end2 < text.length(); ++end2) {
                if (SearchHelper.isNumberChar(text.charAt(end2), false, true, false, false)) continue;
                --end2;
                break;
            }
            for (start2 = pos; start2 >= 0; --start2) {
                if (SearchHelper.isNumberChar(text.charAt(start2), false, true, false, false)) continue;
                ++start2;
                break;
            }
            if (start2 == -1) {
                start2 = 0;
            }
            if (start2 >= 2 && text.substring(start2 - 2, start2).toLowerCase().equals("0x")) {
                logger.debug("found hex");
                return new TextRange(start2 - 2 + offset, end2 + offset + 1);
            }
            if (!isHexChar || alpha) break;
            ++pos;
        }
        if (octal) {
            logger.debug("checking octal");
            for (end = pos; end < text.length(); ++end) {
                if (SearchHelper.isNumberChar(text.charAt(end), false, false, true, false)) continue;
                --end;
                break;
            }
            for (start = pos; start >= 0; --start) {
                if (SearchHelper.isNumberChar(text.charAt(start), false, false, true, false)) continue;
                ++start;
                break;
            }
            if (start == -1) {
                start = 0;
            }
            if (text.charAt(start) == '0' && end > start) {
                logger.debug("found octal");
                return new TextRange(start + offset, end + offset + 1);
            }
        }
        if (alpha) {
            if (logger.isDebugEnabled()) {
                logger.debug("checking alpha for " + text.charAt(pos));
            }
            if (SearchHelper.isNumberChar(text.charAt(pos), true, false, false, false)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("found alpha at " + pos);
                }
                return new TextRange(pos + offset, pos + offset + 1);
            }
        }
        for (end = pos; end < text.length(); ++end) {
            if (SearchHelper.isNumberChar(text.charAt(end), false, false, false, true)) continue;
            --end;
            break;
        }
        for (start = pos; start >= 0; --start) {
            if (SearchHelper.isNumberChar(text.charAt(start), false, false, false, true)) continue;
            ++start;
            break;
        }
        if (start == -1) {
            start = 0;
        }
        if (start > 0 && text.charAt(start - 1) == '-') {
            --start;
        }
        return new TextRange(start + offset, end + offset + 1);
    }

    private static boolean isNumberChar(char ch, boolean alpha, boolean hex, boolean octal, boolean decimal) {
        if (alpha && (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
            return true;
        }
        if (octal && ch >= '0' && ch <= '7') {
            return true;
        }
        if (hex && (ch >= '0' && ch <= '9' || "abcdefABCDEF".indexOf(ch) >= 0)) {
            return true;
        }
        return decimal && ch >= '0' && ch <= '9';
    }

    public static TextRange findWordUnderCursor(Editor editor) {
        int pos;
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int stop = EditorHelper.getLineEndOffset(editor, EditorHelper.getCurrentLogicalLine(editor), true);
        int start = pos = editor.getCaretModel().getOffset();
        int[] types = new int[]{1, 2};
        for (int i = 0; i < 2; ++i) {
            start = pos;
            int type = CharacterHelper.charType(chars.charAt(start), false);
            if (type == types[i]) {
                while (start > 0 && CharacterHelper.charType(chars.charAt(start - 1), false) == types[i]) {
                    --start;
                }
            } else {
                while (start < stop && CharacterHelper.charType(chars.charAt(start), false) != types[i]) {
                    ++start;
                }
            }
            if (start != stop) break;
        }
        if (start == stop) {
            return null;
        }
        int end = start < stop && CharacterHelper.charType(chars.charAt(start + 1), false) != 1 ? start + 1 : SearchHelper.findNextWordEnd(chars, start, stop, 1, false, false, false) + 1;
        return new TextRange(start, end);
    }

    public static TextRange findWordUnderCursor(Editor editor, int count, int dir, boolean isOuter, boolean isBig, boolean hasSelection) {
        boolean goForward;
        boolean goBack;
        boolean onWordEnd;
        int pos;
        if (logger.isDebugEnabled()) {
            logger.debug("count=" + count);
            logger.debug("dir=" + dir);
            logger.debug("isOuter=" + isOuter);
            logger.debug("isBig=" + isBig);
            logger.debug("hasSelection=" + hasSelection);
        }
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int min = 0;
        int max = EditorHelper.getFileSize(editor);
        if (logger.isDebugEnabled()) {
            logger.debug("min=" + min);
            logger.debug("max=" + max);
        }
        boolean startSpace = CharacterHelper.charType(chars.charAt(pos = editor.getCaretModel().getOffset()), isBig) == 3;
        boolean onWordStart = pos == min || CharacterHelper.charType(chars.charAt(pos - 1), isBig) != CharacterHelper.charType(chars.charAt(pos), isBig);
        int start = pos;
        if (logger.isDebugEnabled()) {
            logger.debug("pos=" + pos);
            logger.debug("onWordStart=" + onWordStart);
        }
        if (!onWordStart && (!startSpace || !isOuter) || hasSelection || count > 1 && dir == -1) {
            start = dir == 1 ? SearchHelper.findNextWord(chars, pos, max, -1, isBig, !isOuter) : SearchHelper.findNextWord(chars, pos, max, -(count - (onWordStart && !hasSelection ? 1 : 0)), isBig, !isOuter);
            start = EditorHelper.normalizeOffset(editor, start, false);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("start=" + start);
        }
        boolean bl = onWordEnd = pos == max || CharacterHelper.charType(chars.charAt(pos + 1), isBig) != CharacterHelper.charType(chars.charAt(pos), isBig);
        if (logger.isDebugEnabled()) {
            logger.debug("onWordEnd=" + onWordEnd);
        }
        int end = pos;
        if (!onWordEnd || hasSelection || count > 1 && dir == 1 || startSpace && isOuter) {
            end = dir == 1 ? SearchHelper.findNextWordEnd(chars, pos, max, count - (onWordEnd && !hasSelection && (!startSpace || !isOuter || startSpace && !isOuter) ? 1 : 0), isBig, true, !isOuter) : SearchHelper.findNextWordEnd(chars, pos, max, 1, isBig, true, !isOuter);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("end=" + end);
        }
        boolean bl2 = goBack = startSpace && !hasSelection || !startSpace && hasSelection && !onWordStart;
        if (dir == 1 && isOuter) {
            int firstEnd = end;
            if (count > 1) {
                firstEnd = SearchHelper.findNextWordEnd(chars, pos, max, 1, isBig, true, false);
            }
            if (firstEnd < max && CharacterHelper.charType(chars.charAt(firstEnd + 1), false) != 3) {
                goBack = true;
            }
        }
        if (dir == -1 && isOuter && startSpace && pos > min && CharacterHelper.charType(chars.charAt(pos - 1), false) != 3) {
            goBack = true;
        }
        boolean bl3 = goForward = dir == 1 && isOuter && (!startSpace && !onWordEnd || startSpace && onWordEnd && hasSelection);
        if (!goForward && dir == 1 && isOuter) {
            int firstEnd = end;
            if (count > 1) {
                firstEnd = SearchHelper.findNextWordEnd(chars, pos, max, 1, isBig, true, false);
            }
            if (firstEnd < max && CharacterHelper.charType(chars.charAt(firstEnd + 1), false) != 3) {
                goForward = true;
            }
        }
        if (!goForward && dir == 1 && isOuter && !startSpace && !hasSelection && end < max && CharacterHelper.charType(chars.charAt(end + 1), !isBig) != CharacterHelper.charType(chars.charAt(end), !isBig)) {
            goForward = true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("goBack=" + goBack);
            logger.debug("goForward=" + goForward);
        }
        if (goForward) {
            while (end < max && CharacterHelper.charType(chars.charAt(end + 1), false) == 3) {
                ++end;
            }
        }
        if (goBack) {
            while (start > min && CharacterHelper.charType(chars.charAt(start - 1), false) == 3) {
                --start;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("start=" + start);
            logger.debug("end=" + end);
        }
        return new TextRange(start, end);
    }

    public static int findNextWordEnd(Editor editor, int count, boolean skipPunc, boolean stayEnd) {
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int pos = editor.getCaretModel().getOffset();
        int size = EditorHelper.getFileSize(editor);
        return SearchHelper.findNextWordEnd(chars, pos, size, count, skipPunc, stayEnd, false);
    }

    public static int findNextWordEnd(CharSequence chars, int pos, int size, int count, boolean skipPunc, boolean stayEnd, boolean spaceWords) {
        int step = count >= 0 ? 1 : -1;
        count = Math.abs(count);
        int res = pos;
        for (int i = 0; i < count && (res = SearchHelper.findNextWordEndOne(chars, res, size, step, skipPunc, stayEnd, spaceWords)) != pos && res != 0 && res != size - 1; ++i) {
        }
        return res;
    }

    private static int findNextWordEndOne(CharSequence chars, int pos, int size, int step, boolean skipPunc, boolean stayEnd, boolean spaceWords) {
        boolean found = false;
        if (step > 0 && pos < size - 1) {
            if (CharacterHelper.charType(chars.charAt(pos + 1), skipPunc) == 3 && !spaceWords) {
                pos = SearchHelper.skipSpace(chars, pos + 1, step, size) - 1;
            }
            if (CharacterHelper.charType(chars.charAt(pos), skipPunc) != CharacterHelper.charType(chars.charAt(pos + 1), skipPunc)) {
                pos += step;
            }
        }
        int res = pos;
        if (pos < 0 || pos >= size) {
            return pos;
        }
        int type = CharacterHelper.charType(chars.charAt(pos), skipPunc);
        if (type == 3 && step >= 0 && pos < size - 1 && !spaceWords) {
            type = CharacterHelper.charType(chars.charAt(pos + 1), skipPunc);
        }
        pos += step;
        while (pos >= 0 && pos < size && !found) {
            int newType = CharacterHelper.charType(chars.charAt(pos), skipPunc);
            if (newType != type) {
                res = step >= 0 ? pos - 1 : (newType == 3 && step < 0 && !spaceWords ? (pos = SearchHelper.skipSpace(chars, pos, step, size)) : pos);
                found = true;
            }
            pos += step;
        }
        if (found) {
            if (res < 0) {
                res = 0;
            } else if (res >= size) {
                res = size - 1;
            }
        } else if (pos == size) {
            res = size - 1;
        }
        return res;
    }

    public static int skipSpace(CharSequence chars, int offset, int step, int size) {
        while (offset >= 0 && offset < size && CharacterHelper.charType(chars.charAt(offset), false) == 3) {
            offset += step;
        }
        return offset;
    }

    public static int findNextCharacterOnLine(Editor editor, int count, char ch) {
        int pos;
        int line = EditorHelper.getCurrentLogicalLine(editor);
        int start = EditorHelper.getLineStartOffset(editor, line);
        int end = EditorHelper.getLineEndOffset(editor, line, true);
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int found = 0;
        int step = count >= 0 ? 1 : -1;
        for (pos = editor.getCaretModel().getOffset() + step; pos >= start && pos < end && pos >= 0 && pos < chars.length() && (chars.charAt(pos) != ch || ++found != Math.abs(count)); pos += step) {
        }
        if (found == Math.abs(count)) {
            return pos;
        }
        return -1;
    }

    public static int findNextSentenceStart(Editor editor, int count, boolean countCurrent, boolean requireAll) {
        int dir = count > 0 ? 1 : -1;
        int total = count = Math.abs(count);
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int start = editor.getCaretModel().getOffset();
        int max = EditorHelper.getFileSize(editor);
        int res = start;
        while (count > 0 && res >= 0 && res <= max - 1) {
            if ((res = SearchHelper.findSentenceStart(editor, chars, res, max, dir, countCurrent, count > 1)) == 0 || res == max - 1) {
                --count;
                break;
            }
            --count;
        }
        if (!(res >= 0 || requireAll && total != 1)) {
            res = dir > 0 ? max - 1 : 0;
        } else if (count > 0 && total > 1 && !requireAll) {
            res = dir > 0 ? max - 1 : 0;
        } else if (count > 0 && total > 1 && requireAll) {
            res = -count;
        }
        return res;
    }

    public static int findNextSentenceEnd(Editor editor, int count, boolean countCurrent, boolean requireAll) {
        int dir = count > 0 ? 1 : -1;
        int total = count = Math.abs(count);
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int start = editor.getCaretModel().getOffset();
        int max = EditorHelper.getFileSize(editor);
        int res = start;
        while (count > 0 && res >= 0 && res <= max - 1) {
            if ((res = SearchHelper.findSentenceEnd(editor, chars, res, max, dir, countCurrent && count == total, count > 1)) == 0 || res == max - 1) {
                --count;
                break;
            }
            --count;
        }
        if (!(res >= 0 || requireAll && total != 1)) {
            res = dir > 0 ? max - 1 : 0;
        } else if (count > 0 && total > 1 && !requireAll) {
            res = dir > 0 ? max - 1 : 0;
        } else if (count > 0 && total > 1 && requireAll) {
            res = -count;
        }
        return res;
    }

    private static int findSentenceStart(Editor editor, CharSequence chars, int start, int max, int dir, boolean countCurrent, boolean multiple) {
        int res;
        char ch;
        int lline = editor.offsetToLogicalPosition((int)start).line;
        int np = SearchHelper.findNextParagraph(editor, lline, dir, false, multiple);
        int end = chars.charAt(start) == '\n' && !countCurrent ? SearchHelper.findSentenceEnd(editor, chars, start, max, -1, false, multiple) : SearchHelper.findSentenceEnd(editor, chars, start, max, -1, true, multiple);
        if (end == start && countCurrent && chars.charAt(end) == '\n') {
            return end;
        }
        int pos = end - 1;
        if (end >= 0) {
            int offset;
            for (offset = end + 1; offset < max && Character.isWhitespace(ch = chars.charAt(offset)); ++offset) {
            }
            if (dir > 0) {
                if (offset == start && countCurrent) {
                    return offset;
                }
                if (offset > start) {
                    return offset;
                }
            } else {
                if (offset == start && countCurrent) {
                    return offset;
                }
                if (offset < start) {
                    return offset;
                }
            }
        }
        end = dir > 0 ? SearchHelper.findSentenceEnd(editor, chars, start, max, dir, true, multiple) : SearchHelper.findSentenceEnd(editor, chars, pos, max, dir, countCurrent, multiple);
        if (!(end == -1 || chars.charAt(end) == '\n' && countCurrent)) {
            for (res = end + 1; res < max && Character.isWhitespace(ch = chars.charAt(res)); ++res) {
            }
        }
        if (res >= 0 && np >= 0) {
            if (dir > 0) {
                if (np < res || res < start) {
                    res = np;
                }
            } else if (np > res || res >= start && !countCurrent) {
                res = np;
            }
        } else if (res == -1 && np >= 0) {
            res = np;
        }
        return res;
    }

    private static int findSentenceEnd(Editor editor, CharSequence chars, int start, int max, int dir, boolean countCurrent, boolean multiple) {
        if (dir > 0 && start >= EditorHelper.getFileSize(editor) - 1) {
            return -1;
        }
        if (dir < 0 && start <= 0) {
            return -1;
        }
        int lline = editor.offsetToLogicalPosition((int)start).line;
        int np = SearchHelper.findNextParagraph(editor, lline, dir, false, multiple);
        int res = -1;
        boolean found = false;
        for (int offset = start; offset >= 0 && offset < max && !found; offset += dir) {
            int end;
            char ch = chars.charAt(offset);
            if (".!?".indexOf(ch) >= 0) {
                end = offset++;
                while (offset < max && ")]\"'".indexOf(ch = chars.charAt(offset)) != -1) {
                    ++offset;
                }
                if (offset >= max || Character.isWhitespace(ch)) {
                    if (offset - 1 == start && !countCurrent) {
                        offset = end;
                        continue;
                    }
                    res = offset - 1;
                    found = true;
                    continue;
                }
                offset = end;
                continue;
            }
            if (ch == '\n') {
                end = offset++;
                if (dir > 0) {
                    while (offset < max) {
                        ch = chars.charAt(offset);
                        if (ch != '\n') {
                            --offset;
                            break;
                        }
                        if (offset == np && (end - 1 != start || countCurrent)) break;
                        ++offset;
                    }
                    if (offset == np && (end - 1 != start || countCurrent)) {
                        res = end - 1;
                        found = true;
                    } else if (offset > end) {
                        np = res = offset;
                        found = true;
                    } else if (offset == end && offset > 0 && chars.charAt(offset - 1) == '\n' && countCurrent) {
                        np = res = end;
                        found = true;
                    }
                } else {
                    --offset;
                    while (offset >= 0) {
                        ch = chars.charAt(offset);
                        if (ch != '\n') {
                            ++offset;
                            break;
                        }
                        --offset;
                    }
                    if (offset < end) {
                        res = end == start && countCurrent ? end : offset - 1;
                        found = true;
                    }
                }
                offset = end;
                continue;
            }
            if (ch != '\f') continue;
            res = offset;
            found = true;
        }
        if (res >= 0 && np >= 0) {
            if (dir > 0) {
                if (np < res || res < start) {
                    res = np;
                }
            } else if (np > res || res >= start && !countCurrent) {
                res = np;
            }
        }
        return res;
    }

    private static int findSentenceRangeEnd(Editor editor, CharSequence chars, int start, int max, int count, boolean isOuter, boolean oneway) {
        int which;
        int dir = count > 0 ? 1 : -1;
        int total = count = Math.abs(count);
        boolean toggle = !isOuter;
        boolean findend = dir < 1;
        int eprev = SearchHelper.findSentenceEnd(editor, chars, start, max, -1, true, false);
        int enext = SearchHelper.findSentenceEnd(editor, chars, start, max, 1, true, false);
        int sprev = SearchHelper.findSentenceStart(editor, chars, start, max, -1, true, false);
        int snext = SearchHelper.findSentenceStart(editor, chars, start, max, 1, true, false);
        if (snext == eprev) {
            if (dir < 0 && !oneway) {
                return start;
            }
            which = 0;
            if (oneway) {
                findend = dir > 0;
            } else if (dir > 0 && start < max - 1 && !Character.isSpaceChar(chars.charAt(start + 1))) {
                findend = true;
            }
        } else if (start == snext) {
            if (dir < 0 && !oneway) {
                return start;
            }
            int n = which = dir > 0 ? 1 : 0;
            if (dir < 0 && oneway) {
                findend = false;
            }
        } else if (start == enext) {
            if (dir > 0 && !oneway) {
                return start;
            }
            which = 0;
            if (dir > 0 && oneway) {
                findend = true;
            }
        } else if (start >= sprev && start <= enext && enext < snext) {
            which = dir > 0 ? 1 : 0;
        } else {
            int n = which = dir > 0 ? 0 : 1;
            if (dir > 0) {
                if (oneway) {
                    if (start < snext - 1) {
                        findend = true;
                    } else if (start == snext - 1) {
                        ++count;
                    }
                } else {
                    findend = true;
                }
            } else if (oneway) {
                if (start > eprev + 1) {
                    findend = false;
                } else if (start == eprev + 1) {
                    ++count;
                }
            } else {
                findend = true;
            }
        }
        int res = start;
        while (count > 0 && res >= 0 && res <= max - 1) {
            res = toggle && which % 2 == 1 || isOuter && findend ? SearchHelper.findSentenceEnd(editor, chars, res, max, dir, false, total > 1) : SearchHelper.findSentenceStart(editor, chars, res, max, dir, false, total > 1);
            if (res == 0 || res == max - 1) {
                --count;
                break;
            }
            if (toggle) {
                if (which % 2 == 1 && dir < 0) {
                    ++res;
                } else if (which % 2 == 0 && dir > 0) {
                    --res;
                }
            }
            ++which;
            --count;
        }
        if (res < 0 || count > 0) {
            res = dir > 0 ? max - 1 : 0;
        } else if (isOuter && (dir < 0 && findend || dir > 0 && !findend) && res != 0 && res != max - 1) {
            res -= dir;
        }
        if (chars.charAt(res) == '\n' && res > 0 && chars.charAt(res - 1) != '\n') {
            --res;
        }
        return res;
    }

    public static TextRange findSentenceRange(Editor editor, int count, boolean isOuter) {
        CharSequence chars = EditorHelper.getDocumentChars(editor);
        int max = EditorHelper.getFileSize(editor);
        int offset = editor.getCaretModel().getOffset();
        int ssel = editor.getSelectionModel().getSelectionStart();
        int esel = editor.getSelectionModel().getSelectionEnd();
        if (Math.abs(esel - ssel) > 1) {
            if (offset == esel - 1) {
                int start = ssel;
                int end = SearchHelper.findSentenceRangeEnd(editor, chars, offset, max, count, isOuter, true);
                return new TextRange(start, end);
            }
            int end = esel - 1;
            int start = SearchHelper.findSentenceRangeEnd(editor, chars, offset, max, -count, isOuter, true);
            return new TextRange(end, start);
        }
        int end = SearchHelper.findSentenceRangeEnd(editor, chars, offset, max, count, isOuter, false);
        boolean space = isOuter;
        if (Character.isSpaceChar(chars.charAt(end))) {
            space = false;
        }
        int start = SearchHelper.findSentenceRangeEnd(editor, chars, offset, max, -1, space, false);
        return new TextRange(start, end);
    }

    public static int findNextParagraph(Editor editor, int count, boolean allowBlanks) {
        int line = SearchHelper.findNextParagraphLine(editor, count, allowBlanks);
        int maxline = EditorHelper.getLineCount(editor);
        if (line >= 0 && line < maxline) {
            return EditorHelper.getLineStartOffset(editor, line);
        }
        if (line == maxline) {
            return count > 0 ? EditorHelper.getFileSize(editor) - 1 : 0;
        }
        return -1;
    }

    private static int findNextParagraph(Editor editor, int lline, int dir, boolean allowBlanks, boolean skipLines) {
        int line = SearchHelper.findNextParagraphLine(editor, lline, dir, allowBlanks, skipLines);
        if (line >= 0) {
            return EditorHelper.getLineStartOffset(editor, line);
        }
        return dir > 0 ? EditorHelper.getFileSize(editor) - 1 : 0;
    }

    private static int findNextParagraphLine(Editor editor, int count, boolean allowBlanks) {
        int line = EditorHelper.getCurrentLogicalLine(editor);
        int maxline = EditorHelper.getLineCount(editor);
        int dir = count > 0 ? 1 : -1;
        boolean skipLines = count > 1;
        int total = count = Math.abs(count);
        while (count > 0 && line >= 0) {
            line = SearchHelper.findNextParagraphLine(editor, line, dir, allowBlanks, skipLines);
            --count;
        }
        if (total == 1 && line < 0) {
            line = dir > 0 ? maxline - 1 : 0;
        } else if (total > 1 && count == 0 && line < 0) {
            line = dir > 0 ? maxline - 1 : 0;
        }
        return line;
    }

    private static int findNextParagraphLine(Editor editor, int line, int dir, boolean allowBlanks, boolean skipLines) {
        int maxline = EditorHelper.getLineCount(editor);
        int res = -1;
        for (line = SearchHelper.skipEmptyLines(editor, line, dir, allowBlanks); line >= 0 && line < maxline && res == -1; line += dir) {
            if (!EditorHelper.isLineEmpty(editor, line, allowBlanks)) continue;
            res = line;
            if (!skipLines) continue;
            line = SearchHelper.skipEmptyLines(editor, line, dir, allowBlanks);
        }
        return res;
    }

    private static int skipEmptyLines(Editor editor, int line, int dir, boolean allowBlanks) {
        int maxline = EditorHelper.getLineCount(editor);
        while (line >= 0 && line < maxline) {
            if (!EditorHelper.isLineEmpty(editor, line, allowBlanks)) {
                return line;
            }
            line += dir;
        }
        return line;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TextRange findParagraphRange(Editor editor, int count, boolean isOuter) {
        int eline;
        int sline;
        int line = EditorHelper.getCurrentLogicalLine(editor);
        int maxline = EditorHelper.getLineCount(editor);
        if (logger.isDebugEnabled()) {
            logger.debug("starting on line " + line);
        }
        boolean fixstart = false;
        boolean fixend = false;
        if (isOuter) {
            sline = EditorHelper.isLineEmpty(editor, line, true) ? line : SearchHelper.findNextParagraphLine(editor, -1, true);
            eline = SearchHelper.findNextParagraphLine(editor, count, true);
            if (eline < 0) {
                return null;
            }
            if (EditorHelper.isLineEmpty(editor, sline, true) && EditorHelper.isLineEmpty(editor, eline, true)) {
                if (sline == line) {
                    --eline;
                    fixstart = true;
                } else {
                    ++sline;
                    fixend = true;
                }
            } else if (!EditorHelper.isLineEmpty(editor, eline, true) && !EditorHelper.isLineEmpty(editor, sline, true) && sline > 0) {
                --sline;
                fixstart = true;
            } else if (EditorHelper.isLineEmpty(editor, eline, true)) {
                fixend = true;
            } else if (EditorHelper.isLineEmpty(editor, sline, true)) {
                fixstart = true;
            }
        } else {
            sline = line;
            if (!EditorHelper.isLineEmpty(editor, sline, true)) {
                sline = SearchHelper.findNextParagraphLine(editor, -1, true);
                if (EditorHelper.isLineEmpty(editor, sline, true)) {
                    ++sline;
                }
                eline = line;
            } else {
                eline = line - 1;
            }
            int which = EditorHelper.isLineEmpty(editor, sline, true) ? 0 : 1;
            for (int i = 0; i < count; ++i) {
                if (which % 2 == 1) {
                    if ((eline = SearchHelper.findNextParagraphLine(editor, eline, 1, true, false) - 1) < 0) {
                        if (i != count - 1) return null;
                        eline = maxline - 1;
                    }
                } else {
                    ++eline;
                }
                ++which;
            }
            fixstart = true;
            fixend = true;
        }
        if (fixstart && EditorHelper.isLineEmpty(editor, sline, true)) {
            while (sline > 0 && EditorHelper.isLineEmpty(editor, sline - 1, true)) {
                --sline;
            }
        }
        if (fixend && EditorHelper.isLineEmpty(editor, eline, true)) {
            while (eline < maxline - 1 && EditorHelper.isLineEmpty(editor, eline + 1, true)) {
                ++eline;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("final sline=" + sline);
            logger.debug("final eline=" + eline);
        }
        int start = EditorHelper.getLineStartOffset(editor, sline);
        int end = EditorHelper.getLineStartOffset(editor, eline);
        return new TextRange(start, end);
    }

    public static int findMethodStart(Editor editor, int count) {
        if (PsiHelper.isJavaFile(editor)) {
            return PsiHelper.findMethodStart(editor, editor.getCaretModel().getOffset(), count);
        }
        return -1;
    }

    public static int findMethodEnd(Editor editor, int count) {
        if (PsiHelper.isJavaFile(editor)) {
            return PsiHelper.findMethodEnd(editor, editor.getCaretModel().getOffset(), count);
        }
        return -1;
    }

    private static String getPairChars() {
        if (pairsChars == null) {
            ListOption lo = (ListOption)Options.getInstance().getOption("matchpairs");
            pairsChars = SearchHelper.parseOption(lo);
            lo.addOptionChangeListener(new OptionChangeListener(){

                public void valueChange(OptionChangeEvent event) {
                    pairsChars = SearchHelper.parseOption((ListOption)event.getOption());
                }
            });
        }
        return pairsChars;
    }

    private static String parseOption(ListOption option) {
        List<String> vals = option.values();
        StringBuffer res = new StringBuffer();
        for (String s : vals) {
            if (s.length() != 3) continue;
            res.append(s.charAt(0)).append(s.charAt(2));
        }
        return res.toString();
    }

    public static class CountPosition {
        private int count;
        private int position;

        public CountPosition(int count, int position) {
            this.count = count;
            this.position = position;
        }

        public int getCount() {
            return this.count;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

